<?php
session_start();
include_once('includes/config.php');
if (!isset($_SESSION['uid'])) {
    header('location:logout.php');
    exit();
}

$userId = $_SESSION['uid'];
$userType = $_SESSION['usertype'];
$msg = "";

// Get upload ID from URL
if (!isset($_GET['upload_id']) || empty($_GET['upload_id'])) {
    header('location:inventory-management.php');
    exit();
}
$uploadId = mysqli_real_escape_string($con, $_GET['upload_id']);

// --- CRUD: DELETE INVENTORY ITEM ---
if (isset($_GET['del_item'])) {
    $itemId = intval($_GET['del_item']);
    $condition = ($userType == 'admin') ? "" : " AND UploadedBy='$userId'";
    $result = mysqli_query($con, "DELETE FROM tblinventory WHERE ID='$itemId' AND UploadId='$uploadId'$condition");
    $msg = $result ? "Item deleted successfully!" : "Error: Unable to delete item!";
}

// --- DELETE SELECTED ITEMS ---
if (isset($_POST['delete_selected'])) {
    if (isset($_POST['selected_items']) && !empty($_POST['selected_items'])) {
        $selectedIds = array_map('intval', $_POST['selected_items']);
        $selectedIdsStr = implode(',', $selectedIds);
        
        $condition = ($userType == 'admin') ? "" : " AND UploadedBy='$userId'";
        $result = mysqli_query($con, "DELETE FROM tblinventory WHERE ID IN ($selectedIdsStr) AND UploadId='$uploadId'$condition");
        
        if ($result) {
            $deletedCount = mysqli_affected_rows($con);
            $msg = "$deletedCount items deleted successfully!";
        } else {
            $msg = "Error: Unable to delete selected items!";
        }
    } else {
        $msg = "Please select items to delete.";
    }
}

// --- GENERATE BARCODE PRINT DATA ---
if (isset($_POST['print_selected'])) {
    if (isset($_POST['selected_items']) && !empty($_POST['selected_items'])) {
        $selectedIds = implode(',', array_map('intval', $_POST['selected_items']));
        $printQuery = mysqli_query($con, "SELECT * FROM tblinventory WHERE ID IN ($selectedIds) AND UploadId='$uploadId'");
        
        $printData = [];
        while ($printRow = mysqli_fetch_assoc($printQuery)) {
            $printData[] = $printRow;
        }
        
        // Generate print commands
        $printCommands = [];
        foreach ($printData as $item) {
            $prnTemplate = file_exists('OUTPUTF.prn') ? file_get_contents('OUTPUTF.prn') : 
                "SIZE 60 mm, 30 mm\nGAP 3 mm, 0 mm\nCLS\nTEXT 5,5,\"3\",0,1,1,\"APR 22 P01 00001\"\nTEXT 5,50,\"2\",0,1,1,\"ITEM\"\nTEXT 5,80,\"2\",0,1,1,\"PROJECT\"\nTEXT 5,110,\"2\",0,1,1,\"ROOM\"\nTEXT 5,140,\"2\",0,1,1,\"QTY: COUNT1\"\nPRINT 1\n";
            
            $printCommand = str_replace([
                'APR 22 P01 00001', 'ITEM', 'PROJECT', 'ROOM', 'COUNT1'
            ], [
                $item['Barcode'], $item['ProductName'], $item['ProjectName'], $item['RoomNo'], $item['Qty']
            ], $prnTemplate);
            
            $printCommands[] = $printCommand;
        }
        
        $_SESSION['print_commands'] = $printCommands;
        $msg = count($printData) . " items prepared for printing.";
    } else {
        $msg = "Please select items to print.";
    }
}

// Get upload info
$uploadInfoQuery = mysqli_query($con, "SELECT u.FullName, MIN(i.UploadDate) as UploadDate, COUNT(*) as TotalItems 
                                      FROM tblinventory i 
                                      LEFT JOIN tblusers u ON i.UploadedBy=u.ID 
                                      WHERE i.UploadId='$uploadId' 
                                      GROUP BY u.FullName");
$uploadInfo = mysqli_fetch_assoc($uploadInfoQuery);

// Fetch inventory items for this upload
$inventoryQuery = "SELECT i.*, u.FullName FROM tblinventory i 
                   LEFT JOIN tblusers u ON i.UploadedBy=u.ID 
                   WHERE i.UploadId='$uploadId'
                   ORDER BY i.ID ASC";
$inventory = mysqli_query($con, $inventoryQuery);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Ihita Industries | View Inventory Items</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="css/sb-admin-2.min.css" rel="stylesheet">
    <style>
        /* ...existing styles... */
    </style>
</head>
<body id="page-top">
    <div id="wrapper">
        <?php include_once('includes/sidebar.php');?>
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include_once('includes/topbar.php');?>
                <div class="container-fluid mt-3 mb-3">
             
                    <?php if($msg) { ?>
                        <div class="alert alert-info text-center"><?php echo $msg; ?></div>
                    <?php } ?>

                    <!-- Upload Info -->
                    <div class="card shadow mb-4">
                        <div class="card-header bg-info text-white">
                            <h5 class="mb-0">Upload Details: <?php echo htmlspecialchars($uploadId); ?></h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-3">
                                    <strong>Uploaded By:</strong><br>
                                    <?php echo htmlspecialchars($uploadInfo['FullName']); ?>
                                </div>
                                <div class="col-md-3">
                                    <strong>Upload Date:</strong><br>
                                    <?php echo htmlspecialchars($uploadInfo['UploadDate']); ?>
                                </div>
                                <div class="col-md-3">
                                    <strong>Total Items:</strong><br>
                                    <?php echo $uploadInfo['TotalItems']; ?>
                                </div>
                                <div class="col-md-3">
                                    <a href="inventory-management.php" class="btn btn-secondary">
                                        <i class="fas fa-arrow-left"></i> Back to Uploads
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Inventory Items Table -->
                    <div class="card shadow mb-4">
                        <div class="card-header bg-success text-white">
                            <div class="row align-items-center">
                                <div class="col">
                                    <h5 class="mb-0">Inventory Items</h5>
                                </div>
                                <div class="col-auto">
                                    <button type="button" class="btn btn-light btn-sm" onclick="selectAll()">
                                        <i class="fas fa-check-square"></i> Select All
                                    </button>
                                    <button type="button" class="btn btn-light btn-sm" onclick="deselectAll()">
                                        <i class="fas fa-square"></i> Deselect All
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="card-body p-2">
                            <form method="post" id="bulkActionForm">
                                <div class="mb-3">
                                    <button type="submit" name="print_selected" class="btn btn-warning">
                                        <i class="fas fa-print"></i> Print Selected Items
                                    </button>
                                    <button type="submit" name="delete_selected" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete the selected items? This action cannot be undone.');">
                                        <i class="fas fa-trash"></i> Delete Selected Items
                                    </button>
                                </div>
                                <div class="table-responsive">
                                    <table class="table table-bordered table-sm mb-0">
                                        <thead class="thead-light">
                                            <tr>
                                                <th><input type="checkbox" id="selectAllCheckbox" onchange="toggleAll()"></th>
                                                <th>#</th>
                                                <th>Barcode</th>
                                                <th>Product Name</th>
                                                <th>Qty</th>
                                                <th>Room No</th>
                                                <th>Project Name</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <?php $i=1; while($row = mysqli_fetch_assoc($inventory)) { ?>
                                            <tr>
                                                <td data-label="Select">
                                                    <input type="checkbox" name="selected_items[]" value="<?php echo $row['ID']; ?>" class="item-checkbox">
                                                </td>
                                                <td data-label="#"><?php echo $i++; ?></td>
                                                <td data-label="Barcode"><?php echo htmlspecialchars($row['Barcode']); ?></td>
                                                <td data-label="Product Name"><?php echo htmlspecialchars($row['ProductName']); ?></td>
                                                <td data-label="Qty"><?php echo $row['Qty']; ?></td>
                                                <td data-label="Room No"><?php echo htmlspecialchars($row['RoomNo']); ?></td>
                                                <td data-label="Project Name"><?php echo htmlspecialchars($row['ProjectName']); ?></td>
                                                <td data-label="Actions">
                                                    <?php if($userType == 'admin' || $row['UploadedBy'] == $userId) { ?>
                                                        <a href="view-inventory-items.php?upload_id=<?php echo urlencode($uploadId); ?>&del_item=<?php echo $row['ID']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this item?');" title="Delete">
                                                            <i class="fas fa-trash"></i>
                                                        </a>
                                                    <?php } else { ?>
                                                        <span class="text-muted">-</span>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <?php include_once('includes/footer.php');?>
        </div>
    </div>
    <?php include_once('includes/footer2.php');?>
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="js/sb-admin-2.min.js"></script>
    
    <script>
        function toggleAll() {
            const selectAllCheckbox = document.getElementById('selectAllCheckbox');
            const itemCheckboxes = document.querySelectorAll('.item-checkbox');
            itemCheckboxes.forEach(checkbox => {
                checkbox.checked = selectAllCheckbox.checked;
            });
        }
        
        function selectAll() {
            document.getElementById('selectAllCheckbox').checked = true;
            toggleAll();
        }
        
        function deselectAll() {
            document.getElementById('selectAllCheckbox').checked = false;
            toggleAll();
        }

        <?php if(isset($_SESSION['print_commands']) && !empty($_SESSION['print_commands'])) { ?>
            const printCommands = <?php echo json_encode($_SESSION['print_commands']); ?>;
            console.log('Print Commands:', printCommands);
            <?php unset($_SESSION['print_commands']); ?>
        <?php } ?>
    </script>
</body>
</html>
