<?php
// Printer diagnostic script
echo "<h2>TSC TTP-244 Pro Printer Diagnostic</h2>";

// Test 1: Check if printer is visible in Windows
echo "<h3>1. Available Printers:</h3>";
$output = [];
exec('wmic printer get name,status,default /format:table 2>&1', $output);
foreach ($output as $line) {
    echo htmlspecialchars($line) . "<br>";
}

// Test 2: Try to create a simple test file
echo "<h3>2. Creating Test Print File:</h3>";
$testContent = "SIZE 50.5 mm, 150 mm\nCLS\nTEXT 50,50,\"ROMAN.TTF\",0,1,12,\"TEST PRINT\"\nPRINT 1\n";
$testFile = tempnam(sys_get_temp_dir(), 'tsc_test_') . '.prn';
file_put_contents($testFile, $testContent);
echo "Test file created: " . $testFile . "<br>";

// Test 3: Try different print methods
echo "<h3>3. Testing Print Methods:</h3>";

$methods = [
    "copy /B \"$testFile\" \"\\\\localhost\\TSC TTP-244 Pro\"",
    "print /D:\"TSC TTP-244 Pro\" \"$testFile\"",
    "net use LPT1: \"\\\\localhost\\TSC TTP-244 Pro\"",
];

foreach ($methods as $i => $method) {
    echo "<strong>Method " . ($i + 1) . ":</strong> " . htmlspecialchars($method) . "<br>";
    $output = [];
    $returnVar = 0;
    exec($method . " 2>&1", $output, $returnVar);
    echo "Return code: $returnVar<br>";
    echo "Output: " . htmlspecialchars(implode(' ', $output)) . "<br><br>";
}

// Test 4: Check printer spooler
echo "<h3>4. Printer Spooler Status:</h3>";
$output = [];
exec('sc query spooler 2>&1', $output);
foreach ($output as $line) {
    echo htmlspecialchars($line) . "<br>";
}

// Cleanup
if (file_exists($testFile)) {
    unlink($testFile);
    echo "<br>Test file cleaned up.";
}

echo "<hr><p><strong>Instructions:</strong></p>";
echo "<ol>";
echo "<li>Make sure your TSC TTP-244 Pro printer is properly installed in Windows</li>";
echo "<li>Check that the printer name exactly matches 'TSC TTP-244 Pro' in Windows</li>";
echo "<li>Ensure the printer is set as 'Ready' or 'Online'</li>";
echo "<li>Try printing a test page from Windows first</li>";
echo "<li>If using USB, make sure the printer driver creates a virtual port</li>";
echo "</ol>";
?>
