<?php
session_start();
include_once('includes/config.php');
if (!isset($_SESSION['uid'])) {
    header('location:logout.php');
    exit();
}

// Get filters from GET
$dateFrom = isset($_GET['date_from']) ? $_GET['date_from'] : date('Y-m-01');
$dateTo = isset($_GET['date_to']) ? $_GET['date_to'] : date('Y-m-d');
$projectFilter = isset($_GET['project']) ? mysqli_real_escape_string($con, $_GET['project']) : '';
$roomFilter = isset($_GET['room']) ? mysqli_real_escape_string($con, $_GET['room']) : '';
$productFilter = isset($_GET['product']) ? mysqli_real_escape_string($con, $_GET['product']) : '';
$packageFilter = isset($_GET['package']) ? mysqli_real_escape_string($con, $_GET['package']) : '';
$userFilter = isset($_GET['user']) ? mysqli_real_escape_string($con, $_GET['user']) : '';

// Build WHERE conditions for main query (with alias)
$whereConditions = [];
$whereConditions[] = "p.PackedDate BETWEEN '$dateFrom 00:00:00' AND '$dateTo 23:59:59'";
if (!empty($projectFilter)) $whereConditions[] = "p.ProjectName LIKE '%$projectFilter%'";
if (!empty($roomFilter)) $whereConditions[] = "p.RoomNo LIKE '%$roomFilter%'";
if (!empty($productFilter)) $whereConditions[] = "p.ProductName LIKE '%$productFilter%'";
if (!empty($packageFilter)) $whereConditions[] = "(p.PackageId LIKE '%$packageFilter%' OR p.PackageName LIKE '%$packageFilter%')";
if (!empty($userFilter) && $userFilter !== 'all') $whereConditions[] = "p.PackedBy = '$userFilter'";
$whereClause = !empty($whereConditions) ? "WHERE " . implode(" AND ", $whereConditions) : "";

// Build WHERE conditions for header query (no alias)
$whereConditionsNoAlias = [];
$whereConditionsNoAlias[] = "PackedDate BETWEEN '$dateFrom 00:00:00' AND '$dateTo 23:59:59'";
if (!empty($projectFilter)) $whereConditionsNoAlias[] = "ProjectName LIKE '%$projectFilter%'";
if (!empty($roomFilter)) $whereConditionsNoAlias[] = "RoomNo LIKE '%$roomFilter%'";
if (!empty($productFilter)) $whereConditionsNoAlias[] = "ProductName LIKE '%$productFilter%'";
if (!empty($packageFilter)) $whereConditionsNoAlias[] = "(PackageId LIKE '%$packageFilter%' OR PackageName LIKE '%$packageFilter%')";
if (!empty($userFilter) && $userFilter !== 'all') $whereConditionsNoAlias[] = "PackedBy = '$userFilter'";
$whereClauseNoAlias = !empty($whereConditionsNoAlias) ? "WHERE " . implode(" AND ", $whereConditionsNoAlias) : "";

// Query for packing list, order by bundle number ascending
$query = "
    SELECT 
        p.PackageName,
        p.ProductName,
        p.PackedQty,
        p.PackedWeight,
        p.RoomNo,
        p.PackedDate,
        u.FullName as PackedBy,
        CASE 
            WHEN i.Qty IS NULL THEN 'Product Not Found'
            WHEN p.PackedQty > i.Qty THEN 'Over Packed'
            ELSE 'Normal'
        END as PackingStatus,
        p.Barcode
    FROM tblpacked p
    LEFT JOIN tblusers u ON p.PackedBy = u.ID
    LEFT JOIN tblinventory i ON p.ProductId = i.ID
    $whereClause
    ORDER BY CAST(p.PackageName AS UNSIGNED) ASC, p.PackageName ASC, p.PackedDate ASC
";
$result = mysqli_query($con, $query);

// For header
$projectName = '';
if (!empty($projectFilter)) {
    $projectName = $projectFilter;
} else {
    $row = mysqli_fetch_assoc(mysqli_query($con, "SELECT ProjectName FROM tblpacked $whereClauseNoAlias LIMIT 1"));
    $projectName = $row ? $row['ProjectName'] : '';
}
$projectTitle = $projectName ? $projectName . " Packing List" : "Packing List";

// For sum row
$totalQty = 0;
$totalWeight = 0;
$rows = [];
if ($result) {
    while ($row = mysqli_fetch_assoc($result)) {
        $rows[] = $row;
        $totalQty += $row['PackedQty'];
        $totalWeight += $row['PackedWeight'];
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title><?php echo htmlspecialchars($projectTitle); ?></title>
    <style>
        @media print {
            body { margin: 0; background: #fff; }
            .no-print { display: none; }
            .a4-sheet { box-shadow: none !important; border: none !important; }
        }
        body {
            font-family: 'Arial Narrow', Arial, sans-serif;
            margin: 0;
            background: #fff;
        }
        .a4-sheet {
            width: 210mm;
            min-height: 297mm;
            margin: 0 auto;
            padding: 10mm 5mm;
            background: #fff;
            box-sizing: border-box;
            border-radius: 0;
            border: 1px solid #e0e0e0;
            box-shadow: none;
        }
        h2 {
            text-align: center;
            margin-bottom: 0;
            font-size: 17px;
            font-weight: 700;
            letter-spacing: 1px;
            color: #222;
            font-family: 'Arial Narrow', Arial, sans-serif;
        }
        .subtitle {
            text-align: center;
            font-size: 11px;
            margin-bottom: 10px;
            color: #444;
            font-weight: 400;
            font-family: 'Arial Narrow', Arial, sans-serif;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 11px;
            margin-bottom: 10px;
            background: #fff;
        }
        th, td {
            border: 1px solid #bfc9d1;
            padding: 2px 3px;
            text-align: center;
            vertical-align: middle;
            font-family: 'Arial Narrow', Arial, sans-serif;
            white-space: nowrap;
        }
        th {
            background: #f2f2f2;
            font-weight: 700;
            color: #222;
            font-size: 11px;
            letter-spacing: 0.2px;
        }
        tbody tr {
            background: #fff;
        }
        tfoot td {
            font-weight: bold;
            background: #f2f2f2;
            color: #222;
            border-top: 2px solid #22304a;
            font-size: 11px;
        }
        .footer {
            text-align: right;
            font-size: 10px;
            color: #888;
            margin-top: 8px;
            font-style: italic;
            font-family: 'Arial Narrow', Arial, sans-serif;
        }
        /* Remove extra spacing for compact look */
        .a4-sheet, table, th, td {
            line-height: 1.1;
        }
    </style>
</head>
<body>
<div class="a4-sheet">
    <h2><?php echo htmlspecialchars($projectTitle); ?></h2>
    <div class="subtitle">
        <?php if ($projectName) { ?>
            Project: <b><?php echo htmlspecialchars($projectName); ?></b> &nbsp;|&nbsp;
        <?php } ?>
        Date: <?php echo date('d-m-Y', strtotime($dateFrom)); ?> to <?php echo date('d-m-Y', strtotime($dateTo)); ?>
    </div>
    <table>
        <thead>
            <tr>
                <th>Sl No</th>
                <th>Barcode</th>
                <th>Description</th>
                <th>Qty</th>
                <th>Weight</th>
                <th>Room</th>
                <th>Bundle No</th>
                <th>Date</th>
                <th>Packed By</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php if (count($rows) == 0) { ?>
                <tr><td colspan="10">No data found</td></tr>
            <?php } else { 
                $sl = 1;
                foreach ($rows as $row) { ?>
                <tr>
                    <td><?php echo $sl++; ?></td>
                    <td><?php echo isset($row['Barcode']) ? htmlspecialchars($row['Barcode']) : ''; ?></td>
                    <td style="text-align:left;"><?php echo htmlspecialchars($row['ProductName']); ?></td>
                    <td><?php echo number_format($row['PackedQty']); ?></td>
                    <td><?php echo number_format($row['PackedWeight'], 2); ?></td>
                    <td><?php echo htmlspecialchars($row['RoomNo']); ?></td>
                    <td><?php echo htmlspecialchars($row['PackageName']); ?></td>
                    <td><?php echo date('d-m-Y', strtotime($row['PackedDate'])); ?></td>
                    <td><?php echo htmlspecialchars($row['PackedBy']); ?></td>
                    <td>
                        <span style="font-weight:600;color:#2e7d32;">Packed</span>
                    </td>
                </tr>
            <?php }} ?>
        </tbody>
        <tfoot>
            <tr>
                <td colspan="3">Total</td>
                <td><?php echo number_format($totalQty); ?></td>
                <td><?php echo number_format($totalWeight, 2); ?></td>
                <td colspan="5"></td>
            </tr>
        </tfoot>
    </table>
    <div class="footer no-print">
        Printed on: <?php echo date('d-m-Y H:i'); ?>
    </div>
</div>
</body>
</html>
</html>
</html>
</html>
