<?php
session_start();
include_once('includes/config.php');
if (!isset($_SESSION['uid'])) {
    header('location:logout.php');
    exit();
}

$userId = $_SESSION['uid'];
$userType = $_SESSION['usertype'];
$packageId = isset($_GET['package_id']) ? mysqli_real_escape_string($con, $_GET['package_id']) : '';

if (empty($packageId)) {
    header('location:packed-packages.php');
    exit();
}

// Fetch package details
$condition = ($userType == 'admin') ? "" : " AND PackedBy='$userId'";
$packageQuery = "SELECT p.*, u.FullName FROM tblpacked p 
                 LEFT JOIN tblusers u ON p.PackedBy=u.ID 
                 WHERE p.PackageId='$packageId'$condition";
$packageDetails = mysqli_query($con, $packageQuery);

if (mysqli_num_rows($packageDetails) == 0) {
    header('location:packed-packages.php');
    exit();
}

// Get package summary
$summaryQuery = "SELECT PackageName, COUNT(*) as ItemCount, SUM(PackedQty) as TotalQty, 
                 PackedDate, FullName as PackedBy 
                 FROM tblpacked p 
                 LEFT JOIN tblusers u ON p.PackedBy=u.ID 
                 WHERE PackageId='$packageId'$condition 
                 GROUP BY PackageName, PackedDate, FullName";
$summary = mysqli_fetch_assoc(mysqli_query($con, $summaryQuery));
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Ihita Industries | Package Details - <?php echo htmlspecialchars($packageId); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="css/sb-admin-2.min.css" rel="stylesheet">
</head>
<body id="page-top">
    <div id="wrapper">
        <?php include_once('includes/sidebar.php');?>
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include_once('includes/topbar.php');?>
                <div class="container-fluid mt-3 mb-3">
                    
                    <!-- Package Summary -->
                    <div class="card shadow mb-4">
                        <div class="card-header bg-info text-white">
                            <h5 class="mb-0">Package Information: <?php echo htmlspecialchars($packageId); ?></h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-3">
                                    <strong>Package Name:</strong><br><?php echo htmlspecialchars($summary['PackageName']); ?>
                                </div>
                                <div class="col-md-2">
                                    <strong>Total Items:</strong><br><?php echo $summary['ItemCount']; ?>
                                </div>
                                <div class="col-md-2">
                                    <strong>Total Quantity:</strong><br><?php echo $summary['TotalQty']; ?>
                                </div>
                                <div class="col-md-3">
                                    <strong>Packed By:</strong><br><?php echo htmlspecialchars($summary['PackedBy']); ?>
                                </div>
                                <div class="col-md-2">
                                    <strong>Packed Date:</strong><br><?php echo date('Y-m-d H:i', strtotime($summary['PackedDate'])); ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Package Items -->
                    <div class="card shadow mb-4">
                        <div class="card-header bg-success text-white">
                            <h5 class="mb-0">Package Items</h5>
                        </div>
                        <div class="card-body p-2">
                            <div class="table-responsive">
                                <table class="table table-bordered table-sm mb-0">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>#</th>
                                            <th>Barcode</th>
                                            <th>Product Name</th>
                                            <th>Room No</th>
                                            <th>Project Name</th>
                                            <th>Packed Qty</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        mysqli_data_seek($packageDetails, 0);
                                        $i=1; 
                                        while($row = mysqli_fetch_assoc($packageDetails)) { 
                                        ?>
                                            <tr>
                                                <td><?php echo $i++; ?></td>
                                                <td><?php echo htmlspecialchars($row['Barcode']); ?></td>
                                                <td><?php echo htmlspecialchars($row['ProductName']); ?></td>
                                                <td><?php echo htmlspecialchars($row['RoomNo']); ?></td>
                                                <td><?php echo htmlspecialchars($row['ProjectName']); ?></td>
                                                <td><?php echo $row['PackedQty']; ?></td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <a href="packed-packages.php" class="btn btn-secondary btn-block">
                        <i class="fas fa-arrow-left"></i> Back to Packed Packages
                    </a>
                </div>
            </div>
            <?php include_once('includes/footer.php');?>
        </div>
    </div>
    <?php include_once('includes/footer2.php');?>
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="js/sb-admin-2.min.js"></script>
</body>
</html>
