<?php
session_start();
include_once('includes/config.php');
if (!isset($_SESSION['uid'])) {
    header('location:logout.php');
    exit();
}

$userId = $_SESSION['uid'];
$userType = $_SESSION['usertype'];
$msg = "";

// --- CREATE TABLE IF NOT EXISTS ---
$createTableQuery = "CREATE TABLE IF NOT EXISTS `tblinventory` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `UploadId` varchar(50) NOT NULL,
  `Barcode` varchar(100) NOT NULL,
  `ProductName` varchar(255) NOT NULL,
  `Qty` int(11) NOT NULL,
  `Weight` decimal(10,2) NOT NULL DEFAULT '0.00',
  `RoomNo` varchar(50) NOT NULL,
  `ProjectName` varchar(255) NOT NULL,
  `UploadedBy` int(11) NOT NULL,
  `UploadDate` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`ID`),
  KEY `UploadedBy` (`UploadedBy`),
  KEY `UploadId` (`UploadId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";

mysqli_query($con, $createTableQuery);

// --- DELETE UPLOAD ---
if (isset($_GET['del_upload'])) {
    $uploadId = mysqli_real_escape_string($con, $_GET['del_upload']);
    $condition = ($userType == 'admin') ? "" : " AND UploadedBy='$userId'";
    $result = mysqli_query($con, "DELETE FROM tblinventory WHERE UploadId='$uploadId'$condition");
    if ($result) {
        $deletedCount = mysqli_affected_rows($con);
        $msg = "Upload deleted successfully! $deletedCount items removed.";
    } else {
        $msg = "Error: Unable to delete upload!";
    }
}

// --- CSV/EXCEL UPLOAD ---
if (isset($_POST['upload_excel'])) {
    if (isset($_FILES['excel_file']) && $_FILES['excel_file']['error'] == UPLOAD_ERR_OK) {
        $uploadId = 'UPL_' . date('YmdHis') . '_' . $userId;
        
        // Check if this upload ID already exists (prevent duplicates)
        $checkQuery = mysqli_query($con, "SELECT COUNT(*) as count FROM tblinventory WHERE UploadId='$uploadId'");
        $checkResult = mysqli_fetch_assoc($checkQuery);
        
        if ($checkResult['count'] > 0) {
            // Generate a new unique upload ID with microseconds
            $uploadId = 'UPL_' . date('YmdHis') . '_' . microtime(true) . '_' . $userId;
        }
        
        $fileTmpPath = $_FILES['excel_file']['tmp_name'];
        $fileName = $_FILES['excel_file']['name'];
        $fileExtension = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
        
        $successCount = 0;
        $errorCount = 0;
        
        // Handle CSV files directly
        if ($fileExtension == 'csv') {
            if (($handle = fopen($fileTmpPath, 'r')) !== FALSE) {
                $rowIndex = 0;
                while (($row = fgetcsv($handle, 1000, ',')) !== FALSE) {
                    $rowIndex++;
                    
                    // Skip header row
                    if ($rowIndex == 1) continue;
                    
                    // Check if row has required data (now 6 columns including weight)
                    if (count($row) >= 6 && !empty(trim($row[0]))) {
                        $barcode = mysqli_real_escape_string($con, trim($row[0]));
                        $productName = mysqli_real_escape_string($con, trim($row[1]));
                        $qty = intval(trim($row[2]));
                        $weight = floatval(trim($row[3])); // New weight column
                        $roomNo = mysqli_real_escape_string($con, trim($row[4]));
                        $projectName = mysqli_real_escape_string($con, trim($row[5]));
                        
                        // Validate data
                        if ($qty <= 0) {
                            $errorCount++;
                            continue;
                        }
                        
                        // If no weight provided, calculate default (1kg per unit)
                        if ($weight <= 0) {
                            $weight = $qty * 1.0; // Default 1kg per unit
                        }
                        
                        $sql = "INSERT INTO tblinventory (UploadId, Barcode, ProductName, Qty, Weight, RoomNo, ProjectName, UploadedBy) 
                                VALUES ('$uploadId', '$barcode', '$productName', '$qty', '$weight', '$roomNo', '$projectName', '$userId')";
                        
                        if (mysqli_query($con, $sql)) {
                            $successCount++;
                        } else {
                            $errorCount++;
                            error_log("SQL Error: " . mysqli_error($con) . " - Query: $sql");
                        }
                    } else {
                        $errorCount++;
                    }
                }
                fclose($handle);
                $msg = "CSV uploaded successfully! $successCount items added, $errorCount errors.";
                
                // Redirect to prevent form resubmission on refresh
                $_SESSION['upload_msg'] = $msg;
                header('Location: inventory-management.php');
                exit();
            } else {
                $msg = "Error reading CSV file.";
            }
        } else {
            $msg = "Please upload a CSV file. Excel files require additional setup. Save your Excel file as CSV format and try again.";
        }
    } else {
        $msg = "Please select a valid file.";
    }
}

// Check for upload message from redirect
if (isset($_SESSION['upload_msg'])) {
    $msg = $_SESSION['upload_msg'];
    unset($_SESSION['upload_msg']);
}

// Date filtering
$fromDate = isset($_GET['from_date']) ? $_GET['from_date'] : '';
$toDate = isset($_GET['to_date']) ? $_GET['to_date'] : '';

// Build date filter condition
$dateCondition = "";
if (!empty($fromDate) && !empty($toDate)) {
    $fromDate = mysqli_real_escape_string($con, $fromDate);
    $toDate = mysqli_real_escape_string($con, $toDate);
    $dateCondition = " WHERE DATE(MIN(UploadDate)) BETWEEN '$fromDate' AND '$toDate' ";
} elseif (!empty($fromDate)) {
    $fromDate = mysqli_real_escape_string($con, $fromDate);
    $dateCondition = " WHERE DATE(MIN(UploadDate)) >= '$fromDate' ";
} elseif (!empty($toDate)) {
    $toDate = mysqli_real_escape_string($con, $toDate);
    $dateCondition = " WHERE DATE(MIN(UploadDate)) <= '$toDate' ";
}

// Fetch upload-wise data with date filtering
$uploadsQuery = "SELECT 
    UploadId,
    COUNT(*) as ItemCount,
    SUM(Qty) as TotalQty,
    SUM(Weight) as TotalWeight,
    MIN(UploadDate) as UploadDate,
    u.FullName as UploadedBy
    FROM tblinventory i 
    LEFT JOIN tblusers u ON i.UploadedBy=u.ID 
    GROUP BY UploadId, i.UploadedBy, u.FullName
    $dateCondition
    ORDER BY MIN(UploadDate) DESC";
$uploads = mysqli_query($con, $uploadsQuery);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Ihita Industries | Production Upload</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="css/sb-admin-2.min.css" rel="stylesheet">
    <style>
        .card { 
            border-radius: 1.5rem; 
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
            border: none;
            margin-bottom: 2rem;
        }
        .card-header { 
            border-radius: 1.5rem 1.5rem 0 0; 
            padding: 1.5rem;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .card-header.bg-primary {
            background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        }
        .card-header.bg-info {
            background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);
        }
        .card-header.bg-success {
            background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
        }
        .form-control { 
            font-size: 1rem; 
            border-radius: 1rem; 
            padding: 0.875rem 1.25rem;
            border: 2px solid #e3e6f0;
            transition: all 0.3s ease;
        }
        .form-control:focus {
            border-color: #4e73df;
            box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
        }
        .btn { 
            font-size: 1rem; 
            border-radius: 1rem; 
            padding: 0.75rem 1.5rem;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        .btn-block { 
            padding: 1rem 0; 
            border-radius: 1rem;
        }
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 0.25rem 0.5rem rgba(0, 0, 0, 0.2);
        }
        .table th, .table td { 
            vertical-align: middle !important; 
            padding: 1rem 0.75rem;
        }
        .table th {
            background: linear-gradient(135deg, #f8f9fc 0%, #e9ecef 100%);
            font-weight: 600;
            border-top: none;
        }
        .table-responsive {
            border-radius: 1rem;
            overflow: hidden;
        }
        .alert {
            border-radius: 1rem;
            border: none;
            font-weight: 500;
        }
        .form-group {
            margin-bottom: 1.5rem;
        }
        .form-group label {
            font-weight: 600;
            color: #5a5c69;
            margin-bottom: 0.5rem;
        }
        
        /* Mobile Styles */
        @media (max-width: 991.98px) {
            .container-fluid { 
                padding-left: 1rem; 
                padding-right: 1rem; 
            }
            .card { 
                margin-bottom: 1.5rem; 
                border-radius: 1rem;
            }
            .card-header {
                padding: 1rem;
                border-radius: 1rem 1rem 0 0;
            }
            .card-body {
                padding: 1.5rem;
            }
        }
        
        @media (max-width: 767.98px) {
            .container-fluid { 
                padding-left: 0.75rem; 
                padding-right: 0.75rem; 
            }
            .card { 
                margin-bottom: 1.25rem;
                border-radius: 0.75rem;
            }
            .card-header {
                padding: 0.75rem;
                border-radius: 0.75rem 0.75rem 0 0;
            }
            .card-body {
                padding: 1rem;
            }
            .table-responsive { 
                font-size: 0.875rem;
                border-radius: 0.75rem;
            }
            .table th, .table td {
                padding: 0.5rem 0.25rem;
                font-size: 0.8rem;
            }
            .btn, .btn-block { 
                font-size: 0.9rem; 
                padding: 0.6rem 1rem; 
                border-radius: 0.75rem;
            }
            .btn-sm {
                font-size: 0.75rem;
                padding: 0.25rem 0.5rem;
            }
            .card-header h4, .card-header h5 { 
                font-size: 1rem; 
                margin-bottom: 0;
            }
            .form-control {
                font-size: 0.9rem;
                padding: 0.75rem 1rem;
                border-radius: 0.75rem;
            }
            .form-group {
                margin-bottom: 1rem;
            }
            .alert {
                font-size: 0.9rem;
                padding: 0.75rem;
            }
        }
        
        @media (max-width: 575.98px) {
            .table-responsive {
                border-radius: 0.5rem;
            }
            .table th, .table td {
                padding: 0.4rem 0.2rem;
                font-size: 0.75rem;
            }
            .btn-sm {
                font-size: 0.7rem;
                padding: 0.2rem 0.4rem;
                margin: 0.1rem;
            }
            .card {
                border-radius: 0.5rem;
            }
            .card-header {
                border-radius: 0.5rem 0.5rem 0 0;
                padding: 0.5rem;
            }
            .card-body {
                padding: 0.75rem;
            }
            /* Stack table for very small screens */
            .table-responsive table,
            .table-responsive thead,
            .table-responsive tbody,
            .table-responsive th,
            .table-responsive td,
            .table-responsive tr {
                display: block;
            }
            .table-responsive thead tr {
                position: absolute;
                top: -9999px;
                left: -9999px;
            }
            .table-responsive tr {
                border: 1px solid #ccc;
                margin-bottom: 0.5rem;
                border-radius: 0.5rem;
                padding: 0.5rem;
                background: #fff;
            }
            .table-responsive td {
                border: none;
                position: relative;
                padding: 0.25rem 0.25rem 0.25rem 30%;
                text-align: left;
            }
            .table-responsive td:before {
                content: attr(data-label) ": ";
                position: absolute;
                left: 0.25rem;
                width: 25%;
                padding-right: 0.5rem;
                white-space: nowrap;
                font-weight: bold;
                color: #5a5c69;
            }
        }
    </style>
</head>
<body id="page-top">
    <div id="wrapper">
        <?php include_once('includes/sidebar.php');?>
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include_once('includes/topbar.php');?>
                <div class="container-fluid mt-3 mb-3">
             
                    <?php if($msg) { ?>
                        <div class="alert alert-info text-center"><?php echo $msg; ?></div>
                    <?php } ?>

                    <!-- CSV Upload Form -->
                    <div class="card shadow mb-4">
                        <div class="card-header bg-primary text-white text-center">
                            <h4 class="mb-0">Upload CSV File</h4>
                            <small>Expected columns: Barcode, Product Name, Qty, Weight, Room No, Project Name</small>
                            <br><small class="mt-1 d-block"><strong>Note:</strong> Save your Excel file as CSV format before uploading</small>
                        </div>
                        <div class="card-body">
                            <div class="alert alert-warning">
                                <strong>Instructions:</strong>
                                <ol class="mb-0 mt-2">
                                    <li>Open your Excel file</li>
                                    <li>Make sure columns are in order: Barcode, Product Name, Qty, Weight, Room No, Project Name</li>
                                    <li>Go to File → Save As → Choose "CSV (Comma delimited)" format</li>
                                    <li>Upload the saved CSV file below</li>
                                </ol>
                            </div>
                            <form method="post" enctype="multipart/form-data" autocomplete="off">
                                <div class="form-group">
                                    <label>Select CSV File (.csv)</label>
                                    <input type="file" name="excel_file" class="form-control" accept=".csv" required>
                                </div>
                                <button type="submit" name="upload_excel" class="btn btn-primary btn-block">
                                    <i class="fas fa-upload"></i> Upload CSV File
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Date Filter Form -->
                    <div class="card shadow mb-4">
                        <div class="card-header bg-info text-white">
                            <h5 class="mb-0">Filter by Date Range</h5>
                        </div>
                        <div class="card-body">
                            <form method="get" class="row align-items-end">
                                <div class="col-md-4">
                                    <div class="form-group mb-2">
                                        <label>From Date</label>
                                        <input type="date" name="from_date" class="form-control" value="<?php echo htmlspecialchars($fromDate); ?>">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group mb-2">
                                        <label>To Date</label>
                                        <input type="date" name="to_date" class="form-control" value="<?php echo htmlspecialchars($toDate); ?>">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group mb-2">
                                        <button type="submit" class="btn btn-info mr-2">
                                            <i class="fas fa-filter"></i> Filter
                                        </button>
                                        <a href="inventory-management.php" class="btn btn-secondary">
                                            <i class="fas fa-times"></i> Clear
                                        </a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- Upload List Table -->
                    <div class="card shadow mb-4">
                        <div class="card-header bg-success text-white">
                            <div class="row align-items-center">
                                <div class="col">
                                    <h5 class="mb-0">Uploaded Batches</h5>
                                    <?php if (!empty($fromDate) || !empty($toDate)) { ?>
                                        <small class="text-light">
                                            Filtered: 
                                            <?php if (!empty($fromDate)) echo "From " . $fromDate; ?>
                                            <?php if (!empty($fromDate) && !empty($toDate)) echo " "; ?>
                                            <?php if (!empty($toDate)) echo "To " . $toDate; ?>
                                        </small>
                                    <?php } ?>
                                </div>
                                <div class="col-auto">
                                    <?php 
                                    $totalBatches = mysqli_num_rows($uploads);
                                    mysqli_data_seek($uploads, 0); // Reset pointer for counting
                                    $totalItems = 0;
                                    $totalQty = 0;
                                    while($countRow = mysqli_fetch_assoc($uploads)) {
                                        $totalItems += $countRow['ItemCount'];
                                        $totalQty += $countRow['TotalQty'];
                                    }
                                    mysqli_data_seek($uploads, 0); // Reset pointer for display
                                    ?>
                                    <small class="text-light">
                                        Total: <?php echo $totalBatches; ?> batches | 
                                        <?php echo $totalItems; ?> items | 
                                        Qty: <?php echo $totalQty; ?>
                                    </small>
                                </div>
                            </div>
                        </div>
                        <div class="card-body p-2">
                            <div class="table-responsive">
                            <table class="table table-bordered table-sm mb-0">
                                <thead class="thead-light">
                                    <tr>
                                        <th>#</th>
                                        <th>Upload ID</th>
                                        <th>Item Count</th>
                                        <th>Total Quantity</th>
                                        <th>Total Weight</th>
                                        <th>Uploaded By</th>
                                        <th>Upload Date</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php $i=1; while($row = mysqli_fetch_assoc($uploads)) { ?>
                                    <tr>
                                        <td data-label="#"><?php echo $i++; ?></td>
                                        <td data-label="Upload ID"><?php echo htmlspecialchars($row['UploadId']); ?></td>
                                        <td data-label="Item Count"><?php echo $row['ItemCount']; ?> items</td>
                                        <td data-label="Total Quantity"><?php echo $row['TotalQty']; ?></td>
                                        <td data-label="Total Weight"><?php echo number_format($row['TotalWeight'], 4); ?> kg</td>
                                        <td data-label="Uploaded By"><?php echo htmlspecialchars($row['UploadedBy']); ?></td>
                                        <td data-label="Upload Date"><?php echo htmlspecialchars($row['UploadDate']); ?></td>
                                        <td data-label="Actions">
                                            <a href="inventory-items.php?upload_id=<?php echo urlencode($row['UploadId']); ?>" class="btn btn-sm btn-info" title="View Items">
                                                <i class="fas fa-eye"></i> View
                                            </a>
                                            <?php if($userType == 'admin' || strpos($row['UploadId'], '_' . $userId) !== false) { ?>
                                                <a href="inventory-management.php?del_upload=<?php echo urlencode($row['UploadId']); ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this entire upload? This will remove all <?php echo $row['ItemCount']; ?> items.');" title="Delete Upload">
                                                    <i class="fas fa-trash"></i> Delete
                                                </a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                                </tbody>
                            </table>
                            </div>
                        </div>
                    </div>

                    <a href="dashboard.php" class="btn btn-link btn-block mt-3">Back to Dashboard</a>
                </div>
            </div>
            <?php include_once('includes/footer.php');?>
        </div>
    </div>
    <?php include_once('includes/footer2.php');?>
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="js/sb-admin-2.min.js"></script>
</body>
</html>
