<?php
// --- DEBUG: Enable error reporting for troubleshooting ---
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
include_once('includes/config.php');
if (!isset($_SESSION['uid'])) {
    header('location:logout.php');
    exit();
}

$userId = $_SESSION['uid'];
$userType = $_SESSION['usertype'];
$msg = "";
$uploadId = isset($_GET['upload_id']) ? mysqli_real_escape_string($con, $_GET['upload_id']) : '';

if (empty($uploadId)) {
    header('location:inventory-management.php');
    exit();
}

// --- CHECK FOR DISABLED FUNCTIONS (exec, shell_exec) ---
$disabled = explode(',', ini_get('disable_functions'));
$disabled = array_map('trim', $disabled);
$execDisabled = in_array('exec', $disabled) || !function_exists('exec');

// --- FUNCTION: GET INSTALLED PRINTERS ---
function getInstalledPrinters() {
    global $execDisabled;
    $printers = [];

    if ($execDisabled) {
        // Return empty and show warning in UI
        return [];
    }

    // Method 1: Using WMI (Windows Management Instrumentation)
    $command = 'wmic printer get name,portname,drivername /format:csv 2>nul';
    $output = [];
    exec($command, $output, $returnVar);
    
    if ($returnVar === 0 && count($output) > 1) {
        foreach ($output as $line) {
            if (!empty(trim($line)) && strpos($line, 'Name') === false) {
                $parts = str_getcsv($line);
                if (count($parts) >= 4 && !empty($parts[3])) {
                    $printers[] = [
                        'name' => trim($parts[3]),
                        'port' => isset($parts[2]) ? trim($parts[2]) : '',
                        'driver' => isset($parts[1]) ? trim($parts[1]) : '',
                        'type' => (strpos(strtolower($parts[2]), 'usb') !== false) ? 'USB' : 'Network'
                    ];
                }
            }
        }
    }
    
    // Method 2: Fallback using PowerShell if WMI fails
    if (empty($printers)) {
        $psCommand = 'powershell "Get-Printer | Select-Object Name,PortName,DriverName | ConvertTo-Csv -NoTypeInformation" 2>nul';
        $psOutput = [];
        exec($psCommand, $psOutput, $psReturnVar);
        
        if ($psReturnVar === 0 && count($psOutput) > 1) {
            for ($i = 1; $i < count($psOutput); $i++) {
                $parts = str_getcsv($psOutput[$i]);
                if (count($parts) >= 3 && !empty($parts[0])) {
                    $printers[] = [
                        'name' => trim($parts[0], '"'),
                        'port' => isset($parts[1]) ? trim($parts[1], '"') : '',
                        'driver' => isset($parts[2]) ? trim($parts[2], '"') : '',
                        'type' => (strpos(strtolower($parts[1]), 'usb') !== false) ? 'USB' : 'Network'
                    ];
                }
            }
        }
    }
    
    return $printers;
}

// --- CRUD: DELETE INVENTORY ITEM ---
if (isset($_GET['del_item'])) {
    $itemId = intval($_GET['del_item']);
    $condition = ($userType == 'admin') ? "" : " AND UploadedBy='$userId'";
    $result = mysqli_query($con, "DELETE FROM tblinventory WHERE ID='$itemId' AND UploadId='$uploadId'$condition");
    $msg = $result ? "Item deleted successfully!" : "Error: Unable to delete item!";
}

// --- CRUD: UPDATE INVENTORY ITEM ---
if (isset($_POST['update_item'])) {
    $itemId = intval($_POST['item_id']);
    $barcode = mysqli_real_escape_string($con, $_POST['barcode']);
    $productName = mysqli_real_escape_string($con, $_POST['product_name']);
    $qty = intval($_POST['qty']);
    $weight = floatval($_POST['weight']);
    $roomNo = mysqli_real_escape_string($con, $_POST['room_no']);
    $projectName = mysqli_real_escape_string($con, $_POST['project_name']);
    
    $condition = ($userType == 'admin') ? "" : " AND UploadedBy='$userId'";
    $result = mysqli_query($con, "UPDATE tblinventory SET Barcode='$barcode', ProductName='$productName', Qty='$qty', Weight='$weight', RoomNo='$roomNo', ProjectName='$projectName' WHERE ID='$itemId' AND UploadId='$uploadId'$condition");
    $msg = $result ? "Item updated successfully!" : "Error: Unable to update item!";
}

// --- GENERATE BARCODE PRINT DATA ---
if (isset($_POST['print_selected'])) {
    if ($execDisabled) {
        // --- ALTERNATIVE: Offer PRN file download if printing is not available ---
        if (isset($_POST['selected_items']) && !empty($_POST['selected_items'])) {
            $selectedIds = implode(',', array_map('intval', $_POST['selected_items']));
            $printQuery = mysqli_query($con, "SELECT * FROM tblinventory WHERE ID IN ($selectedIds) AND UploadId='$uploadId'");
            $printData = [];
            while ($printRow = mysqli_fetch_assoc($printQuery)) {
                $printData[] = $printRow;
            }
            $preparedFiles = [];
            foreach ($printData as $item) {
                $prnTemplate = file_exists('OUTPUTF.prn') ? file_get_contents('OUTPUTF.prn') :
                    "SIZE 50.5 mm, 150 mm\nCLS\nTEXT 195,178,\"ROMAN.TTF\",90,1,15,\"{ROOM}\"\nQRCODE 259,1183,L,8,A,180,M2,S7,\"{BARCODE}\"\nTEXT 314,998,\"0\",180,13,14,\"{BARCODE}\"\nTEXT 277,178,\"ROMAN.TTF\",90,1,15,\"{ITEM}\"\nTEXT 127,178,\"ROMAN.TTF\",90,1,15,\"{PROJECT}\"\nPRINT 1,{QTY}\n";
                $printCommand = str_replace(
                    ['{BARCODE}', '{ITEM}', '{PROJECT}', '{ROOM}', '{QTY}'],
                    [$item['Barcode'], $item['ProductName'], $item['ProjectName'], $item['RoomNo'], $item['Qty']],
                    $prnTemplate
                );
                $basename = 'label_' . $item['ID'] . '_' . time() . '.prn';
                @mkdir('downloads');
                file_put_contents('downloads/' . $basename, $printCommand);
                $preparedFiles[] = $basename;
            }
            if (!empty($preparedFiles)) {
                $links = [];
                foreach ($preparedFiles as $file) {
                    $links[] = "<a href='downloads/$file' download>Download $file</a>";
                }
                $msg = "Printing is not available on this server. The <code>exec</code> function is disabled.<br>"
                    . "You can download the PRN files below and print them using the TSC utility on a Windows PC:<br>"
                    . implode('<br>', $links);
            } else {
                $msg = "No items selected or unable to generate PRN files.";
            }
        } else {
            $msg = "Printing is not available on this server. The <code>exec</code> function is disabled. Please select items to generate PRN files.";
        }
    } else {
        if (isset($_POST['selected_items']) && !empty($_POST['selected_items']) && isset($_POST['selected_printer']) && !empty($_POST['selected_printer'])) {
            $selectedIds = implode(',', array_map('intval', $_POST['selected_items']));
            $selectedPrinter = mysqli_real_escape_string($con, $_POST['selected_printer']);
            $printQuery = mysqli_query($con, "SELECT * FROM tblinventory WHERE ID IN ($selectedIds) AND UploadId='$uploadId'");
            
            $printData = [];
            while ($printRow = mysqli_fetch_assoc($printQuery)) {
                $printData[] = $printRow;
            }
            
            // Generate and send print commands
            $printCommands = [];
            $printSuccess = true;
            $printErrors = [];
            $preparedFiles = [];
            $printLogs = [];

            foreach ($printData as $item) {
                $prnTemplate = file_exists('OUTPUTF.prn') ? file_get_contents('OUTPUTF.prn') : 
                    "SIZE 50.5 mm, 150 mm\nCLS\nTEXT 195,178,\"ROMAN.TTF\",90,1,15,\"{ROOM}\"\nQRCODE 259,1183,L,8,A,180,M2,S7,\"{BARCODE}\"\nTEXT 314,998,\"0\",180,13,14,\"{BARCODE}\"\nTEXT 277,178,\"ROMAN.TTF\",90,1,15,\"{ITEM}\"\nTEXT 127,178,\"ROMAN.TTF\",90,1,15,\"{PROJECT}\"\nPRINT 1,{QTY}\n";
                
                $printCommand = str_replace([
                    '{BARCODE}', '{ITEM}', '{PROJECT}', '{ROOM}', '{QTY}'
                ], [
                    $item['Barcode'], $item['ProductName'], $item['ProjectName'], $item['RoomNo'], $item['Qty']
                ], $prnTemplate);
                
                $printCommands[] = $printCommand;
                
                // Create temporary file for this print job
                $tempFile = tempnam(sys_get_temp_dir(), 'tsc_print_') . '.prn';
                file_put_contents($tempFile, $printCommand);
                $preparedFiles[] = $tempFile;

                // =================== SIMPLIFIED USB PRINTING METHODS ===================
                $output = [];
                $returnVar = 0;
                $commandSuccess = false;
                
                // Method 1: Try PowerShell with Raw Printer Helper (Most reliable for USB printers)
                $psScriptFile = tempnam(sys_get_temp_dir(), 'print_script_') . '.ps1';
                $psScriptContent = <<<'EOT'
Add-Type -AssemblyName System.Drawing
Add-Type -AssemblyName System.Windows.Forms

$printerName = '%PRINTER_NAME%'
$prnFile = '%PRN_FILE%'

try {
    # Read PRN content
    $prnContent = Get-Content $prnFile -Raw -Encoding UTF8

    # Create Raw Printer Helper
    $rawPrinterCode = @"
using System;
using System.IO;
using System.Runtime.InteropServices;

public class RawPrinterHelper {
    [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
    public class DOCINFOA {
        [MarshalAs(UnmanagedType.LPStr)] public string pDocName;
        [MarshalAs(UnmanagedType.LPStr)] public string pOutputFile;
        [MarshalAs(UnmanagedType.LPStr)] public string pDataType;
    }

    [DllImport("winspool.Drv", EntryPoint="OpenPrinterA", SetLastError=true, CharSet=CharSet.Ansi, ExactSpelling=true, CallingConvention=CallingConvention.StdCall)]
    public static extern bool OpenPrinter([MarshalAs(UnmanagedType.LPStr)] string szPrinter, out IntPtr hPrinter, IntPtr pd);

    [DllImport("winspool.Drv", EntryPoint="ClosePrinter", SetLastError=true, ExactSpelling=true, CallingConvention=CallingConvention.StdCall)]
    public static extern bool ClosePrinter(IntPtr hPrinter);

    [DllImport("winspool.Drv", EntryPoint="StartDocPrinterA", SetLastError=true, CharSet=CharSet.Ansi, ExactSpelling=true, CallingConvention=CallingConvention.StdCall)]
    public static extern bool StartDocPrinter(IntPtr hPrinter, Int32 level, [In, MarshalAs(UnmanagedType.LPStruct)] DOCINFOA di);

    [DllImport("winspool.Drv", EntryPoint="EndDocPrinter", SetLastError=true, ExactSpelling=true, CallingConvention=CallingConvention.StdCall)]
    public static extern bool EndDocPrinter(IntPtr hPrinter);

    [DllImport("winspool.Drv", EntryPoint="StartPagePrinter", SetLastError=true, ExactSpelling=true, CallingConvention=CallingConvention.StdCall)]
    public static extern bool StartPagePrinter(IntPtr hPrinter);

    [DllImport("winspool.Drv", EntryPoint="EndPagePrinter", SetLastError=true, ExactSpelling=true, CallingConvention=CallingConvention.StdCall)]
    public static extern bool EndPagePrinter(IntPtr hPrinter);

    [DllImport("winspool.Drv", EntryPoint="WritePrinter", SetLastError=true, ExactSpelling=true, CallingConvention=CallingConvention.StdCall)]
    public static extern bool WritePrinter(IntPtr hPrinter, IntPtr pBytes, Int32 dwCount, out Int32 dwWritten);

    public static bool SendStringToPrinter(string szPrinterName, string szString) {
        IntPtr pBytes;
        Int32 dwCount;
        dwCount = szString.Length;
        pBytes = Marshal.StringToCoTaskMemAnsi(szString);

        Int32 dwWritten = 0;
        IntPtr hPrinter = new IntPtr(0);
        DOCINFOA di = new DOCINFOA();
        bool bSuccess = false;

        di.pDocName = "TSC Raw Document";
        di.pDataType = "RAW";

        if (OpenPrinter(szPrinterName.Normalize(), out hPrinter, IntPtr.Zero)) {
            if (StartDocPrinter(hPrinter, 1, di)) {
                if (StartPagePrinter(hPrinter)) {
                    bSuccess = WritePrinter(hPrinter, pBytes, dwCount, out dwWritten);
                    EndPagePrinter(hPrinter);
                }
                EndDocPrinter(hPrinter);
            }
            ClosePrinter(hPrinter);
        }

        Marshal.FreeCoTaskMem(pBytes);
        return bSuccess;
    }
}
"@

    Add-Type -TypeDefinition $rawPrinterCode -IgnoreWarnings
    $result = [RawPrinterHelper]::SendStringToPrinter($printerName, $prnContent)

    if ($result) {
        Write-Output "SUCCESS: Raw data sent to USB printer successfully"
    } else {
        Write-Output "ERROR: Failed to send raw data to printer"
    }

} catch {
    Write-Output "ERROR: $($_.Exception.Message)"
}
EOT;

                // Replace placeholders with actual values
                $psScriptContent = str_replace(
                    ['%PRINTER_NAME%', '%PRN_FILE%'],
                    [addslashes($selectedPrinter), addslashes($tempFile)],
                    $psScriptContent
                );

                file_put_contents($psScriptFile, $psScriptContent);
                
                $psCommand = "powershell -ExecutionPolicy Bypass -File \"$psScriptFile\" 2>&1";
                exec($psCommand, $output, $returnVar);
                $outputStr = implode(' ', $output);
                $printLogs[] = "PowerShell Raw Print Method - Return: $returnVar | Output: " . $outputStr;
                
                if (strpos($outputStr, 'SUCCESS:') !== false) {
                    $commandSuccess = true;
                }
                
                // Clean up PowerShell script file
                if (file_exists($psScriptFile)) {
                    unlink($psScriptFile);
                }
                
                // Method 2: Try direct port copying if PowerShell method fails
                if (!$commandSuccess) {
                    // Get the printer port information
                    $portCommand = "wmic printer where \"name='$selectedPrinter'\" get portname /value 2>nul";
                    $portOutput = [];
                    exec($portCommand, $portOutput, $portReturn);
                    $printerPort = '';
                    
                    foreach ($portOutput as $line) {
                        if (strpos($line, 'PortName=') !== false) {
                            $printerPort = trim(str_replace('PortName=', '', $line));
                            break;
                        }
                    }
                    
                    if (!empty($printerPort)) {
                        // Try copying directly to the port
                        $output = [];
                        $returnVar = 0;
                        $portCommand = "copy /B \"$tempFile\" \"$printerPort\" 2>&1";
                        exec($portCommand, $output, $returnVar);
                        $outputStr = implode(' ', $output);
                        $printLogs[] = "Direct Port Method - Command: $portCommand | Return: $returnVar | Output: " . $outputStr;
                        
                        if ($returnVar === 0 && (strpos($outputStr, '1 file(s) copied') !== false || strpos($outputStr, 'copied') !== false)) {
                            $commandSuccess = true;
                        }
                    }
                }
                
                // Method 3: Try using Windows NET USE to map printer as network drive
                if (!$commandSuccess) {
                    $netCommand = "net use LPT1: \"\\\\localhost\\$selectedPrinter\" 2>nul && copy /B \"$tempFile\" LPT1: 2>&1 && net use LPT1: /delete 2>nul";
                    $output = [];
                    $returnVar = 0;
                    exec($netCommand, $output, $returnVar);
                    $outputStr = implode(' ', $output);
                    $printLogs[] = "NET USE Method - Command: NET USE mapping | Return: $returnVar | Output: " . $outputStr;
                    
                    if ($returnVar === 0 && strpos($outputStr, 'copied') !== false) {
                        $commandSuccess = true;
                    }
                }

                if (!$commandSuccess) {
                    $printSuccess = false;
                    $printErrors[] = "Failed to print item: " . $item['ProductName'] . " to USB printer: $selectedPrinter";
                }

                // Clean up temp file if print was successful
                if ($commandSuccess && file_exists($tempFile)) {
                    unlink($tempFile);
                }
            }

            if ($printSuccess) {
                $msg = count($printData) . " items sent to USB printer '$selectedPrinter' successfully!";
                foreach ($preparedFiles as $file) {
                    if (file_exists($file)) unlink($file);
                }
            } else {
                $downloadLinks = [];
                foreach ($preparedFiles as $idx => $file) {
                    if (file_exists($file)) {
                        $basename = basename($file);
                        $webFile = "downloads/$basename";
                        @mkdir('downloads');
                        copy($file, $webFile);
                        $downloadLinks[] = "<a href='$webFile' download>Download PRN file for item #" . ($idx+1) . "</a>";
                    }
                }
                $msg = "USB Print job failed or partially failed to printer '$selectedPrinter'.<br>Errors: " . implode('; ', $printErrors)
                    . "<br>" . implode('<br>', $downloadLinks)
                    . "<br><strong>Alternative Solution:</strong> Download the .prn files and use the TSC printer utility, or create a simple VB.NET/C# application similar to your working code to handle USB printing.";
            }

            // Show print logs for admin users
            if ($userType == 'admin' && !empty($printLogs)) {
                $msg .= "<br><details><summary>Show Print Logs (Debug Info)</summary><pre style='font-size:11px'>" . htmlspecialchars(implode("\n", $printLogs)) . "</pre></details>";
            }

            $_SESSION['print_commands'] = $printCommands;
            $_SESSION['print_status'] = $printSuccess ? 'success' : 'error';
        } else {
            if (empty($_POST['selected_printer'])) {
                $msg = "Please select a printer.";
            } else {
                $msg = "Please select items to print.";
            }
        }
    }
}

// --- DELETE SELECTED ITEMS ---
if (isset($_POST['delete_selected'])) {
    if (isset($_POST['selected_items']) && !empty($_POST['selected_items'])) {
        $selectedIds = array_map('intval', $_POST['selected_items']);
        $selectedIdsStr = implode(',', $selectedIds);
        
        $condition = ($userType == 'admin') ? "" : " AND UploadedBy='$userId'";
        $result = mysqli_query($con, "DELETE FROM tblinventory WHERE ID IN ($selectedIdsStr) AND UploadId='$uploadId'$condition");
        
        if ($result) {
            $deletedCount = mysqli_affected_rows($con);
            $msg = "$deletedCount items deleted successfully!";
        } else {
            $msg = "Error: Unable to delete selected items!";
        }
    } else {
        $msg = "Please select items to delete.";
    }
}

// Get item data for editing
$editItem = null;
if (isset($_GET['edit_item'])) {
    $editId = intval($_GET['edit_item']);
    $condition = ($userType == 'admin') ? "" : " AND UploadedBy='$userId'";
    $editResult = mysqli_query($con, "SELECT * FROM tblinventory WHERE ID='$editId' AND UploadId='$uploadId'$condition");
    if ($editResult === false) {
        // Debug: Show SQL error
        $msg = "Database error: " . mysqli_error($con);
        $editItem = null;
    } else {
        $editItem = mysqli_fetch_assoc($editResult);
    }
}

// Fetch inventory data for this upload
$inventoryQuery = "SELECT i.*, u.FullName FROM tblinventory i 
                   LEFT JOIN tblusers u ON i.UploadedBy=u.ID 
                   WHERE i.UploadId='$uploadId'
                   ORDER BY i.ID ASC";
$inventory = mysqli_query($con, $inventoryQuery);
if ($inventory === false) {
    // Debug: Show SQL error
    $msg = "Database error (inventory query): " . mysqli_error($con);
}

// Get upload info
$uploadInfo = false;
$uploadInfoQuery = mysqli_query($con, "
    SELECT 
        MIN(UploadDate) as UploadDate, 
        COUNT(*) as ItemCount, 
        SUM(Qty) as TotalQty,
        SUM(Weight) as TotalWeight
    FROM tblinventory 
    WHERE UploadId='$uploadId'
");
if ($uploadInfoQuery === false) {
    $msg = "Database error (upload info): " . mysqli_error($con);
} else {
    $uploadInfo = mysqli_fetch_assoc($uploadInfoQuery);
}

// Get available printers
$availablePrinters = getInstalledPrinters();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Ihita Industries | Inventory Items - <?php echo htmlspecialchars($uploadId); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="css/sb-admin-2.min.css" rel="stylesheet">
    <style>
        // ...existing styles from inventory-management.php...
    </style>
</head>
<body id="page-top">
    <div id="wrapper">
        <?php include_once('includes/sidebar.php');?>
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include_once('includes/topbar.php');?>
                <div class="container-fluid mt-3 mb-3">
                    
                    <!-- Upload Info -->
                    <div class="card shadow mb-4">
                        <div class="card-header bg-info text-white">
                            <h5 class="mb-0">Upload Information: <?php echo htmlspecialchars($uploadId); ?></h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-4">
                                    <strong>Total Items:</strong>
                                    <?php
                                    if ($uploadInfo && isset($uploadInfo['ItemCount'])) {
                                        echo $uploadInfo['ItemCount'];
                                    } else {
                                        echo "<span class='text-danger'>N/A</span>";
                                    }
                                    ?>
                                </div>
                                <div class="col-md-4">
                                    <strong>Total Quantity:</strong>
                                    <?php
                                    if ($uploadInfo && isset($uploadInfo['TotalQty'])) {
                                        echo $uploadInfo['TotalQty'];
                                    } else {
                                        echo "<span class='text-danger'>N/A</span>";
                                    }
                                    ?>
                                </div>
                                <div class="col-md-4">
                                    <strong>Total Weight:</strong>
                                    <?php
                                    if ($uploadInfo && isset($uploadInfo['TotalWeight'])) {
                                        echo number_format($uploadInfo['TotalWeight'], 2) . ' kg';
                                    } else {
                                        echo "<span class='text-danger'>N/A</span>";
                                    }
                                    ?>
                                </div>
                                <div class="col-md-4">
                                    <strong>Upload Date:</strong>
                                    <?php
                                    if ($uploadInfo && isset($uploadInfo['UploadDate'])) {
                                        echo $uploadInfo['UploadDate'];
                                    } else {
                                        echo "<span class='text-danger'>N/A</span>";
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
             
                    <?php if($msg) { ?>
                        <div class="alert alert-info text-center"><?php echo $msg; ?></div>
                    <?php } ?>

                    <!-- Add/Edit Item Form -->
                    <?php if($editItem) { ?>
                    <div class="card shadow mb-4">
                        <div class="card-header bg-warning text-white text-center">
                            <h4 class="mb-0">Edit Inventory Item</h4>
                        </div>
                        <div class="card-body">
                            <form method="post" autocomplete="off">
                                <input type="hidden" name="item_id" value="<?php echo $editItem['ID']; ?>">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Barcode</label>
                                            <input type="text" name="barcode" class="form-control" required value="<?php echo htmlspecialchars($editItem['Barcode']); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Product Name</label>
                                            <input type="text" name="product_name" class="form-control" required value="<?php echo htmlspecialchars($editItem['ProductName']); ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Quantity</label>
                                            <input type="number" name="qty" class="form-control" required value="<?php echo $editItem['Qty']; ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Weight (kg)</label>
                                            <input type="number" step="0.01" name="weight" class="form-control" required value="<?php echo $editItem['Weight']; ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Room No</label>
                                            <input type="text" name="room_no" class="form-control" required value="<?php echo htmlspecialchars($editItem['RoomNo']); ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>Project Name</label>
                                            <input type="text" name="project_name" class="form-control" required value="<?php echo htmlspecialchars($editItem['ProjectName']); ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <button type="submit" name="update_item" class="btn btn-success btn-block">Update Item</button>
                                    </div>
                                    <div class="col-md-6">
                                        <a href="inventory-items.php?upload_id=<?php echo urlencode($uploadId); ?>" class="btn btn-secondary btn-block">Cancel Edit</a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <?php } ?>

                    <!-- Inventory Items Table -->
                    <div class="card shadow mb-4">
                        <div class="card-header bg-success text-white">
                            <div class="row align-items-center">
                                <div class="col">
                                    <h5 class="mb-0">Inventory Items</h5>
                                </div>
                                <div class="col-auto">
                                    <button type="button" class="btn btn-light btn-sm" onclick="selectAll()">
                                        <i class="fas fa-check-square"></i> Select All
                                    </button>
                                    <button type="button" class="btn btn-light btn-sm" onclick="deselectAll()">
                                        <i class="fas fa-square"></i> Deselect All
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="card-body p-2">
                            <form method="post" id="bulkActionForm">
                                <!-- Printer Selection Section -->
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label for="printer_select" class="form-label"><strong>Select Printer:</strong></label>
                                        <?php if ($execDisabled): ?>
                                            <div class="alert alert-danger mb-2">
                                                Printing is not available on this server.<br>
                                                <b>How to print:</b> Select items and click <b>Print Selected Items</b> to download PRN files.<br>
                                                Use the <a href="https://www.tscprinters.com/EN/support/Software-Detail/TSPL-Printer-Utility" target="_blank">TSC Printer Utility</a> on a Windows PC to print these files to your TSC printer.<br>
                                                <small>No direct server printing is possible on this hosting.</small>
                                            </div>
                                        <?php endif; ?>
                                        <select name="selected_printer" id="printer_select" class="form-control" required <?php if ($execDisabled) echo 'disabled'; ?>>
                                            <option value="">-- Choose a Printer --</option>
                                            <?php foreach ($availablePrinters as $printer): ?>
                                                <option value="<?php echo htmlspecialchars($printer['name']); ?>" 
                                                        title="Port: <?php echo htmlspecialchars($printer['port']); ?> | Driver: <?php echo htmlspecialchars($printer['driver']); ?>">
                                                    <?php echo htmlspecialchars($printer['name']); ?> 
                                                    (<?php echo $printer['type']; ?> - <?php echo htmlspecialchars($printer['port']); ?>)
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <?php if (empty($availablePrinters) && !$execDisabled): ?>
                                            <small class="text-danger">No printers found. Please ensure printers are installed and accessible.</small>
                                        <?php endif; ?>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label"><strong>Actions:</strong></label>
                                        <div>
                                            <button type="submit" name="print_selected" class="btn btn-warning" 
                                                    onclick="return validatePrintSelection();">
                                                <i class="fas fa-print"></i> Print Selected Items
                                            </button>
                                            <button type="submit" name="delete_selected" class="btn btn-danger" 
                                                    onclick="return confirm('Are you sure you want to delete the selected items? This action cannot be undone.');">
                                                <i class="fas fa-trash"></i> Delete Selected Items
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Refresh Printers Button -->
                                <div class="mb-3">
                                    <button type="button" class="btn btn-info btn-sm" onclick="location.reload();">
                                        <i class="fas fa-sync-alt"></i> Refresh Printer List
                                    </button>
                                </div>
                                
                                <div class="table-responsive">
                                <table class="table table-bordered table-sm mb-0">
                                    <thead class="thead-light">
                                        <tr>
                                            <th><input type="checkbox" id="selectAllCheckbox" onchange="toggleAll()"></th>
                                            <th>#</th>
                                            <th>Barcode</th>
                                            <th>Product Name</th>
                                            <th>Qty</th>
                                            <th>Weight</th>
                                            <th>Room No</th>
                                            <th>Project Name</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    $i=1;
                                    if ($inventory && mysqli_num_rows($inventory) > 0) {
                                        while($row = mysqli_fetch_assoc($inventory)) { ?>
                                            <tr>
                                                <td data-label="Select">
                                                    <input type="checkbox" name="selected_items[]" value="<?php echo $row['ID']; ?>" class="item-checkbox">
                                                </td>
                                                <td data-label="#"><?php echo $i++; ?></td>
                                                <td data-label="Barcode"><?php echo htmlspecialchars($row['Barcode']); ?></td>
                                                <td data-label="Product Name"><?php echo htmlspecialchars($row['ProductName']); ?></td>
                                                <td data-label="Qty"><?php echo $row['Qty']; ?></td>
                                                <td data-label="Weight"><?php echo number_format($row['Weight'], 2); ?> kg</td>
                                                <td data-label="Room No"><?php echo htmlspecialchars($row['RoomNo']); ?></td>
                                                <td data-label="Project Name"><?php echo htmlspecialchars($row['ProjectName']); ?></td>
                                                <td data-label="Actions">
                                                    <?php if($userType == 'admin' || $row['UploadedBy'] == $userId) { ?>
                                                        <a href="inventory-items.php?upload_id=<?php echo urlencode($uploadId); ?>&edit_item=<?php echo $row['ID']; ?>" class="btn btn-sm btn-warning" title="Edit"><i class="fas fa-edit"></i></a>
                                                        <a href="inventory-items.php?upload_id=<?php echo urlencode($uploadId); ?>&del_item=<?php echo $row['ID']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this item?');" title="Delete"><i class="fas fa-trash"></i></a>
                                                    <?php } else { ?>
                                                        <span class="text-muted">-</span>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                    <?php }
                                    } else { ?>
                                        <tr>
                                            <td colspan="8" class="text-center text-danger">No inventory items found or database error.</td>
                                        </tr>
                                    <?php } ?>
                                    </tbody>
                                </table>
                                </div>
                            </form>
                        </div>
                    </div>

                    <a href="packing-module.php" class="btn btn-primary btn-block">
                        <i class="fas fa-plus"></i> Pack Items
                    </a>

                    <a href="inventory-management.php" class="btn btn-link btn-block mt-3">Back to Upload List</a>
                </div>
            </div>
            <?php include_once('includes/footer.php');?>
        </div>
    </div>
    <?php include_once('includes/footer2.php');?>
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="js/sb-admin-2.min.js"></script>
    
    <script>
        function toggleAll() {
            const selectAllCheckbox = document.getElementById('selectAllCheckbox');
            const itemCheckboxes = document.querySelectorAll('.item-checkbox');
            itemCheckboxes.forEach(checkbox => {
                checkbox.checked = selectAllCheckbox.checked;
            });
        }
        
        function selectAll() {
            document.getElementById('selectAllCheckbox').checked = true;
            toggleAll();
        }
        
        function deselectAll() {
            document.getElementById('selectAllCheckbox').checked = false;
            toggleAll();
        }
        
        function validatePrintSelection() {
            const selectedItems = document.querySelectorAll('input[name="selected_items[]"]:checked');
            const selectedPrinter = document.getElementById('printer_select').value;
            
            if (selectedItems.length === 0) {
                alert('Please select at least one item to print.');
                return false;
            }
            
            if (!selectedPrinter) {
                alert('Please select a printer.');
                return false;
            }
            
            return confirm(`Print ${selectedItems.length} item(s) to printer: ${selectedPrinter}?`);
        }
        
        <?php if(isset($_SESSION['print_commands']) && !empty($_SESSION['print_commands'])) { ?>
            const printCommands = <?php echo json_encode($_SESSION['print_commands']); ?>;
            const printStatus = '<?php echo isset($_SESSION['print_status']) ? $_SESSION['print_status'] : 'unknown'; ?>';
            console.log('Print Commands:', printCommands);
            console.log('Print Status:', printStatus);
            
            if (printStatus === 'success') {
                console.log('All items sent to printer successfully!');
            } else if (printStatus === 'error') {
                console.log('Some print jobs failed. Check server logs for details.');
            }
            <?php 
            unset($_SESSION['print_commands']); 
            unset($_SESSION['print_status']);
            ?>
        <?php } ?>
    </script>
</body>
</html>