<?php
session_start();
include_once('includes/config.php');

// Check if user is logged in
if (!isset($_SESSION['uid'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit();
}

// Get filters from GET parameters
$dateFrom = isset($_GET['date_from']) ? $_GET['date_from'] : date('Y-m-01');
$dateTo = isset($_GET['date_to']) ? $_GET['date_to'] : date('Y-m-d');
$projectFilter = isset($_GET['project']) ? mysqli_real_escape_string($con, $_GET['project']) : '';
$roomFilter = isset($_GET['room']) ? mysqli_real_escape_string($con, $_GET['room']) : '';
$productFilter = isset($_GET['product']) ? mysqli_real_escape_string($con, $_GET['product']) : '';
$packageFilter = isset($_GET['package']) ? mysqli_real_escape_string($con, $_GET['package']) : '';
$userFilter = isset($_GET['user']) ? mysqli_real_escape_string($con, $_GET['user']) : '';

// Build WHERE conditions for main query (with alias)
$whereConditions = [];
$whereConditions[] = "p.PackedDate BETWEEN '$dateFrom 00:00:00' AND '$dateTo 23:59:59'";
if (!empty($projectFilter)) $whereConditions[] = "p.ProjectName LIKE '%$projectFilter%'";
if (!empty($roomFilter)) $whereConditions[] = "p.RoomNo LIKE '%$roomFilter%'";
if (!empty($productFilter)) $whereConditions[] = "p.ProductName LIKE '%$productFilter%'";
if (!empty($packageFilter)) $whereConditions[] = "(p.PackageId LIKE '%$packageFilter%' OR p.PackageName LIKE '%$packageFilter%')";
if (!empty($userFilter) && $userFilter !== 'all') $whereConditions[] = "p.PackedBy = '$userFilter'";
$whereClause = !empty($whereConditions) ? "WHERE " . implode(" AND ", $whereConditions) : "";

// Build WHERE conditions for header query (no alias)
$whereConditionsNoAlias = [];
$whereConditionsNoAlias[] = "PackedDate BETWEEN '$dateFrom 00:00:00' AND '$dateTo 23:59:59'";
if (!empty($projectFilter)) $whereConditionsNoAlias[] = "ProjectName LIKE '%$projectFilter%'";
if (!empty($roomFilter)) $whereConditionsNoAlias[] = "RoomNo LIKE '%$roomFilter%'";
if (!empty($productFilter)) $whereConditionsNoAlias[] = "ProductName LIKE '%$productFilter%'";
if (!empty($packageFilter)) $whereConditionsNoAlias[] = "(PackageId LIKE '%$packageFilter%' OR PackageName LIKE '%$packageFilter%')";
if (!empty($userFilter) && $userFilter !== 'all') $whereConditionsNoAlias[] = "PackedBy = '$userFilter'";
$whereClauseNoAlias = !empty($whereConditionsNoAlias) ? "WHERE " . implode(" AND ", $whereConditionsNoAlias) : "";

// Query for packing list data, ordered by bundle number ascending (same as print-packing-list.php)
$query = "
    SELECT 
        p.PackageName,
        p.ProductName,
        p.PackedQty,
        p.PackedWeight,
        p.RoomNo,
        p.PackedDate,
        u.FullName as PackedBy,
        CASE 
            WHEN i.Qty IS NULL THEN 'Product Not Found'
            WHEN p.PackedQty > i.Qty THEN 'Over Packed'
            ELSE 'Normal'
        END as PackingStatus,
        p.Barcode
    FROM tblpacked p
    LEFT JOIN tblusers u ON p.PackedBy = u.ID
    LEFT JOIN tblinventory i ON p.ProductId = i.ID
    $whereClause
    ORDER BY CAST(p.PackageName AS UNSIGNED) ASC, p.PackageName ASC, p.PackedDate ASC
";

$result = mysqli_query($con, $query);

// Get project name for header
$projectName = '';
if (!empty($projectFilter)) {
    $projectName = $projectFilter;
} else {
    $headerQuery = mysqli_query($con, "SELECT ProjectName FROM tblpacked $whereClauseNoAlias LIMIT 1");
    $headerRow = mysqli_fetch_assoc($headerQuery);
    $projectName = $headerRow ? $headerRow['ProjectName'] : '';
}

$projectTitle = $projectName ? $projectName . " Packing List" : "Packing List";

// Collect all rows
$rows = [];
if ($result) {
    while ($row = mysqli_fetch_assoc($result)) {
        $rows[] = $row;
    }
}

// Prepare response data
$response = [
    'projectTitle' => $projectTitle,
    'projectName' => $projectName,
    'dateFrom' => $dateFrom,
    'dateTo' => $dateTo,
    'rows' => $rows
];

// Return JSON response
header('Content-Type: application/json');
echo json_encode($response);
?>
