<?php
session_start();
include_once('includes/config.php');
if (!isset($_SESSION['uid'])) {
    header('location:logout.php');
    exit();
}

$userId = $_SESSION['uid'];
$userType = $_SESSION['usertype'];

// Get overall statistics
$totalProjectsQuery = "SELECT COUNT(DISTINCT ProjectName) as TotalProjects FROM tblinventory";
$totalProjectsResult = mysqli_query($con, $totalProjectsQuery);
$totalProjects = mysqli_fetch_assoc($totalProjectsResult)['TotalProjects'];

$totalInventoryQuery = "SELECT COUNT(*) as TotalItems, SUM(Qty) as TotalQty, SUM(Weight) as TotalWeight FROM tblinventory";
$totalInventoryResult = mysqli_query($con, $totalInventoryQuery);
$totalInventory = mysqli_fetch_assoc($totalInventoryResult);

$totalPackedQuery = "SELECT COUNT(*) as TotalPackedItems, SUM(PackedQty) as TotalPackedQty, SUM(PackedWeight) as TotalPackedWeight FROM tblpacked";
$totalPackedResult = mysqli_query($con, $totalPackedQuery);
$totalPacked = mysqli_fetch_assoc($totalPackedResult);

// Get project-wise status
$projectStatusQuery = "
    SELECT 
        ProjectName,
        SUM(TotalItems) as TotalItems,
        SUM(TotalInventoryQty) as TotalInventoryQty,
        SUM(TotalInventoryWeight) as TotalInventoryWeight,
        SUM(TotalPackedQty) as TotalPackedQty,
        SUM(TotalPackedWeight) as TotalPackedWeight,
        SUM(RemainingQty) as RemainingQty,
        SUM(RemainingWeight) as RemainingWeight,
        ROUND((SUM(TotalPackedQty) / SUM(TotalInventoryQty) * 100), 2) as CompletionPercentage,
        CASE 
            WHEN SUM(RemainingQty) = 0 THEN 'Closed'
            WHEN SUM(TotalPackedQty) > 0 THEN 'Active'
            ELSE 'Pending'
        END as ProjectStatus,
        MIN(ProjectStartDate) as ProjectStartDate,
        MAX(LastActivity) as LastActivity
    FROM (
        SELECT 
            i.ProjectName,
            1 as TotalItems,
            i.Qty as TotalInventoryQty,
            i.Weight as TotalInventoryWeight,
            COALESCE(SUM(p.PackedQty), 0) as TotalPackedQty,
            COALESCE(SUM(p.PackedWeight), 0) as TotalPackedWeight,
            (i.Qty - COALESCE(SUM(p.PackedQty), 0)) as RemainingQty,
            (i.Weight - COALESCE(SUM(p.PackedWeight), 0)) as RemainingWeight,
            i.UploadDate as ProjectStartDate,
            COALESCE(MAX(p.PackedDate), i.UploadDate) as LastActivity
        FROM tblinventory i
        LEFT JOIN tblpacked p ON i.ID = p.ProductId
        GROUP BY i.ID, i.ProjectName, i.Qty, i.Weight, i.UploadDate
    ) as item_status
    GROUP BY ProjectName
    ORDER BY ProjectStatus DESC, CompletionPercentage DESC
";
$projectStatusResult = mysqli_query($con, $projectStatusQuery);

// Count projects by status
$activeProjects = 0;
$closedProjects = 0;
$pendingProjects = 0;

$tempResult = mysqli_query($con, $projectStatusQuery);
while($project = mysqli_fetch_assoc($tempResult)) {
    switch($project['ProjectStatus']) {
        case 'Active': $activeProjects++; break;
        case 'Closed': $closedProjects++; break;
        case 'Pending': $pendingProjects++; break;
    }
}

// Get recent activity
$recentActivityQuery = "
    SELECT 
        'Inventory Upload' as ActivityType,
        i.ProjectName,
        i.ProductName,
        i.Qty as Quantity,
        u.FullName as UserName,
        i.UploadDate as ActivityDate
    FROM tblinventory i
    LEFT JOIN tblusers u ON i.UploadedBy = u.ID
    WHERE i.UploadDate >= DATE_SUB(NOW(), INTERVAL 7 DAY)
    
    UNION ALL
    
    SELECT 
        'Packing' as ActivityType,
        p.ProjectName,
        p.ProductName,
        p.PackedQty as Quantity,
        u.FullName as UserName,
        p.PackedDate as ActivityDate
    FROM tblpacked p
    LEFT JOIN tblusers u ON p.PackedBy = u.ID
    WHERE p.PackedDate >= DATE_SUB(NOW(), INTERVAL 7 DAY)
    
    ORDER BY ActivityDate DESC
    LIMIT 10
";
$recentActivityResult = mysqli_query($con, $recentActivityQuery);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Ihita Industries | Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="css/sb-admin-2.min.css" rel="stylesheet">
    <style>
        .dashboard-card {
            transition: transform 0.2s, box-shadow 0.2s;
            border-left: 4px solid;
        }
        .dashboard-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15) !important;
        }
        .card-primary { border-left-color: #4e73df; }
        .card-success { border-left-color: #1cc88a; }
        .card-info { border-left-color: #36b9cc; }
        .card-warning { border-left-color: #f6c23e; }
        .card-danger { border-left-color: #e74a3b; }
        
        .progress-thin {
            height: 8px;
        }
        
        .status-closed { background-color: #d4edda; color: #155724; }
        .status-active { background-color: #fff3cd; color: #856404; }
        .status-pending { background-color: #f8d7da; color: #721c24; }
        
        .activity-icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .chart-container {
            position: relative;
            height: 300px;
        }
        
        @media (max-width: 768px) {
            .col-xl-3, .col-md-6 {
                margin-bottom: 1rem;
            }
        }
    </style>
</head>
<body id="page-top">
    <div id="wrapper">
        <?php include_once('includes/sidebar.php');?>
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include_once('includes/topbar.php');?>
                
                <!-- Begin Page Content -->
                <div class="container-fluid">
                    
                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4">
                        <h1 class="h3 mb-0 text-gray-800">
                            <i class="fas fa-tachometer-alt text-primary mr-2"></i>
                            Project Management Dashboard
                        </h1>
                        <div class="d-none d-lg-inline-block">
                            <span class="text-gray-600">
                                <i class="fas fa-calendar-alt mr-1"></i>
                                <?php echo date('l, F j, Y'); ?>
                            </span>
                        </div>
                    </div>

                    <!-- Overview Cards Row -->
                    <div class="row">
                        
                        <!-- Total Projects Card -->
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card dashboard-card card-primary shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                                Total Projects</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                <?php echo number_format($totalProjects); ?>
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-project-diagram fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Active Projects Card -->
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card dashboard-card card-warning shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                                Active Projects</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                <?php echo number_format($activeProjects); ?>
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-play-circle fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Completed Projects Card -->
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card dashboard-card card-success shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                                Completed Projects</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                <?php echo number_format($closedProjects); ?>
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Pending Projects Card -->
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card dashboard-card card-danger shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                                Pending Projects</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                <?php echo number_format($pendingProjects); ?>
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-pause-circle fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Inventory Overview Row -->
                    <div class="row">
                        
                        <!-- Total Inventory Items -->
                        <div class="col-xl-4 col-md-6 mb-4">
                            <div class="card dashboard-card card-info shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                                Total Inventory Items</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                <?php echo number_format($totalInventory['TotalItems']); ?>
                                            </div>
                                            <small class="text-muted">
                                                Qty: <?php echo number_format($totalInventory['TotalQty']); ?> | 
                                                Weight: <?php echo number_format($totalInventory['TotalWeight'], 2); ?> kg
                                            </small>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-boxes fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Total Packed Items -->
                        <div class="col-xl-4 col-md-6 mb-4">
                            <div class="card dashboard-card card-success shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                                Total Packed Items</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                <?php echo number_format($totalPacked['TotalPackedItems']); ?>
                                            </div>
                                            <small class="text-muted">
                                                Qty: <?php echo number_format($totalPacked['TotalPackedQty']); ?> | 
                                                Weight: <?php echo number_format($totalPacked['TotalPackedWeight'], 2); ?> kg
                                            </small>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-shipping-fast fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Overall Completion Rate -->
                        <div class="col-xl-4 col-md-6 mb-4">
                            <div class="card dashboard-card card-primary shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                                Overall Completion</div>
                                            <?php 
                                            $overallCompletion = $totalInventory['TotalQty'] > 0 ? 
                                                round(($totalPacked['TotalPackedQty'] / $totalInventory['TotalQty']) * 100, 2) : 0;
                                            ?>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                <?php echo $overallCompletion; ?>%
                                            </div>
                                            <div class="progress progress-thin mt-2">
                                                <div class="progress-bar bg-primary" role="progressbar" 
                                                     style="width: <?php echo $overallCompletion; ?>%"></div>
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-chart-pie fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Main Content Row -->
                    <div class="row">
                        
                        <!-- Project Status Table -->
                        <div class="col-xl-8 col-lg-7">
                            <div class="card shadow mb-4">
                                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                    <h6 class="m-0 font-weight-bold text-primary">
                                        <i class="fas fa-list-alt mr-2"></i>
                                        Project Status Overview
                                    </h6>
                                    <div class="dropdown no-arrow">
                                        <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                           data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-400"></i>
                                        </a>
                                        <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                             aria-labelledby="dropdownMenuLink">
                                            <div class="dropdown-header">Export Options:</div>
                                            <a class="dropdown-item" href="#" onclick="exportProjectData()">
                                                <i class="fas fa-file-excel fa-sm fa-fw mr-2 text-gray-400"></i>
                                                Export to Excel
                                            </a>
                                            <a class="dropdown-item" href="project-report.php">
                                                <i class="fas fa-chart-bar fa-sm fa-fw mr-2 text-gray-400"></i>
                                                Detailed Report
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped" id="projectTable" width="100%" cellspacing="0">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>Project Name</th>
                                                    <th>Status</th>
                                                    <th>Progress</th>
                                                    <th>Inventory</th>
                                                    <th>Packed</th>
                                                    <th>Remaining</th>
                                                    <th>Last Activity</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php while($project = mysqli_fetch_assoc($projectStatusResult)): ?>
                                                <tr>
                                                    <td>
                                                        <strong><?php echo htmlspecialchars($project['ProjectName']); ?></strong>
                                                        <br><small class="text-muted"><?php echo $project['TotalItems']; ?> items</small>
                                                    </td>
                                                    <td>
                                                        <span class="badge badge-pill px-3 py-2 status-<?php echo strtolower($project['ProjectStatus']); ?>">
                                                            <?php echo $project['ProjectStatus']; ?>
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <div class="mb-1">
                                                            <small class="text-muted"><?php echo $project['CompletionPercentage']; ?>%</small>
                                                        </div>
                                                        <div class="progress progress-thin">
                                                            <div class="progress-bar 
                                                                <?php 
                                                                if($project['CompletionPercentage'] == 100) echo 'bg-success';
                                                                elseif($project['CompletionPercentage'] >= 50) echo 'bg-warning'; 
                                                                else echo 'bg-danger';
                                                                ?>" 
                                                                role="progressbar" 
                                                                style="width: <?php echo $project['CompletionPercentage']; ?>%">
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <strong><?php echo number_format($project['TotalInventoryQty']); ?></strong>
                                                        <br><small class="text-muted"><?php echo number_format($project['TotalInventoryWeight'], 2); ?> kg</small>
                                                    </td>
                                                    <td>
                                                        <strong class="text-success"><?php echo number_format($project['TotalPackedQty']); ?></strong>
                                                        <br><small class="text-muted"><?php echo number_format($project['TotalPackedWeight'], 2); ?> kg</small>
                                                    </td>
                                                    <td>
                                                        <strong class="<?php echo $project['RemainingQty'] > 0 ? 'text-warning' : 'text-success'; ?>">
                                                            <?php echo number_format($project['RemainingQty']); ?>
                                                        </strong>
                                                        <br><small class="text-muted"><?php echo number_format($project['RemainingWeight'], 2); ?> kg</small>
                                                    </td>
                                                    <td>
                                                        <small class="text-muted">
                                                            <?php echo date('M j, Y', strtotime($project['LastActivity'])); ?>
                                                        </small>
                                                    </td>
                                                    <td>
                                                        <div class="btn-group" role="group">
                                                            <a href="project-report.php?project=<?php echo urlencode($project['ProjectName']); ?>" 
                                                               class="btn btn-sm btn-outline-primary" title="View Details">
                                                                <i class="fas fa-eye"></i>
                                                            </a>
                                                            <a href="inventory-report.php?project=<?php echo urlencode($project['ProjectName']); ?>" 
                                                               class="btn btn-sm btn-outline-info" title="Inventory Report">
                                                                <i class="fas fa-boxes"></i>
                                                            </a>
                                                            <a href="packed-report.php?project=<?php echo urlencode($project['ProjectName']); ?>" 
                                                               class="btn btn-sm btn-outline-success" title="Packed Report">
                                                                <i class="fas fa-shipping-fast"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <?php endwhile; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Recent Activity -->
                        <div class="col-xl-4 col-lg-5">
                            <div class="card shadow mb-4">
                                <div class="card-header py-3">
                                    <h6 class="m-0 font-weight-bold text-primary">
                                        <i class="fas fa-clock mr-2"></i>
                                        Recent Activity
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <div class="timeline">
                                        <?php while($activity = mysqli_fetch_assoc($recentActivityResult)): ?>
                                        <div class="d-flex align-items-center mb-3">
                                            <div class="activity-icon mr-3 <?php echo $activity['ActivityType'] == 'Inventory Upload' ? 'bg-primary' : 'bg-success'; ?> text-white">
                                                <i class="fas <?php echo $activity['ActivityType'] == 'Inventory Upload' ? 'fa-upload' : 'fa-box'; ?> fa-sm"></i>
                                            </div>
                                            <div class="flex-grow-1">
                                                <div class="font-weight-bold text-sm">
                                                    <?php echo $activity['ActivityType']; ?>
                                                </div>
                                                <div class="text-sm text-gray-600">
                                                    <?php echo htmlspecialchars($activity['ProductName']); ?>
                                                </div>
                                                <div class="text-xs text-muted">
                                                    Qty: <?php echo $activity['Quantity']; ?> | 
                                                    <?php echo htmlspecialchars($activity['UserName']); ?> | 
                                                    <?php echo date('M j, H:i', strtotime($activity['ActivityDate'])); ?>
                                                </div>
                                            </div>
                                        </div>
                                        <?php endwhile; ?>
                                    </div>
                                </div>
                            </div>

                            <!-- Quick Actions -->
                            <div class="card shadow mb-4">
                                <div class="card-header py-3">
                                    <h6 class="m-0 font-weight-bold text-primary">
                                        <i class="fas fa-bolt mr-2"></i>
                                        Quick Actions
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <div class="d-grid gap-2">
                                        <a href="inventory-management.php" class="btn btn-primary btn-block">
                                            <i class="fas fa-upload mr-2"></i>
                                            Upload Inventory
                                        </a>
                                        <a href="packing-module.php" class="btn btn-success btn-block">
                                            <i class="fas fa-boxes mr-2"></i>
                                            Start Packing
                                        </a>
                                        <a href="inventory-report.php" class="btn btn-info btn-block">
                                            <i class="fas fa-chart-bar mr-2"></i>
                                            View Reports
                                        </a>
                                        <a href="project-report.php" class="btn btn-warning btn-block">
                                            <i class="fas fa-project-diagram mr-2"></i>
                                            Project Reports
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- /.container-fluid -->
            </div>
            <?php include_once('includes/footer.php');?>
        </div>
    </div>
    <?php include_once('includes/footer2.php');?>

    <!-- Bootstrap core JavaScript-->
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="js/sb-admin-2.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>

    <script>
        function exportProjectData() {
            const wb = XLSX.utils.book_new();
            
            // Get table data
            const table = document.getElementById('projectTable');
            const ws = XLSX.utils.table_to_sheet(table);
            
            // Set column widths
            ws['!cols'] = [
                { width: 30 }, // Project Name
                { width: 12 }, // Status
                { width: 10 }, // Progress
                { width: 15 }, // Inventory
                { width: 15 }, // Packed
                { width: 15 }, // Remaining
                { width: 15 }, // Last Activity
                { width: 10 }  // Actions (will be empty in export)
            ];
            
            XLSX.utils.book_append_sheet(wb, ws, 'Project Status');
            
            // Save file
            const fileName = 'Project_Status_Dashboard_' + new Date().toISOString().slice(0, 10) + '.xlsx';
            XLSX.writeFile(wb, fileName);
        }

        // Auto-refresh data every 5 minutes
        setTimeout(function() {
            location.reload();
        }, 300000);
    </script>
</body>
</html>
