<?php
session_start();
include_once('includes/config.php');
if (!isset($_SESSION['uid'])) {
    header('location:logout.php');
    exit();
}

$userId = $_SESSION['uid'];
$userType = $_SESSION['usertype'];

// Get active projects (projects with remaining inventory)
$activeProjectsQuery = "
    SELECT 
        ProjectName,
        SUM(TotalItems) as TotalItems,
        SUM(TotalInventoryQty) as TotalInventoryQty,
        SUM(TotalInventoryWeight) as TotalInventoryWeight,
        SUM(TotalPackedQty) as TotalPackedQty,
        SUM(TotalPackedWeight) as TotalPackedWeight,
        SUM(RemainingQty) as RemainingQty,
        SUM(RemainingWeight) as RemainingWeight,
        ROUND((SUM(TotalPackedQty) / SUM(TotalInventoryQty) * 100), 2) as CompletionPercentage,
        MIN(ProjectStartDate) as ProjectStartDate,
        MAX(LastActivity) as LastActivity,
        (SELECT COUNT(DISTINCT PackageId) FROM tblpacked WHERE ProjectName = item_status.ProjectName) as TotalPackages,
        COUNT(DISTINCT RoomNo) as TotalRooms
    FROM (
        SELECT 
            i.ProjectName,
            1 as TotalItems,
            i.Qty as TotalInventoryQty,
            i.Weight as TotalInventoryWeight,
            COALESCE(SUM(p.PackedQty), 0) as TotalPackedQty,
            COALESCE(SUM(p.PackedWeight), 0) as TotalPackedWeight,
            (i.Qty - COALESCE(SUM(p.PackedQty), 0)) as RemainingQty,
            (i.Weight - COALESCE(SUM(p.PackedWeight), 0)) as RemainingWeight,
            i.UploadDate as ProjectStartDate,
            COALESCE(MAX(p.PackedDate), i.UploadDate) as LastActivity,
            i.RoomNo
        FROM tblinventory i
        LEFT JOIN tblpacked p ON i.ID = p.ProductId
        GROUP BY i.ID, i.ProjectName, i.Qty, i.Weight, i.UploadDate, i.RoomNo
    ) as item_status
    GROUP BY ProjectName
    HAVING SUM(RemainingQty) > 0 AND SUM(TotalPackedQty) > 0
    ORDER BY CompletionPercentage DESC, LastActivity DESC
";
$activeProjectsResult = mysqli_query($con, $activeProjectsQuery);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Ihita Industries | Active Projects</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="css/sb-admin-2.min.css" rel="stylesheet">
    <style>
        .progress-thin { height: 8px; }
        .project-card { 
            transition: transform 0.2s, box-shadow 0.2s; 
            border-left: 4px solid #f6c23e;
        }
        .project-card:hover { 
            transform: translateY(-2px); 
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15) !important; 
        }
    </style>
</head>
<body id="page-top">
    <div id="wrapper">
        <?php include_once('includes/sidebar.php');?>
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include_once('includes/topbar.php');?>
                
                <!-- Begin Page Content -->
                <div class="container-fluid">
                    
                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4">
                        <h1 class="h3 mb-0 text-gray-800">
                            <i class="fas fa-play-circle text-warning mr-2"></i>
                            Active Projects
                        </h1>
                        <div>
                            <a href="dashboard.php" class="btn btn-primary btn-sm">
                                <i class="fas fa-tachometer-alt mr-2"></i>Back to Dashboard
                            </a>
                        </div>
                    </div>

                    <!-- Projects Grid -->
                    <div class="row">
                        <?php if(mysqli_num_rows($activeProjectsResult) > 0): ?>
                            <?php while($project = mysqli_fetch_assoc($activeProjectsResult)): ?>
                            <div class="col-xl-4 col-lg-6 mb-4">
                                <div class="card project-card shadow h-100">
                                    <div class="card-header bg-warning text-white">
                                        <h6 class="m-0 font-weight-bold">
                                            <i class="fas fa-project-diagram mr-2"></i>
                                            <?php echo htmlspecialchars($project['ProjectName']); ?>
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-6">
                                                <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                                    Progress</div>
                                                <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                    <?php echo $project['CompletionPercentage']; ?>%
                                                </div>
                                                <div class="progress progress-thin mt-2">
                                                    <div class="progress-bar bg-warning" role="progressbar" 
                                                         style="width: <?php echo $project['CompletionPercentage']; ?>%"></div>
                                                </div>
                                            </div>
                                            <div class="col-6">
                                                <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                                    Items</div>
                                                <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                    <?php echo number_format($project['TotalItems']); ?>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <hr>
                                        
                                        <div class="row mb-3">
                                            <div class="col-6">
                                                <small class="text-muted">Inventory</small>
                                                <div class="font-weight-bold"><?php echo number_format($project['TotalInventoryQty']); ?></div>
                                                <small class="text-muted"><?php echo number_format($project['TotalInventoryWeight'], 2); ?> kg</small>
                                            </div>
                                            <div class="col-6">
                                                <small class="text-muted">Packed</small>
                                                <div class="font-weight-bold text-success"><?php echo number_format($project['TotalPackedQty']); ?></div>
                                                <small class="text-muted"><?php echo number_format($project['TotalPackedWeight'], 2); ?> kg</small>
                                            </div>
                                        </div>
                                        
                                        <div class="row mb-3">
                                            <div class="col-6">
                                                <small class="text-muted">Remaining</small>
                                                <div class="font-weight-bold text-warning"><?php echo number_format($project['RemainingQty']); ?></div>
                                                <small class="text-muted"><?php echo number_format($project['RemainingWeight'], 2); ?> kg</small>
                                            </div>
                                            <div class="col-6">
                                                <small class="text-muted">Last Activity</small>
                                                <div class="font-weight-bold"><?php echo date('M j, Y', strtotime($project['LastActivity'])); ?></div>
                                            </div>
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-6">
                                                <small class="text-muted">Bundles: <strong><?php echo $project['TotalPackages']; ?></strong></small>
                                            </div>
                                            <div class="col-6">
                                                <small class="text-muted">Rooms: <strong><?php echo $project['TotalRooms']; ?></strong></small>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <div class="btn-group btn-group-sm d-flex" role="group">
                                            <a href="project-report.php?project=<?php echo urlencode($project['ProjectName']); ?>" 
                                               class="btn btn-outline-primary flex-fill">
                                                <i class="fas fa-eye mr-1"></i>Details
                                            </a>
                                            <a href="inventory-report.php?project=<?php echo urlencode($project['ProjectName']); ?>" 
                                               class="btn btn-outline-info flex-fill">
                                                <i class="fas fa-boxes mr-1"></i>Inventory
                                            </a>
                                            <a href="packed-report.php?project=<?php echo urlencode($project['ProjectName']); ?>" 
                                               class="btn btn-outline-success flex-fill">
                                                <i class="fas fa-shipping-fast mr-1"></i>Packed
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <div class="col-12">
                                <div class="card shadow">
                                    <div class="card-body text-center py-5">
                                        <i class="fas fa-inbox fa-3x text-gray-300 mb-3"></i>
                                        <h5 class="text-gray-600">No Active Projects Found</h5>
                                        <p class="text-gray-500">All projects are either completed or pending to start.</p>
                                        <a href="dashboard.php" class="btn btn-primary">
                                            <i class="fas fa-tachometer-alt mr-2"></i>Back to Dashboard
                                        </a>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>

                </div>
                <!-- /.container-fluid -->
            </div>
            <?php include_once('includes/footer.php');?>
        </div>
    </div>
    <?php include_once('includes/footer2.php');?>

    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="js/sb-admin-2.min.js"></script>
</body>
</html>
