<?php
session_start();
include_once('../includes/config.php');

// Helper function to safely escape HTML content
function safe_htmlspecialchars($string) {
    return htmlspecialchars($string ?? '', ENT_QUOTES, 'UTF-8');
}

// Check if user is logged in
if (!isset($_SESSION['uid'])) {
    header('location:../login.php');
    exit();
}

$userId = $_SESSION['uid'];
$userType = $_SESSION['usertype'];
$message = '';

// Get customer details if customer_id is provided
$selectedCustomer = null;
if (isset($_GET['customer_id'])) {
    $customerId = intval($_GET['customer_id']);
    $customerQuery = "SELECT * FROM tblcustomers WHERE ID = $customerId";
    $customerResult = mysqli_query($con, $customerQuery);
    if (mysqli_num_rows($customerResult) > 0) {
        $selectedCustomer = mysqli_fetch_assoc($customerResult);
    }
}    // Handle form submission
    if ($_POST) {
        $action = $_POST['action'] ?? '';
        
        if ($action == 'add_transaction') {
            $customerId = intval($_POST['customer_id']);
            $invoiceNumber = mysqli_real_escape_string($con, $_POST['invoice_number']);
            $transactionType = mysqli_real_escape_string($con, $_POST['transaction_type']);
            $transactionDate = mysqli_real_escape_string($con, $_POST['transaction_date']);
            $dueDate = mysqli_real_escape_string($con, $_POST['due_date']);
            $amount = floatval($_POST['amount']);
            $taxAmount = floatval($_POST['tax_amount']);
            $description = mysqli_real_escape_string($con, $_POST['description']);
            $paymentMode = mysqli_real_escape_string($con, $_POST['payment_mode']);
            $referenceNumber = mysqli_real_escape_string($con, $_POST['reference_number']);
            
            // Calculate balance amount based on transaction type
            $balanceAmount = $amount;
            if ($transactionType == 'Payment' || $transactionType == 'Credit Note') {
                $balanceAmount = 0; // Payments and credit notes are fully settled
            }
            
            // Handle file upload
            $attachmentPath = null;
            if (isset($_FILES['attachment']) && $_FILES['attachment']['error'] == 0) {
                $uploadDir = 'uploads/invoices/';
                $fileName = time() . '_' . $_FILES['attachment']['name'];
                $uploadPath = $uploadDir . $fileName;
                
                if (move_uploaded_file($_FILES['attachment']['tmp_name'], $uploadPath)) {
                    $attachmentPath = $uploadPath;
                }
            }
            
            $query = "INSERT INTO tblcustomer_accounts 
                      (CustomerID, InvoiceNumber, TransactionType, TransactionDate, DueDate, Amount, BalanceAmount, TaxAmount, Description, PaymentMode, ReferenceNumber, AttachmentPath, AddedBy) 
                      VALUES 
                      ('$customerId', '$invoiceNumber', '$transactionType', '$transactionDate', '$dueDate', '$amount', '$balanceAmount', '$taxAmount', '$description', '$paymentMode', '$referenceNumber', '$attachmentPath', '$userId')";
            
            if (mysqli_query($con, $query)) {
                // Update customer balance
                if ($transactionType == 'Invoice' || $transactionType == 'Debit Note') {
                    $updateQuery = "UPDATE tblcustomers SET CurrentBalance = CurrentBalance + $amount WHERE ID = $customerId";
                } else {
                    $updateQuery = "UPDATE tblcustomers SET CurrentBalance = CurrentBalance - $amount WHERE ID = $customerId";
                }
                mysqli_query($con, $updateQuery);
                
                $message = '<div class="alert alert-success">Transaction added successfully!</div>';
            } else {
                $message = '<div class="alert alert-danger">Error: ' . mysqli_error($con) . '</div>';
            }
        }
        
        if ($action == 'edit_transaction') {
            $transactionId = intval($_POST['transaction_id']);
            $customerId = intval($_POST['customer_id']);
            $invoiceNumber = mysqli_real_escape_string($con, $_POST['invoice_number']);
            $transactionType = mysqli_real_escape_string($con, $_POST['transaction_type']);
            $transactionDate = mysqli_real_escape_string($con, $_POST['transaction_date']);
            $dueDate = mysqli_real_escape_string($con, $_POST['due_date']);
            $amount = floatval($_POST['amount']);
            $taxAmount = floatval($_POST['tax_amount']);
            $description = mysqli_real_escape_string($con, $_POST['description']);
            $paymentMode = mysqli_real_escape_string($con, $_POST['payment_mode']);
            $referenceNumber = mysqli_real_escape_string($con, $_POST['reference_number']);
            
            // Get old transaction details for balance adjustment
            $oldTransactionQuery = "SELECT * FROM tblcustomer_accounts WHERE ID = $transactionId";
            $oldTransactionResult = mysqli_query($con, $oldTransactionQuery);
            $oldTransaction = mysqli_fetch_assoc($oldTransactionResult);
            
            // Calculate balance amount based on transaction type
            $balanceAmount = $amount;
            if ($transactionType == 'Payment' || $transactionType == 'Credit Note') {
                $balanceAmount = 0;
            }
            
            // Handle file upload
            $attachmentPath = $oldTransaction['AttachmentPath'];
            if (isset($_FILES['attachment']) && $_FILES['attachment']['error'] == 0) {
                $uploadDir = 'uploads/invoices/';
                $fileName = time() . '_' . $_FILES['attachment']['name'];
                $uploadPath = $uploadDir . $fileName;
                
                if (move_uploaded_file($_FILES['attachment']['tmp_name'], $uploadPath)) {
                    $attachmentPath = $uploadPath;
                }
            }
            
            $query = "UPDATE tblcustomer_accounts SET 
                      CustomerID = '$customerId',
                      InvoiceNumber = '$invoiceNumber',
                      TransactionType = '$transactionType',
                      TransactionDate = '$transactionDate',
                      DueDate = '$dueDate',
                      Amount = '$amount',
                      BalanceAmount = '$balanceAmount',
                      TaxAmount = '$taxAmount',
                      Description = '$description',
                      PaymentMode = '$paymentMode',
                      ReferenceNumber = '$referenceNumber',
                      AttachmentPath = '$attachmentPath'
                      WHERE ID = $transactionId";
            
            if (mysqli_query($con, $query)) {
                // Adjust customer balance
                $oldAmount = $oldTransaction['Amount'];
                $oldType = $oldTransaction['TransactionType'];
                
                // Reverse old transaction effect
                if ($oldType == 'Invoice' || $oldType == 'Debit Note') {
                    $updateQuery = "UPDATE tblcustomers SET CurrentBalance = CurrentBalance - $oldAmount WHERE ID = " . $oldTransaction['CustomerID'];
                } else {
                    $updateQuery = "UPDATE tblcustomers SET CurrentBalance = CurrentBalance + $oldAmount WHERE ID = " . $oldTransaction['CustomerID'];
                }
                mysqli_query($con, $updateQuery);
                
                // Apply new transaction effect
                if ($transactionType == 'Invoice' || $transactionType == 'Debit Note') {
                    $updateQuery = "UPDATE tblcustomers SET CurrentBalance = CurrentBalance + $amount WHERE ID = $customerId";
                } else {
                    $updateQuery = "UPDATE tblcustomers SET CurrentBalance = CurrentBalance - $amount WHERE ID = $customerId";
                }
                mysqli_query($con, $updateQuery);
                
                $message = '<div class="alert alert-success">Transaction updated successfully!</div>';
            } else {
                $message = '<div class="alert alert-danger">Error: ' . mysqli_error($con) . '</div>';
            }
        }
        
        if ($action == 'delete_transaction') {
            $transactionId = intval($_POST['transaction_id']);
            
            // Get transaction details for balance adjustment
            $transactionQuery = "SELECT * FROM tblcustomer_accounts WHERE ID = $transactionId";
            $transactionResult = mysqli_query($con, $transactionQuery);
            $transaction = mysqli_fetch_assoc($transactionResult);
            
            if ($transaction) {
                $query = "DELETE FROM tblcustomer_accounts WHERE ID = $transactionId";
                
                if (mysqli_query($con, $query)) {
                    // Adjust customer balance
                    $amount = $transaction['Amount'];
                    $type = $transaction['TransactionType'];
                    
                    if ($type == 'Invoice' || $type == 'Debit Note') {
                        $updateQuery = "UPDATE tblcustomers SET CurrentBalance = CurrentBalance - $amount WHERE ID = " . $transaction['CustomerID'];
                    } else {
                        $updateQuery = "UPDATE tblcustomers SET CurrentBalance = CurrentBalance + $amount WHERE ID = " . $transaction['CustomerID'];
                    }
                    mysqli_query($con, $updateQuery);
                    
                    $message = '<div class="alert alert-success">Transaction deleted successfully!</div>';
                } else {
                    $message = '<div class="alert alert-danger">Error: ' . mysqli_error($con) . '</div>';
                }
            }
        }
    
    if ($action == 'update_payment') {
        $accountId = intval($_POST['account_id']);
        $paidAmount = floatval($_POST['paid_amount']);
        $paymentDate = mysqli_real_escape_string($con, $_POST['payment_date']);
        $paymentMode = mysqli_real_escape_string($con, $_POST['payment_mode']);
        $paymentReference = mysqli_real_escape_string($con, $_POST['payment_reference']);
        
        // Get current transaction details
        $currentQuery = "SELECT * FROM tblcustomer_accounts WHERE ID = $accountId";
        $currentResult = mysqli_query($con, $currentQuery);
        $currentTransaction = mysqli_fetch_assoc($currentResult);
        
        $newBalanceAmount = $currentTransaction['Amount'] - $paidAmount;
        $status = 'Pending';
        
        if ($paidAmount >= $currentTransaction['Amount']) {
            $status = 'Paid';
            $newBalanceAmount = 0;
            $paidAmount = $currentTransaction['Amount'];
        } else if ($paidAmount > 0) {
            $status = 'Partial';
        }
        
        // Create a new payment transaction record
        $paymentInvoiceNumber = 'PAY-' . date('YmdHis');
        $insertPaymentQuery = "INSERT INTO tblcustomer_accounts 
                              (CustomerID, InvoiceNumber, TransactionType, TransactionDate, Amount, BalanceAmount, Description, PaymentMode, ReferenceNumber, AddedBy) 
                              VALUES 
                              ('{$currentTransaction['CustomerID']}', '$paymentInvoiceNumber', 'Payment', '$paymentDate', '$paidAmount', '0', 'Payment for {$currentTransaction['InvoiceNumber']}', '$paymentMode', '$paymentReference', '$userId')";
        
        $updateQuery = "UPDATE tblcustomer_accounts SET 
                       PaidAmount = PaidAmount + '$paidAmount',
                       BalanceAmount = '$newBalanceAmount',
                       Status = '$status'
                       WHERE ID = $accountId";
        
        if (mysqli_query($con, $insertPaymentQuery) && mysqli_query($con, $updateQuery)) {
            // Update customer balance
            $balanceChange = $currentTransaction['BalanceAmount'] - $newBalanceAmount;
            $updateCustomerQuery = "UPDATE tblcustomers SET CurrentBalance = CurrentBalance - $balanceChange WHERE ID = " . $currentTransaction['CustomerID'];
            mysqli_query($con, $updateCustomerQuery);
            
            $message = '<div class="alert alert-success">Payment updated successfully!</div>';
        } else {
            $message = '<div class="alert alert-danger">Error: ' . mysqli_error($con) . '</div>';
        }
    }
}

// Build query for customer accounts
$accountsQuery = "SELECT ca.*, c.CustomerName, c.CustomerCode 
                  FROM tblcustomer_accounts ca 
                  JOIN tblcustomers c ON ca.CustomerID = c.ID";

$whereConditions = [];
$queryParams = [];

if (isset($_GET['customer_id']) && !empty($_GET['customer_id'])) {
    $whereConditions[] = "ca.CustomerID = " . intval($_GET['customer_id']);
}

if (isset($_GET['status']) && !empty($_GET['status'])) {
    $whereConditions[] = "ca.Status = '" . mysqli_real_escape_string($con, $_GET['status']) . "'";
}

if (isset($_GET['transaction_type']) && !empty($_GET['transaction_type'])) {
    $whereConditions[] = "ca.TransactionType = '" . mysqli_real_escape_string($con, $_GET['transaction_type']) . "'";
}

if (isset($_GET['date_from']) && !empty($_GET['date_from'])) {
    $whereConditions[] = "ca.TransactionDate >= '" . mysqli_real_escape_string($con, $_GET['date_from']) . "'";
}

if (isset($_GET['date_to']) && !empty($_GET['date_to'])) {
    $whereConditions[] = "ca.TransactionDate <= '" . mysqli_real_escape_string($con, $_GET['date_to']) . "'";
}

if (!empty($whereConditions)) {
    $accountsQuery .= " WHERE " . implode(" AND ", $whereConditions);
}

$accountsQuery .= " ORDER BY ca.TransactionDate DESC, ca.CreatedDate DESC";
$accountsResult = mysqli_query($con, $accountsQuery);

// Get customers for dropdown
$customersQuery = "SELECT ID, CustomerCode, CustomerName FROM tblcustomers WHERE IsActive = 1 ORDER BY CustomerName";
$customersResult = mysqli_query($con, $customersQuery);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Customer Accounts - Ihita</title>
    
    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">
    
    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
</head>

<body id="page-top">
    <!-- Page Wrapper -->
    <div id="wrapper">
        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column" style="margin-left: 0 !important;">
            <!-- Main Content -->
            <div id="content">
                <!-- Topbar -->
                <?php include_once('includes/customer-topbar.php'); ?>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                <div class="container-fluid">
                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4">
                        <h1 class="h3 mb-0 text-gray-800">Customer Accounts</h1>
                        <div>
                            <a href="customers.php" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm mr-2">
                                <i class="fas fa-users fa-sm text-white-50"></i> Customers
                            </a>
                            <button class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm" data-toggle="modal" data-target="#addTransactionModal">
                                <i class="fas fa-plus fa-sm text-white-50"></i> Add Transaction
                            </button>
                        </div>
                    </div>

                    <?php echo $message; ?>

                    <!-- Filters -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">Filters</h6>
                        </div>
                        <div class="card-body">
                            <form method="GET" class="row">
                                <div class="col-md-3">
                                    <label>Customer</label>
                                    <select name="customer_id" class="form-control">
                                        <option value="">All Customers</option>
                                        <?php 
                                        mysqli_data_seek($customersResult, 0);
                                        while ($customer = mysqli_fetch_assoc($customersResult)): 
                                        ?>
                                            <option value="<?php echo $customer['ID']; ?>" 
                                                    <?php echo (isset($_GET['customer_id']) && $_GET['customer_id'] == $customer['ID']) ? 'selected' : ''; ?>>
                                                <?php echo safe_htmlspecialchars($customer['CustomerCode'] . ' - ' . $customer['CustomerName']); ?>
                                            </option>
                                        <?php endwhile; ?>
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <label>Status</label>
                                    <select name="status" class="form-control">
                                        <option value="">All Status</option>
                                        <option value="Pending" <?php echo (isset($_GET['status']) && $_GET['status'] == 'Pending') ? 'selected' : ''; ?>>Pending</option>
                                        <option value="Partial" <?php echo (isset($_GET['status']) && $_GET['status'] == 'Partial') ? 'selected' : ''; ?>>Partial</option>
                                        <option value="Paid" <?php echo (isset($_GET['status']) && $_GET['status'] == 'Paid') ? 'selected' : ''; ?>>Paid</option>
                                        <option value="Overdue" <?php echo (isset($_GET['status']) && $_GET['status'] == 'Overdue') ? 'selected' : ''; ?>>Overdue</option>
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <label>Type</label>
                                    <select name="transaction_type" class="form-control">
                                        <option value="">All Types</option>
                                        <option value="Invoice" <?php echo (isset($_GET['transaction_type']) && $_GET['transaction_type'] == 'Invoice') ? 'selected' : ''; ?>>Invoice</option>
                                        <option value="Payment" <?php echo (isset($_GET['transaction_type']) && $_GET['transaction_type'] == 'Payment') ? 'selected' : ''; ?>>Payment</option>
                                        <option value="Credit Note" <?php echo (isset($_GET['transaction_type']) && $_GET['transaction_type'] == 'Credit Note') ? 'selected' : ''; ?>>Credit Note</option>
                                        <option value="Debit Note" <?php echo (isset($_GET['transaction_type']) && $_GET['transaction_type'] == 'Debit Note') ? 'selected' : ''; ?>>Debit Note</option>
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <label>From Date</label>
                                    <input type="date" name="date_from" class="form-control" value="<?php echo $_GET['date_from'] ?? ''; ?>">
                                </div>
                                <div class="col-md-2">
                                    <label>To Date</label>
                                    <input type="date" name="date_to" class="form-control" value="<?php echo $_GET['date_to'] ?? ''; ?>">
                                </div>
                                <div class="col-md-1">
                                    <label>&nbsp;</label>
                                    <button type="submit" class="btn btn-primary btn-block">Filter</button>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- Customer Info Card (if specific customer selected) -->
                    <?php if ($selectedCustomer): ?>
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">Customer Information</h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-4">
                                    <strong>Customer:</strong> <?php echo htmlspecialchars($selectedCustomer['CustomerName']); ?><br>
                                    <strong>Code:</strong> <?php echo htmlspecialchars($selectedCustomer['CustomerCode']); ?><br>
                                    <strong>Company:</strong> <?php echo safe_htmlspecialchars($selectedCustomer['CompanyName']); ?>
                                </div>
                                <div class="col-md-4">
                                    <strong>Phone:</strong> <?php echo safe_htmlspecialchars($selectedCustomer['Phone']); ?><br>
                                    <strong>Email:</strong> <?php echo safe_htmlspecialchars($selectedCustomer['Email']); ?>
                                </div>
                                <div class="col-md-4">
                                    <strong>Credit Limit:</strong> ₹<?php echo number_format($selectedCustomer['CreditLimit'], 2); ?><br>
                                    <strong>Current Balance:</strong> ₹<?php echo number_format($selectedCustomer['CurrentBalance'], 2); ?><br>
                                    <a href="ledger.php?customer_id=<?php echo $selectedCustomer['ID']; ?>" class="btn btn-sm btn-info mt-2">
                                        <i class="fas fa-file-alt"></i> View Ledger
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- Accounts Table -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">Account Transactions</h6>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Customer</th>
                                            <th>Invoice #</th>
                                            <th>Type</th>
                                            <th>Amount</th>
                                            <th>Tax</th>
                                            <th>Paid</th>
                                            <th>Balance</th>
                                            <th>Due Date</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php while ($row = mysqli_fetch_assoc($accountsResult)): 
                                            // Check if overdue
                                            $isOverdue = ($row['Status'] != 'Paid' && $row['DueDate'] && strtotime($row['DueDate']) < strtotime(date('Y-m-d')));
                                            $statusClass = $isOverdue ? 'danger' : ($row['Status'] == 'Paid' ? 'success' : ($row['Status'] == 'Partial' ? 'warning' : 'primary'));
                                            $statusText = $isOverdue ? 'Overdue' : $row['Status'];
                                        ?>
                                            <tr>
                                                <td><?php echo date('M d, Y', strtotime($row['TransactionDate'])); ?></td>
                                                <td>
                                                    <?php echo safe_htmlspecialchars($row['CustomerCode']); ?><br>
                                                    <small><?php echo safe_htmlspecialchars($row['CustomerName']); ?></small>
                                                </td>
                                                <td><?php echo safe_htmlspecialchars($row['InvoiceNumber']); ?></td>
                                                <td>
                                                    <span class="badge badge-<?php 
                                                        echo $row['TransactionType'] == 'Invoice' ? 'primary' : 
                                                            ($row['TransactionType'] == 'Payment' ? 'success' : 'info'); 
                                                    ?>">
                                                        <?php echo $row['TransactionType']; ?>
                                                    </span>
                                                </td>
                                                <td>₹<?php echo number_format($row['Amount'], 2); ?></td>
                                                <td>₹<?php echo number_format($row['TaxAmount'], 2); ?></td>
                                                <td>₹<?php echo number_format($row['PaidAmount'], 2); ?></td>
                                                <td>₹<?php echo number_format($row['BalanceAmount'], 2); ?></td>
                                                <td><?php echo $row['DueDate'] ? date('M d, Y', strtotime($row['DueDate'])) : '-'; ?></td>
                                                <td>
                                                    <span class="badge badge-<?php echo $statusClass; ?>">
                                                        <?php echo $statusText; ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <div class="btn-group" role="group">
                                                        <button class="btn btn-sm btn-info edit-transaction" 
                                                                data-id="<?php echo $row['ID']; ?>"
                                                                data-customer="<?php echo $row['CustomerID']; ?>"
                                                                data-invoice="<?php echo safe_htmlspecialchars($row['InvoiceNumber']); ?>"
                                                                data-type="<?php echo $row['TransactionType']; ?>"
                                                                data-date="<?php echo $row['TransactionDate']; ?>"
                                                                data-due="<?php echo $row['DueDate']; ?>"
                                                                data-amount="<?php echo $row['Amount']; ?>"
                                                                data-tax="<?php echo $row['TaxAmount']; ?>"
                                                                data-description="<?php echo safe_htmlspecialchars($row['Description']); ?>"
                                                                data-mode="<?php echo safe_htmlspecialchars($row['PaymentMode']); ?>"
                                                                data-reference="<?php echo safe_htmlspecialchars($row['ReferenceNumber']); ?>">
                                                            <i class="fas fa-edit"></i>
                                                        </button>
                                                        <?php if ($row['TransactionType'] == 'Invoice' && $row['Status'] != 'Paid'): ?>
                                                        <button class="btn btn-sm btn-success update-payment" 
                                                                data-id="<?php echo $row['ID']; ?>"
                                                                data-amount="<?php echo $row['Amount']; ?>"
                                                                data-paid="<?php echo $row['PaidAmount']; ?>"
                                                                data-balance="<?php echo $row['BalanceAmount']; ?>"
                                                                data-invoice="<?php echo safe_htmlspecialchars($row['InvoiceNumber']); ?>">
                                                            <i class="fas fa-money-check"></i>
                                                        </button>
                                                        <?php endif; ?>
                                                        <button class="btn btn-sm btn-danger delete-transaction" 
                                                                data-id="<?php echo $row['ID']; ?>"
                                                                data-invoice="<?php echo safe_htmlspecialchars($row['InvoiceNumber']); ?>">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                        <a href="ledger.php?customer_id=<?php echo $row['CustomerID']; ?>" class="btn btn-sm btn-secondary">
                                                            <i class="fas fa-book"></i>
                                                        </a>
                                                        <?php if ($row['AttachmentPath']): ?>
                                                        <a href="<?php echo $row['AttachmentPath']; ?>" target="_blank" class="btn btn-sm btn-warning">
                                                            <i class="fas fa-file"></i>
                                                        </a>
                                                        <?php endif; ?>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endwhile; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.container-fluid -->
            </div>
            <!-- End of Main Content -->

            <!-- Footer -->
            <?php include_once('includes/customer-footer.php'); ?>
            <!-- End of Footer -->
        </div>
        <!-- End of Content Wrapper -->
    </div>
    <!-- End of Page Wrapper -->

    <!-- Add Transaction Modal -->
    <div class="modal fade" id="addTransactionModal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <form method="POST" enctype="multipart/form-data">
                    <input type="hidden" name="action" value="add_transaction">
                    <div class="modal-header">
                        <h5 class="modal-title">Add New Transaction</h5>
                        <button type="button" class="close" data-dismiss="modal">
                            <span>&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Customer *</label>
                                    <select name="customer_id" class="form-control" required>
                                        <option value="">Select Customer</option>
                                        <?php 
                                        mysqli_data_seek($customersResult, 0);
                                        while ($customer = mysqli_fetch_assoc($customersResult)): 
                                        ?>
                                            <option value="<?php echo $customer['ID']; ?>" 
                                                    <?php echo ($selectedCustomer && $selectedCustomer['ID'] == $customer['ID']) ? 'selected' : ''; ?>>
                                                <?php echo safe_htmlspecialchars($customer['CustomerCode'] . ' - ' . $customer['CustomerName']); ?>
                                            </option>
                                        <?php endwhile; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Transaction Type *</label>
                                    <select name="transaction_type" class="form-control" required>
                                        <option value="Invoice">Invoice</option>
                                        <option value="Payment">Payment</option>
                                        <option value="Credit Note">Credit Note</option>
                                        <option value="Debit Note">Debit Note</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Invoice Number *</label>
                                    <input type="text" name="invoice_number" class="form-control" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Transaction Date *</label>
                                    <input type="date" name="transaction_date" class="form-control" required value="<?php echo date('Y-m-d'); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Amount *</label>
                                    <input type="number" name="amount" class="form-control" step="0.01" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Tax Amount</label>
                                    <input type="number" name="tax_amount" class="form-control" step="0.01" value="0">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Due Date</label>
                                    <input type="date" name="due_date" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Payment Mode</label>
                                    <select name="payment_mode" class="form-control">
                                        <option value="">Select Mode</option>
                                        <option value="Cash">Cash</option>
                                        <option value="Bank Transfer">Bank Transfer</option>
                                        <option value="UPI">UPI</option>
                                        <option value="Card">Card</option>
                                        <option value="Cheque">Cheque</option>
                                        <option value="Online">Online</option>
                                        <option value="NEFT">NEFT</option>
                                        <option value="RTGS">RTGS</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Reference Number</label>
                                    <input type="text" name="reference_number" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Attachment</label>
                                    <input type="file" name="attachment" class="form-control-file">
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label>Description</label>
                            <textarea name="description" class="form-control" rows="3"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Add Transaction</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Update Payment Modal -->
    <div class="modal fade" id="updatePaymentModal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <form method="POST">
                    <input type="hidden" name="action" value="update_payment">
                    <input type="hidden" name="account_id" id="payment_account_id">
                    <div class="modal-header">
                        <h5 class="modal-title">Update Payment</h5>
                        <button type="button" class="close" data-dismiss="modal">
                            <span>&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label>Invoice Number</label>
                            <input type="text" id="payment_invoice" class="form-control" readonly>
                        </div>
                        <div class="form-group">
                            <label>Total Amount</label>
                            <input type="text" id="payment_total_amount" class="form-control" readonly>
                        </div>
                        <div class="form-group">
                            <label>Already Paid</label>
                            <input type="text" id="payment_already_paid" class="form-control" readonly>
                        </div>
                        <div class="form-group">
                            <label>Current Balance</label>
                            <input type="text" id="payment_current_balance" class="form-control" readonly>
                        </div>
                        <div class="form-group">
                            <label>Payment Date *</label>
                            <input type="date" name="payment_date" id="payment_date" class="form-control" required value="<?php echo date('Y-m-d'); ?>">
                        </div>
                        <div class="form-group">
                            <label>Payment Amount *</label>
                            <input type="number" name="paid_amount" id="payment_amount" class="form-control" step="0.01" required>
                        </div>
                        <div class="form-group">
                            <label>Payment Mode</label>
                            <select name="payment_mode" id="payment_mode" class="form-control">
                                <option value="Cash">Cash</option>
                                <option value="Bank Transfer">Bank Transfer</option>
                                <option value="UPI">UPI</option>
                                <option value="Card">Card</option>
                                <option value="Cheque">Cheque</option>
                                <option value="Online">Online</option>
                                <option value="NEFT">NEFT</option>
                                <option value="RTGS">RTGS</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Reference Number</label>
                            <input type="text" name="payment_reference" id="payment_reference" class="form-control" placeholder="UTR/Transaction ID/Cheque No.">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-success">Update Payment</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Edit Transaction Modal -->
    <div class="modal fade" id="editTransactionModal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <form method="POST" enctype="multipart/form-data">
                    <input type="hidden" name="action" value="edit_transaction">
                    <input type="hidden" name="transaction_id" id="edit_transaction_id">
                    <div class="modal-header">
                        <h5 class="modal-title">Edit Transaction</h5>
                        <button type="button" class="close" data-dismiss="modal">
                            <span>&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Customer *</label>
                                    <select name="customer_id" id="edit_customer_id" class="form-control" required>
                                        <option value="">Select Customer</option>
                                        <?php 
                                        mysqli_data_seek($customersResult, 0);
                                        while ($customer = mysqli_fetch_assoc($customersResult)): 
                                        ?>
                                            <option value="<?php echo $customer['ID']; ?>">
                                                <?php echo safe_htmlspecialchars($customer['CustomerCode'] . ' - ' . $customer['CustomerName']); ?>
                                            </option>
                                        <?php endwhile; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Transaction Type *</label>
                                    <select name="transaction_type" id="edit_transaction_type" class="form-control" required>
                                        <option value="Invoice">Invoice</option>
                                        <option value="Payment">Payment</option>
                                        <option value="Credit Note">Credit Note</option>
                                        <option value="Debit Note">Debit Note</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Invoice Number *</label>
                                    <input type="text" name="invoice_number" id="edit_invoice_number" class="form-control" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Transaction Date *</label>
                                    <input type="date" name="transaction_date" id="edit_transaction_date" class="form-control" required>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Amount *</label>
                                    <input type="number" name="amount" id="edit_amount" class="form-control" step="0.01" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Tax Amount</label>
                                    <input type="number" name="tax_amount" id="edit_tax_amount" class="form-control" step="0.01" value="0">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Due Date</label>
                                    <input type="date" name="due_date" id="edit_due_date" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Payment Mode</label>
                                    <select name="payment_mode" id="edit_payment_mode" class="form-control">
                                        <option value="">Select Mode</option>
                                        <option value="Cash">Cash</option>
                                        <option value="Bank Transfer">Bank Transfer</option>
                                        <option value="UPI">UPI</option>
                                        <option value="Card">Card</option>
                                        <option value="Cheque">Cheque</option>
                                        <option value="Online">Online</option>
                                        <option value="NEFT">NEFT</option>
                                        <option value="RTGS">RTGS</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Reference Number</label>
                                    <input type="text" name="reference_number" id="edit_reference_number" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Attachment</label>
                                    <input type="file" name="attachment" class="form-control-file">
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label>Description</label>
                            <textarea name="description" id="edit_description" class="form-control" rows="3"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Update Transaction</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Delete Transaction Modal -->
    <div class="modal fade" id="deleteTransactionModal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <form method="POST">
                    <input type="hidden" name="action" value="delete_transaction">
                    <input type="hidden" name="transaction_id" id="delete_transaction_id">
                    <div class="modal-header">
                        <h5 class="modal-title">Delete Transaction</h5>
                        <button type="button" class="close" data-dismiss="modal">
                            <span>&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p>Are you sure you want to delete this transaction?</p>
                        <p><strong>Invoice Number:</strong> <span id="delete_invoice_number"></span></p>
                        <div class="alert alert-warning">
                            <strong>Warning:</strong> This action cannot be undone and will affect the customer's balance.
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete Transaction</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Page level plugins -->
    <script src="../vendor/datatables/jquery.dataTables.min.js"></script>
    <script src="../vendor/datatables/dataTables.bootstrap4.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>

    <!-- Page level custom scripts -->
    <script>
        $(document).ready(function() {
            $('#dataTable').DataTable();
            
            // Handle update payment
            $('.update-payment').click(function() {
                var accountId = $(this).data('id');
                var totalAmount = $(this).data('amount');
                var paidAmount = $(this).data('paid');
                var balanceAmount = $(this).data('balance');
                var invoiceNumber = $(this).data('invoice');
                
                $('#payment_account_id').val(accountId);
                $('#payment_invoice').val(invoiceNumber);
                $('#payment_total_amount').val('₹' + parseFloat(totalAmount).toFixed(2));
                $('#payment_already_paid').val('₹' + parseFloat(paidAmount).toFixed(2));
                $('#payment_current_balance').val('₹' + parseFloat(balanceAmount).toFixed(2));
                $('#payment_amount').attr('max', balanceAmount);
                $('#payment_amount').val(balanceAmount);
                
                $('#updatePaymentModal').modal('show');
            });
            
            // Handle edit transaction
            $('.edit-transaction').click(function() {
                var transactionId = $(this).data('id');
                var customerId = $(this).data('customer');
                var invoiceNumber = $(this).data('invoice');
                var transactionType = $(this).data('type');
                var transactionDate = $(this).data('date');
                var dueDate = $(this).data('due');
                var amount = $(this).data('amount');
                var taxAmount = $(this).data('tax');
                var description = $(this).data('description');
                var paymentMode = $(this).data('mode');
                var referenceNumber = $(this).data('reference');
                
                $('#edit_transaction_id').val(transactionId);
                $('#edit_customer_id').val(customerId);
                $('#edit_invoice_number').val(invoiceNumber);
                $('#edit_transaction_type').val(transactionType);
                $('#edit_transaction_date').val(transactionDate);
                $('#edit_due_date').val(dueDate);
                $('#edit_amount').val(amount);
                $('#edit_tax_amount').val(taxAmount);
                $('#edit_description').val(description);
                $('#edit_payment_mode').val(paymentMode);
                $('#edit_reference_number').val(referenceNumber);
                
                $('#editTransactionModal').modal('show');
            });
            
            // Handle delete transaction
            $('.delete-transaction').click(function() {
                var transactionId = $(this).data('id');
                var invoiceNumber = $(this).data('invoice');
                
                $('#delete_transaction_id').val(transactionId);
                $('#delete_invoice_number').text(invoiceNumber);
                
                $('#deleteTransactionModal').modal('show');
            });
        });
    </script>
</body>
</html>
