<?php
session_start();
include_once('includes/config.php');

if (!isset($_SESSION['uid'])) {
    echo "Please login first.";
    exit();
}

echo "<h3>Beneficiary Table Test</h3>";

// Check if table exists
$tableCheck = mysqli_query($con, "SHOW TABLES LIKE 'tblbeneficiaries'");
if (mysqli_num_rows($tableCheck) == 0) {
    echo "<p style='color: red;'>❌ Table 'tblbeneficiaries' does not exist!</p>";
    echo "<p>Please run the SQL from 'beneficiary_table.sql' in phpMyAdmin.</p>";
    exit();
} else {
    echo "<p style='color: green;'>✅ Table 'tblbeneficiaries' exists!</p>";
}

// Check if table has data
$countQuery = mysqli_query($con, "SELECT COUNT(*) as total FROM tblbeneficiaries");
$count = mysqli_fetch_assoc($countQuery);
echo "<p>Total beneficiaries in database: <strong>" . $count['total'] . "</strong></p>";

if ($count['total'] == 0) {
    echo "<p style='color: orange;'>⚠️ No beneficiaries found. Please add some beneficiaries first.</p>";
} else {
    // Show first few beneficiaries
    $beneficiaries = mysqli_query($con, "SELECT BeneficiaryName, BeneficiaryType, IsActive FROM tblbeneficiaries LIMIT 5");
    echo "<h4>Sample Beneficiaries:</h4>";
    echo "<ul>";
    while ($row = mysqli_fetch_assoc($beneficiaries)) {
        $status = $row['IsActive'] ? 'Active' : 'Inactive';
        echo "<li>" . htmlspecialchars($row['BeneficiaryName']) . " (" . $row['BeneficiaryType'] . ") - " . $status . "</li>";
    }
    echo "</ul>";
}

// Test API endpoint
echo "<hr><h4>Testing API Endpoint:</h4>";
echo "<p>API URL: <code>api/beneficiary-search.php?q=test</code></p>";

// Test with a sample search
if ($count['total'] > 0) {
    $testQuery = mysqli_query($con, "SELECT BeneficiaryName FROM tblbeneficiaries WHERE IsActive=1 LIMIT 1");
    if ($testRow = mysqli_fetch_assoc($testQuery)) {
        $testName = substr($testRow['BeneficiaryName'], 0, 3);
        echo "<p>Try searching for: <strong>" . $testName . "</strong></p>";
        echo "<a href='api/beneficiary-search.php?q=" . urlencode($testName) . "' target='_blank'>Test API Call</a>";
    }
}
?>

<script>
// Test AJAX call
function testAjax() {
    $.ajax({
        url: 'api/beneficiary-search.php',
        dataType: 'json',
        data: { q: 'a' },
        success: function(data) {
            console.log('AJAX Success:', data);
            alert('AJAX Success! Check console for results.');
        },
        error: function(xhr, status, error) {
            console.log('AJAX Error:', xhr.responseText);
            alert('AJAX Error: ' + error + '\nCheck console for details.');
        }
    });
}
</script>

<p><button onclick="testAjax()">Test AJAX Call</button></p>
<p><em>Open browser console (F12) to see AJAX results.</em></p>

<script src="vendor/jquery/jquery.min.js"></script>
