<?php
include_once('includes/config.php');

echo "<h2>Database Setup for Beneficiary Module</h2>";

// Read the SQL file
$sql = file_get_contents('beneficiary_table.sql');

if (!$sql) {
    echo "<p style='color: red;'>❌ Could not read beneficiary_table.sql file.</p>";
    exit();
}

echo "<h3>Executing SQL...</h3>";

// Split by semicolon to execute each statement separately
$statements = array_filter(array_map('trim', explode(';', $sql)));

$success = 0;
$errors = 0;

foreach ($statements as $statement) {
    if (empty($statement) || strpos($statement, '--') === 0) {
        continue; // Skip empty lines and comments
    }
    
    echo "<p>Executing: " . substr($statement, 0, 50) . "...</p>";
    
    $result = mysqli_query($con, $statement);
    
    if ($result) {
        echo "<span style='color: green;'>✅ Success</span><br>";
        $success++;
    } else {
        echo "<span style='color: red;'>❌ Error: " . mysqli_error($con) . "</span><br>";
        $errors++;
    }
}

echo "<hr>";
echo "<h3>Summary:</h3>";
echo "<p>✅ Successful statements: $success</p>";
echo "<p>❌ Failed statements: $errors</p>";

if ($errors == 0) {
    echo "<p style='color: green; font-weight: bold;'>🎉 Database setup completed successfully!</p>";
    echo "<p><a href='test-beneficiary.php'>Test the setup</a></p>";
} else {
    echo "<p style='color: orange;'>⚠️ Some statements failed. Check the errors above.</p>";
}

// Test if table was created
echo "<hr><h3>Verification:</h3>";
$tableCheck = mysqli_query($con, "SHOW TABLES LIKE 'tblbeneficiaries'");
if (mysqli_num_rows($tableCheck) > 0) {
    echo "<p style='color: green;'>✅ Table 'tblbeneficiaries' exists!</p>";
    
    $countQuery = mysqli_query($con, "SELECT COUNT(*) as total FROM tblbeneficiaries");
    $count = mysqli_fetch_assoc($countQuery);
    echo "<p>📊 Total beneficiaries: " . $count['total'] . "</p>";
} else {
    echo "<p style='color: red;'>❌ Table 'tblbeneficiaries' was not created!</p>";
}
?>
