<?php
session_start();
include_once('includes/config.php');

if (!isset($_SESSION['uid'])) {
    header('location:logout.php');
    exit();
}

// Get expense data
$expenseId = isset($_GET['id']) ? intval($_GET['id']) : 0;
$userId = $_SESSION['uid'];
$userType = $_SESSION['usertype'];

if ($expenseId <= 0) {
    echo "Invalid expense ID";
    exit();
}

// Fetch expense details
$query = "SELECT e.*, u.FullName FROM tblexpenses e LEFT JOIN tblusers u ON e.UserID=u.ID WHERE e.ID='$expenseId'";

// Check permissions
if ($userType != 'admin') {
    $query .= " AND e.UserID='$userId'";
}

$result = mysqli_query($con, $query);
if (!$result || mysqli_num_rows($result) == 0) {
    echo "Expense not found or access denied";
    exit();
}

$expense = mysqli_fetch_assoc($result);

// Convert amount to words
function convertAmountToWords($amount) {
    $ones = array(
        '', 'One', 'Two', 'Three', 'Four', 'Five', 'Six', 'Seven', 'Eight', 'Nine',
        'Ten', 'Eleven', 'Twelve', 'Thirteen', 'Fourteen', 'Fifteen', 'Sixteen',
        'Seventeen', 'Eighteen', 'Nineteen'
    );
    $tens = array('', '', 'Twenty', 'Thirty', 'Forty', 'Fifty', 'Sixty', 'Seventy', 'Eighty', 'Ninety');
    
    if ($amount == 0) return 'Zero';
    
    $amount = number_format($amount, 2, '.', '');
    list($rupees, $paise) = explode('.', $amount);
    
    $result = '';
    
    // Convert rupees
    if ($rupees > 0) {
        $result = convertNumberToWords($rupees, $ones, $tens) . ' Rupees';
    }
    
    // Convert paise
    if ($paise > 0) {
        if ($result) $result .= ' and ';
        $result .= convertNumberToWords($paise, $ones, $tens) . ' Paise';
    }
    
    return $result . ' Only';
}

function convertNumberToWords($number, $ones, $tens) {
    if ($number < 20) {
        return $ones[$number];
    } elseif ($number < 100) {
        return $tens[intval($number / 10)] . ' ' . $ones[$number % 10];
    } elseif ($number < 1000) {
        return $ones[intval($number / 100)] . ' Hundred ' . convertNumberToWords($number % 100, $ones, $tens);
    } elseif ($number < 100000) {
        return convertNumberToWords(intval($number / 1000), $ones, $tens) . ' Thousand ' . convertNumberToWords($number % 1000, $ones, $tens);
    } elseif ($number < 10000000) {
        return convertNumberToWords(intval($number / 100000), $ones, $tens) . ' Lakh ' . convertNumberToWords($number % 100000, $ones, $tens);
    } else {
        return convertNumberToWords(intval($number / 10000000), $ones, $tens) . ' Crore ' . convertNumberToWords($number % 10000000, $ones, $tens);
    }
}

$amountInWords = convertAmountToWords($expense['ExpenseAmount']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Cash Payment Voucher - <?php echo $expense['ID']; ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        @page {
            size: A4;
            margin: 20mm;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            font-size: 12px;
            line-height: 1.3;
            color: #2c3e50;
            margin: 0;
            padding: 0;
            background: white;
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        
        .voucher-container {
            width: 180mm;
            height: auto;
            max-height: 120mm;
            border: 2px solid #34495e;
            padding: 8px;
            background: white;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            border-radius: 4px;
            display: flex;
            flex-direction: column;
            margin: 20px;
        }
        
        .company-header {
            text-align: center;
            margin-bottom: 6px;
            padding-bottom: 4px;
            border-bottom: 2px solid #34495e;
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            margin: -8px -8px 6px -8px;
            padding: 6px 8px 4px 8px;
            border-radius: 2px 2px 0 0;
        }
        
        .company-name {
            font-size: 16px;
            font-weight: 700;
            color: #2c3e50;
            margin-bottom: 2px;
            letter-spacing: 0.5px;
            text-transform: uppercase;
        }
        
        .company-address {
            font-size: 10px;
            color: #7f8c8d;
            margin-bottom: 3px;
            line-height: 1.1;
            font-weight: 500;
        }
        
        .voucher-title {
            font-size: 12px;
            font-weight: 700;
            color: #e74c3c;
            background: #fff;
            padding: 2px 8px;
            border: 1px solid #e74c3c;
            border-radius: 8px;
            display: inline-block;
            letter-spacing: 0.3px;
        }
        
        .voucher-header {
            display: flex;
            justify-content: space-between;
            margin-bottom: 6px;
            font-weight: 600;
            background: #ecf0f1;
            padding: 4px 6px;
            border-radius: 3px;
            border-left: 3px solid #3498db;
        }
        
        .voucher-no, .voucher-date {
            font-size: 11px;
            color: #2c3e50;
        }
        
        .voucher-no strong, .voucher-date strong {
            color: #e74c3c;
            font-size: 12px;
        }
        
        .payment-details {
            flex: 1;
            margin-bottom: 6px;
        }
        
        .detail-row {
            display: flex;
            margin-bottom: 4px;
            align-items: center;
        }
        
        .detail-label {
            font-weight: 600;
            min-width: 90px;
            margin-right: 6px;
            color: #34495e;
            font-size: 11px;
        }
        
        .detail-value {
            flex: 1;
            border-bottom: 1px dotted #bdc3c7;
            padding: 2px 4px;
            min-height: 16px;
            background: #fafbfc;
            font-weight: 500;
            color: #2c3e50;
            font-size: 11px;
            border-radius: 2px 2px 0 0;
        }
        
        .amount-section {
            display: flex;
            gap: 6px;
            margin-bottom: 4px;
            background: #f8f9fa;
            padding: 4px;
            border-radius: 3px;
            border: 1px solid #dee2e6;
        }
        
        .amount-words {
            flex: 2.5;
        }
        
        .amount-words .detail-value {
            background: #fff;
            border: 1px solid #dee2e6;
            border-bottom: 2px solid #28a745;
            font-weight: 600;
            color: #28a745;
            font-size: 10px;
            padding: 3px;
            min-height: 16px;
        }
        
        .amount-figures {
            flex: 1;
        }
        
        .amount-figures .detail-value {
            text-align: center;
            font-weight: 700;
            font-size: 14px;
            color: #e74c3c;
            background: #fff;
            border: 2px solid #e74c3c;
            border-radius: 3px;
            padding: 3px;
            min-height: 16px;
        }
        
        .detail-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 6px;
            margin-bottom: 4px;
        }
        
        .highlight-box {
            background: linear-gradient(135deg, #74b9ff 0%, #0984e3 100%);
            color: white;
            padding: 3px 4px;
            border-radius: 3px;
            font-weight: 600;
            text-align: center;
            font-size: 10px;
        }
        
        .compact-grid {
            display: grid;
            grid-template-columns: 1fr 1fr 1fr;
            gap: 4px;
            margin-bottom: 4px;
        }
        
        .signatures {
            margin-top: auto;
            display: flex;
            justify-content: space-between;
            background: #f8f9fa;
            padding: 4px;
            border-radius: 3px;
            border: 1px solid #dee2e6;
        }
        
        .signature-block {
            text-align: center;
            width: 110px;
        }
        
        .signature-line {
            border-bottom: 1px solid #34495e;
            height: 16px;
            margin-bottom: 2px;
            background: #fff;
            border-radius: 2px 2px 0 0;
        }
        
        .signature-block strong {
            color: #34495e;
            font-size: 10px;
            font-weight: 600;
        }
        
        .signature-block small {
            font-size: 9px;
            color: #7f8c8d;
        }
        
        @media print {
            body {
                padding: 0;
                margin: 0;
                font-size: 11px;
                min-height: 100vh;
                display: flex;
                justify-content: center;
                align-items: center;
            }
            
            .no-print {
                display: none;
            }
            
            .voucher-container {
                border: 2px solid #34495e;
                max-width: none;
                margin: 0;
                box-shadow: none;
                border-radius: 4px;
                width: 180mm;
                height: auto;
                max-height: 120mm;
            }
            
            .company-header {
                margin: -8px -8px 6px -8px;
                border-radius: 2px 2px 0 0;
            }
            
            @page {
                size: A4;
                margin: 20mm;
            }
        }
        
        .print-button {
            position: fixed;
            top: 10px;
            right: 10px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 8px 16px;
            border-radius: 15px;
            cursor: pointer;
            font-size: 12px;
            font-weight: 600;
            z-index: 1000;
            box-shadow: 0 2px 8px rgba(0,0,0,0.2);
            transition: all 0.3s ease;
            font-family: 'Segoe UI', sans-serif;
        }
        
        .print-button:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.3);
        }
        
        .watermark {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-45deg);
            font-size: 30px;
            color: rgba(231, 76, 60, 0.03);
            font-weight: 900;
            z-index: 1;
            pointer-events: none;
        }
        
        .footer-note {
            text-align: center;
            font-size: 8px;
            color: #95a5a6;
            font-style: italic;
            margin-top: 2px;
        }
    </style>
</head>
<body>
    <button class="print-button no-print" onclick="window.print()">
        🖨️ Print
    </button>
    
    <div class="voucher-container">
        <div class="watermark">Feal Industries</div>
        
        <!-- Company Header -->
        <div class="company-header">
            <div class="company-name">Feal Industries Private Limited</div>
            <div class="company-address">
                D 37, Sidco Industrial Estate, Kappalur, Madurai - 625 008, Tamil Nadu, India
            </div>
            <div class="voucher-title">Cash Payment Voucher</div>
        </div>
        
        <!-- Voucher Header -->
        <div class="voucher-header">
            <div class="voucher-no">Voucher No.: <strong>IPL-<?php echo str_pad($expense['ID'], 4, '0', STR_PAD_LEFT); ?></strong></div>
            <div class="voucher-date">Date: <strong><?php echo date('d/m/Y', strtotime($expense['EntryDate'])); ?></strong></div>
        </div>
        
        <!-- Payment Details -->
        <div class="payment-details">
            <div class="detail-row">
                <div class="detail-label">Pay To:</div>
                <div class="detail-value"><?php echo htmlspecialchars($expense['ExpenseTitle']); ?></div>
            </div>
            
            <div class="amount-section">
                <div class="amount-words">
                    <div class="detail-label">Amount in Words:</div>
                    <div class="detail-value"><?php echo $amountInWords; ?></div>
                </div>
                <div class="amount-figures">
                    <div class="detail-label">Amount:</div>
                    <div class="detail-value">₹ <?php echo number_format($expense['ExpenseAmount'], 2); ?></div>
                </div>
            </div>
            
            <div class="detail-row">
                <div class="detail-label">Purpose:</div>
                <div class="detail-value"><?php echo htmlspecialchars($expense['ExpenseDetails'] ?: 'General Business Expense'); ?></div>
            </div>
            
            <div class="compact-grid">
                <div class="detail-row">
                    <div class="detail-label">Mode:</div>
                    <div class="detail-value highlight-box" style="background: <?php echo $expense['PaymentMode'] == 'Cash' ? '#e74c3c' : '#27ae60'; ?>;">
                        <?php echo htmlspecialchars($expense['PaymentMode']); ?>
                    </div>
                </div>
                <div class="detail-row">
                    <div class="detail-label">Date:</div>
                    <div class="detail-value"><?php echo date('d/m/Y', strtotime($expense['EntryDate'])); ?></div>
                </div>
                <?php if ($userType == 'admin' && $expense['FullName']) { ?>
                <div class="detail-row">
                    <div class="detail-label">Staff:</div>
                    <div class="detail-value" style="background: #e8f5e8; color: #27ae60; font-weight: 600; font-size: 8px;">
                        <?php echo htmlspecialchars($expense['FullName']); ?>
                    </div>
                </div>
                <?php } ?>
            </div>
            
            <div class="detail-row">
                <div class="detail-label">Bank:</div>
                <div class="detail-value">
                    <?php 
                    if ($expense['PaymentMode'] == 'Bank Transfer' || $expense['PaymentMode'] == 'Cheque') {
                        echo "________________________";
                    } else {
                        echo "Not Applicable";
                    }
                    ?>
                </div>
            </div>
        </div>
        
        <!-- Signatures -->
        <div class="signatures">
            <div class="signature-block">
                <div class="signature-line"></div>
                <div><strong>Authorized Signatory</strong></div>
                <div><small>Finance Department</small></div>
            </div>
            <div class="signature-block">
                <div class="signature-line"></div>
                <div><strong>Recipient Signature</strong></div>
                <div><small>Acknowledgment</small></div>
            </div>
        </div>
        
        <div class="footer-note">
            Computer generated voucher - No signature required
        </div>
    </div>
    
    <script>
        // Enhanced print functionality
        window.onload = function() {
            // Optional auto-print
            // setTimeout(() => window.print(), 500);
        }
        
        window.onafterprint = function() {
            // Optional auto-close
            // window.close();
        }
        
        // Add print shortcut
        document.addEventListener('keydown', function(e) {
            if (e.ctrlKey && e.key === 'p') {
                e.preventDefault();
                window.print();
            }
        });
    </script>
</body>
</html>
