<?php
/**
 * Safe database query helper functions
 * Added to handle mysqli_fetch_assoc errors gracefully
 */

function safe_fetch_value($con, $query, $key = 'total', $default = 0) {
    $result = mysqli_query($con, $query);
    if ($result) {
        $row = mysqli_fetch_assoc($result);
        return $row && isset($row[$key]) ? $row[$key] : $default;
    }
    return $default;
}

function safe_fetch_row($con, $query) {
    $result = mysqli_query($con, $query);
    return $result ? mysqli_fetch_assoc($result) : null;
}
?>
