# Finance Management Module

A comprehensive income and expense management system with opening and closing balances, built without sidebar navigation for a clean, focused interface.

## Features

### 📊 **Dashboard Overview**
- Real-time balance display with opening and closing amounts
- Today's income and expense tracking
- Monthly statistics and trends
- Recent transactions overview
- Quick action buttons for common tasks

### 💰 **Transaction Management**
- Add income and expense transactions
- Multiple payment methods (Cash, Bank, Card, Cheque, Online)
- Category-wise organization
- Reference numbers for tracking
- Date-wise filtering and search

### 🏦 **Account Management**
- Multiple account types (Income, Expense, Asset, Liability)
- Opening and current balance tracking
- Account status management (Active/Inactive)
- Transaction history per account

### 📈 **Reporting & Analytics**
- Daily, monthly, and custom date range reports
- Category-wise breakdown with charts
- Income vs expense analysis
- Export to CSV functionality
- Print-friendly reports

### 🎨 **Enhanced Design**
- Modern gradient cards and animations
- Responsive design for all devices
- No sidebar - clean, focused interface
- Color-coded transaction types
- Interactive charts and visualizations

## Installation

1. **Database Setup**
   ```
   Navigate to: /create-finance-module-tables.php
   Click "Create Finance Module Tables"
   ```

2. **Module Access**
   ```
   Direct URL: /finance/
   Admin access required
   ```

## Database Tables

### `tblfinance_accounts`
- Account management with types and balances
- Tracks opening and current balance
- Supports multiple account categories

### `tblfinance_transactions`
- All income and expense transactions
- Links to accounts with foreign keys
- Category and payment method tracking

### `tblfinance_daily_balances`
- Daily opening and closing balances
- Automatic calculation of net amounts
- Historical balance tracking

## File Structure

```
finance/
├── index.php              # Main dashboard
├── add-transaction.php    # Add income/expense form
├── transactions.php       # Transaction list with filters
├── accounts.php          # Account management
├── reports.php           # Financial reports
├── css/
│   └── finance.css       # Custom styling
├── js/
│   └── finance.js        # Interactive features
└── api/
    └── (future API endpoints)
```

## Usage

### Adding Transactions
1. **Quick Add**: Use dashboard quick action buttons
2. **Income**: Green "Add Income" button
3. **Expense**: Red "Add Expense" button
4. **Form Fields**:
   - Account selection
   - Amount (required)
   - Description (required)
   - Date, category, payment method
   - Reference number (optional)

### Managing Accounts
1. Navigate to "Manage Accounts"
2. View summary by account type
3. Add new accounts with opening balances
4. Toggle account status (Active/Inactive)
5. View transaction history per account

### Generating Reports
1. Select report type (Daily/Monthly/Custom)
2. Choose date range or period
3. View summary statistics
4. Analyze category breakdown
5. Export to CSV or print

### Daily Balance Flow
- **Opening Balance**: Previous day's closing balance
- **Daily Income**: Sum of all income transactions
- **Daily Expense**: Sum of all expense transactions
- **Closing Balance**: Opening + Income - Expense

## Key Features

### 🔄 **Automatic Balance Calculation**
- Opening balances carried forward daily
- Real-time closing balance updates
- Account balance synchronization

### 🎯 **User Experience**
- Keyboard shortcuts (Ctrl+I, Ctrl+E, Ctrl+R)
- Auto-save form data
- Real-time validation
- Animated statistics
- Mobile-responsive design

### 📱 **Responsive Design**
- Optimized for desktop, tablet, and mobile
- Touch-friendly interface
- Adaptive layouts
- Print-optimized reports

### 🔒 **Security**
- Admin-only access
- SQL injection protection
- Input validation and sanitization
- Session-based authentication

## Customization

### Colors and Styling
- Edit `css/finance.css` for visual customization
- CSS variables for easy color scheme changes
- Bootstrap-based responsive framework

### Functionality
- Extend `js/finance.js` for additional features
- Add new transaction types or categories
- Implement additional validation rules

## Technical Requirements

- PHP 7.4+
- MySQL 5.7+
- Bootstrap 4.x
- FontAwesome 5.x
- Chart.js (for reports)

## Browser Support

- Chrome 70+
- Firefox 65+
- Safari 12+
- Edge 79+

## Future Enhancements

- [ ] Transaction templates
- [ ] Recurring transactions
- [ ] Budget planning
- [ ] Multi-currency support
- [ ] Advanced analytics
- [ ] Mobile app integration
- [ ] Automated backups
- [ ] User permissions

## Support

For technical issues or feature requests, contact the development team or refer to the main system documentation.

---

**Note**: This module is designed to work independently without the main application sidebar, providing a focused financial management experience.
