<?php
session_start();
include_once('includes/config.php');
if (!isset($_SESSION['uid'])) {
    header('location:logout.php');
    exit();
}

// Function to format numbers in Indian format
function formatIndianCurrency($number) {
    $number = (float)$number;
    if ($number >= 10000000) { // 1 crore and above
        return 'Rs. ' . number_format($number / 10000000, 2) . ' Cr';
    } elseif ($number >= 100000) { // 1 lakh and above
        return 'Rs. ' . number_format($number / 100000, 2) . ' L';
    } else {
        return 'Rs. ' . number_format($number, 2);
    }
}

$userId = $_SESSION['uid'];
$userType = $_SESSION['usertype'];
$msg = "";

// --- CRUD: DELETE FUND ---
if (isset($_GET['del_fund'])) {
    $fundid = intval($_GET['del_fund']);
    // Allow users to delete their own entries, admins can delete any
    $condition = ($userType == 'admin') ? "" : " AND RaisedBy='$userId'";
    $result = mysqli_query($con, "DELETE FROM tblfunds WHERE ID='$fundid'$condition");
    $msg = $result ? "Fund deleted successfully!" : "Error: Unable to delete fund!";
}

// --- CRUD: UPDATE FUND ---
if (isset($_POST['update_fund'])) {
    $fundid = intval($_POST['fund_id']);
    $title = mysqli_real_escape_string($con, $_POST['fund_title']);
    $amount = floatval($_POST['fund_amount']);
    $paymentMode = mysqli_real_escape_string($con, $_POST['payment_mode']);
    $details = mysqli_real_escape_string($con, $_POST['fund_details']);
    $entryDate = mysqli_real_escape_string($con, $_POST['entry_date']);
    
    // Allow users to update their own entries, admins can update any
    $condition = ($userType == 'admin') ? "" : " AND RaisedBy='$userId'";
    $result = mysqli_query($con, "UPDATE tblfunds SET FundTitle='$title', FundAmount='$amount', PaymentMode='$paymentMode', FundDetails='$details', EntryDate='$entryDate' WHERE ID='$fundid'$condition");
    $msg = $result ? "Fund updated successfully!" : "Error: Unable to update fund!";
}

// --- CREATE FUND (all users can add funds) ---
if (isset($_POST['raise_fund'])) {
    $title = mysqli_real_escape_string($con, $_POST['fund_title']);
    $amount = floatval($_POST['fund_amount']);
    $paymentMode = mysqli_real_escape_string($con, $_POST['payment_mode']);
    $details = mysqli_real_escape_string($con, $_POST['fund_details']);
    $entryDate = mysqli_real_escape_string($con, $_POST['entry_date']);
    $res = mysqli_query($con, "INSERT INTO tblfunds (RaisedBy, FundTitle, FundAmount, PaymentMode, FundDetails, EntryDate) VALUES ('$userId', '$title', '$amount', '$paymentMode', '$details', '$entryDate')");
    $msg = $res ? "Fund raised successfully!" : "Error raising fund!";
}

// Get fund data for editing
$editFund = null;
if (isset($_GET['edit_fund'])) {
    $editId = intval($_GET['edit_fund']);
    $condition = ($userType == 'admin') ? "" : " AND RaisedBy='$userId'";
    $editResult = mysqli_query($con, "SELECT * FROM tblfunds WHERE ID='$editId'$condition");
    $editFund = mysqli_fetch_assoc($editResult);
}

// Fetch funds
$funds = mysqli_query($con, "SELECT f.*, u.FullName FROM tblfunds f LEFT JOIN tblusers u ON f.RaisedBy=u.ID ORDER BY f.EntryDate DESC, f.FundDate DESC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Ihita Industries | Fund & Income Management</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="css/sb-admin-2.min.css" rel="stylesheet">
    <style>
        .card { 
            border-radius: 1.5rem; 
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
            border: none;
            margin-bottom: 2rem;
        }
        .card-header { 
            border-radius: 1.5rem 1.5rem 0 0; 
            padding: 1.5rem;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .card-header.bg-primary {
            background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        }
        .card-header.bg-info {
            background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);
        }
        .form-control { 
            font-size: 1rem; 
            border-radius: 1rem; 
            padding: 0.875rem 1.25rem;
            border: 2px solid #e3e6f0;
            transition: all 0.3s ease;
        }
        .form-control:focus {
            border-color: #4e73df;
            box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
        }
        .btn { 
            font-size: 1rem; 
            border-radius: 1rem; 
            padding: 0.75rem 1.5rem;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        .btn-block { 
            padding: 1rem 0; 
            border-radius: 1rem;
        }
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 0.25rem 0.5rem rgba(0, 0, 0, 0.2);
        }
        .table th, .table td { 
            vertical-align: middle !important; 
            padding: 1rem 0.75rem;
        }
        .table th {
            background: linear-gradient(135deg, #f8f9fc 0%, #e9ecef 100%);
            font-weight: 600;
            border-top: none;
        }
        .table-responsive {
            border-radius: 1rem;
            overflow: hidden;
        }
        .alert {
            border-radius: 1rem;
            border: none;
            font-weight: 500;
        }
        .form-group {
            margin-bottom: 1.5rem;
        }
        .form-group label {
            font-weight: 600;
            color: #5a5c69;
            margin-bottom: 0.5rem;
        }
        
        /* Mobile Styles */
        @media (max-width: 991.98px) {
            .container-fluid { 
                padding-left: 1rem; 
                padding-right: 1rem; 
            }
            .card { 
                margin-bottom: 1.5rem; 
                border-radius: 1rem;
            }
            .card-header {
                padding: 1rem;
                border-radius: 1rem 1rem 0 0;
            }
            .card-body {
                padding: 1.5rem;
            }
        }
        
        @media (max-width: 767.98px) {
            .container-fluid { 
                padding-left: 0.75rem; 
                padding-right: 0.75rem; 
            }
            .card { 
                margin-bottom: 1.25rem;
                border-radius: 0.75rem;
            }
            .card-header {
                padding: 0.75rem;
                border-radius: 0.75rem 0.75rem 0 0;
            }
            .card-body {
                padding: 1rem;
            }
            .table-responsive { 
                font-size: 0.875rem;
                border-radius: 0.75rem;
            }
            .table th, .table td {
                padding: 0.5rem 0.25rem;
                font-size: 0.8rem;
            }
            .btn, .btn-block { 
                font-size: 0.9rem; 
                padding: 0.6rem 1rem; 
                border-radius: 0.75rem;
            }
            .btn-sm {
                font-size: 0.75rem;
                padding: 0.25rem 0.5rem;
            }
            .card-header h4, .card-header h5 { 
                font-size: 1rem; 
                margin-bottom: 0;
            }
            .form-control {
                font-size: 0.9rem;
                padding: 0.75rem 1rem;
                border-radius: 0.75rem;
            }
            .form-group {
                margin-bottom: 1rem;
            }
            .alert {
                font-size: 0.9rem;
                padding: 0.75rem;
            }
        }
        
        @media (max-width: 575.98px) {
            .table-responsive {
                border-radius: 0.5rem;
            }
            .table th, .table td {
                padding: 0.4rem 0.2rem;
                font-size: 0.75rem;
            }
            .btn-sm {
                font-size: 0.7rem;
                padding: 0.2rem 0.4rem;
                margin: 0.1rem;
            }
            .card {
                border-radius: 0.5rem;
            }
            .card-header {
                border-radius: 0.5rem 0.5rem 0 0;
                padding: 0.5rem;
            }
            .card-body {
                padding: 0.75rem;
            }
            /* Stack table for very small screens */
            .table-responsive table,
            .table-responsive thead,
            .table-responsive tbody,
            .table-responsive th,
            .table-responsive td,
            .table-responsive tr {
                display: block;
            }
            .table-responsive thead tr {
                position: absolute;
                top: -9999px;
                left: -9999px;
            }
            .table-responsive tr {
                border: 1px solid #ccc;
                margin-bottom: 0.5rem;
                border-radius: 0.5rem;
                padding: 0.5rem;
                background: #fff;
            }
            .table-responsive td {
                border: none;
                position: relative;
                padding: 0.25rem 0.25rem 0.25rem 30%;
                text-align: left;
            }
            .table-responsive td:before {
                content: attr(data-label) ": ";
                position: absolute;
                left: 0.25rem;
                width: 25%;
                padding-right: 0.5rem;
                white-space: nowrap;
                font-weight: bold;
                color: #5a5c69;
            }
        }
    </style>
</head>
<body id="page-top">
    <div id="wrapper">
        <?php include_once('includes/sidebar.php');?>
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include_once('includes/topbar.php');?>
                <div class="container-fluid mt-3 mb-3">
             
                    <?php if($msg) { ?>
                        <div class="alert alert-info text-center"><?php echo $msg; ?></div>
                    <?php } ?>

                    <!-- Add/Edit Fund Form -->
                    <div class="card shadow mb-4">
                        <div class="card-header bg-primary text-white text-center">
                            <h4 class="mb-0"><?php echo $editFund ? 'Edit Fund / Income Entry' : 'Raise Fund / Add Other Income'; ?></h4>
                        </div>
                        <div class="card-body">
                            <form method="post" autocomplete="off">
                                <?php if($editFund) { ?>
                                    <input type="hidden" name="fund_id" value="<?php echo $editFund['ID']; ?>">
                                <?php } ?>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Entry Date</label>
                                            <input type="date" name="entry_date" class="form-control" required value="<?php echo $editFund ? $editFund['EntryDate'] : date('Y-m-d'); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Title</label>
                                            <input type="text" name="fund_title" class="form-control" required value="<?php echo $editFund ? htmlspecialchars($editFund['FundTitle']) : ''; ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Amount</label>
                                            <input type="number" step="0.01" name="fund_amount" class="form-control" required value="<?php echo $editFund ? $editFund['FundAmount'] : ''; ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Payment Mode</label>
                                            <div class="d-flex flex-wrap pt-2">
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" type="radio" name="payment_mode" id="payment_cash_fund" value="Cash" required <?php echo ($editFund && $editFund['PaymentMode'] == 'Cash') ? 'checked' : ''; ?>>
                                                    <label class="form-check-label" for="payment_cash_fund">Cash</label>
                                                </div>
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" type="radio" name="payment_mode" id="payment_bank_fund" value="Bank Transfer" <?php echo ($editFund && $editFund['PaymentMode'] == 'Bank Transfer') ? 'checked' : ''; ?>>
                                                    <label class="form-check-label" for="payment_bank_fund">Bank Transfer</label>
                                                </div>
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" type="radio" name="payment_mode" id="payment_cheque_fund" value="Cheque" <?php echo ($editFund && $editFund['PaymentMode'] == 'Cheque') ? 'checked' : ''; ?>>
                                                    <label class="form-check-label" for="payment_cheque_fund">Cheque</label>
                                                </div>
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" type="radio" name="payment_mode" id="payment_upi_fund" value="UPI" <?php echo ($editFund && $editFund['PaymentMode'] == 'UPI') ? 'checked' : ''; ?>>
                                                    <label class="form-check-label" for="payment_upi_fund">UPI</label>
                                                </div>
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" type="radio" name="payment_mode" id="payment_other_fund" value="Other" <?php echo ($editFund && $editFund['PaymentMode'] == 'Other') ? 'checked' : ''; ?>>
                                                    <label class="form-check-label" for="payment_other_fund">Other</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>Details</label>
                                    <textarea name="fund_details" class="form-control" rows="2"><?php echo $editFund ? htmlspecialchars($editFund['FundDetails']) : ''; ?></textarea>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <button type="submit" name="<?php echo $editFund ? 'update_fund' : 'raise_fund'; ?>" class="btn btn-primary btn-block">
                                            <?php echo $editFund ? 'Update Entry' : 'Add Entry'; ?>
                                        </button>
                                    </div>
                                    <?php if($editFund) { ?>
                                    <div class="col-md-6">
                                        <a href="expense-management.php" class="btn btn-secondary btn-block">Cancel Edit</a>
                                    </div>
                                    <?php } ?>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- Funds Table (All users can view) -->
                    <div class="card shadow mb-4">
                        <div class="card-header bg-info text-white text-center">
                            <h5 class="mb-0">All Fund & Income Entries</h5>
                        </div>
                        <div class="card-body p-2">
                            <div class="table-responsive">
                            <table class="table table-bordered table-sm mb-0">
                                <thead class="thead-light">
                                    <tr>
                                        <th>#</th>
                                        <th>Entry Date</th>
                                        <th>Title</th>
                                        <th>Amount</th>
                                        <th>Payment Mode</th>
                                        <th>Details</th>
                                        <th>Raised By</th>
                                        <th>Date</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php $i=1; while($row = mysqli_fetch_assoc($funds)) { ?>
                                    <tr>
                                        <td data-label="#"><?php echo $i++; ?></td>
                                        <td data-label="Entry Date"><?php echo htmlspecialchars($row['EntryDate']); ?></td>
                                        <td data-label="Title"><?php echo htmlspecialchars($row['FundTitle']); ?></td>
                                        <td data-label="Amount"><?php echo formatIndianCurrency($row['FundAmount']); ?></td>
                                        <td data-label="Payment Mode"><?php echo htmlspecialchars($row['PaymentMode']); ?></td>
                                        <td data-label="Details"><?php echo htmlspecialchars($row['FundDetails']); ?></td>
                                        <td data-label="Raised By"><?php echo htmlspecialchars($row['FullName']); ?></td>
                                        <td data-label="Date"><?php echo htmlspecialchars($row['FundDate']); ?></td>
                                        <td data-label="Actions">
                                            <?php if($userType == 'admin' || $row['RaisedBy'] == $userId) { ?>
                                                <a href="expense-management.php?edit_fund=<?php echo $row['ID']; ?>" class="btn btn-sm btn-warning" title="Edit"><i class="fas fa-edit"></i></a>
                                                <a href="expense-management.php?del_fund=<?php echo $row['ID']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this entry?');" title="Delete"><i class="fas fa-trash"></i></a>
                                            <?php } else { ?>
                                                <span class="text-muted">-</span>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                                </tbody>
                            </table>
                            </div>
                        </div>
                    </div>

                    <a href="dashboard.php" class="btn btn-link btn-block mt-3">Back to Dashboard</a>
                </div>
            </div>
            <?php include_once('includes/footer.php');?>
        </div>
    </div>
    <?php include_once('includes/footer2.php');?>
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="js/sb-admin-2.min.js"></script>
</body>
</html>
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="js/sb-admin-2.min.js"></script>
</body>
</html>
