<?php
session_start();
include_once('../includes/config.php');

// Helper function to safely escape HTML content
function safe_htmlspecialchars($string) {
    return htmlspecialchars($string ?? '', ENT_QUOTES, 'UTF-8');
}

// Check if user is logged in
if (!isset($_SESSION['uid'])) {
    header('location:../login.php');
    exit();
}

$userId = $_SESSION['uid'];
$userType = $_SESSION['usertype'];
$message = '';

// Handle form submission
if ($_POST) {
    $action = $_POST['action'] ?? '';
    
    if ($action == 'add_customer') {
        $customerCode = mysqli_real_escape_string($con, $_POST['customer_code']);
        $customerName = mysqli_real_escape_string($con, $_POST['customer_name']);
        $companyName = mysqli_real_escape_string($con, $_POST['company_name']);
        $email = mysqli_real_escape_string($con, $_POST['email']);
        $phone = mysqli_real_escape_string($con, $_POST['phone']);
        $address = mysqli_real_escape_string($con, $_POST['address']);
        $city = mysqli_real_escape_string($con, $_POST['city']);
        $state = mysqli_real_escape_string($con, $_POST['state']);
        $country = mysqli_real_escape_string($con, $_POST['country']);
        $postalCode = mysqli_real_escape_string($con, $_POST['postal_code']);
        $taxNumber = mysqli_real_escape_string($con, $_POST['tax_number']);
        $creditLimit = floatval($_POST['credit_limit']);
        
        $query = "INSERT INTO tblcustomers (CustomerCode, CustomerName, CompanyName, Email, Phone, Address, City, State, Country, PostalCode, TaxNumber, CreditLimit, AddedBy) 
                  VALUES ('$customerCode', '$customerName', '$companyName', '$email', '$phone', '$address', '$city', '$state', '$country', '$postalCode', '$taxNumber', '$creditLimit', '$userId')";
        
        if (mysqli_query($con, $query)) {
            $message = '<div class="alert alert-success">Customer added successfully!</div>';
        } else {
            $message = '<div class="alert alert-danger">Error: ' . mysqli_error($con) . '</div>';
        }
    }
    
    if ($action == 'update_customer') {
        $customerId = intval($_POST['customer_id']);
        $customerCode = mysqli_real_escape_string($con, $_POST['customer_code']);
        $customerName = mysqli_real_escape_string($con, $_POST['customer_name']);
        $companyName = mysqli_real_escape_string($con, $_POST['company_name']);
        $email = mysqli_real_escape_string($con, $_POST['email']);
        $phone = mysqli_real_escape_string($con, $_POST['phone']);
        $address = mysqli_real_escape_string($con, $_POST['address']);
        $city = mysqli_real_escape_string($con, $_POST['city']);
        $state = mysqli_real_escape_string($con, $_POST['state']);
        $country = mysqli_real_escape_string($con, $_POST['country']);
        $postalCode = mysqli_real_escape_string($con, $_POST['postal_code']);
        $taxNumber = mysqli_real_escape_string($con, $_POST['tax_number']);
        $creditLimit = floatval($_POST['credit_limit']);
        $isActive = intval($_POST['is_active']);
        
        $query = "UPDATE tblcustomers SET 
                  CustomerCode = '$customerCode',
                  CustomerName = '$customerName',
                  CompanyName = '$companyName',
                  Email = '$email',
                  Phone = '$phone',
                  Address = '$address',
                  City = '$city',
                  State = '$state',
                  Country = '$country',
                  PostalCode = '$postalCode',
                  TaxNumber = '$taxNumber',
                  CreditLimit = '$creditLimit',
                  IsActive = '$isActive'
                  WHERE ID = '$customerId'";
        
        if (mysqli_query($con, $query)) {
            $message = '<div class="alert alert-success">Customer updated successfully!</div>';
        } else {
            $message = '<div class="alert alert-danger">Error: ' . mysqli_error($con) . '</div>';
        }
    }
}

// Get customers list
$customersQuery = "SELECT c.*, 
    (SELECT COUNT(*) FROM tblcustomer_accounts ca WHERE ca.CustomerID = c.ID) as TransactionCount,
    (SELECT SUM(BalanceAmount) FROM tblcustomer_accounts ca WHERE ca.CustomerID = c.ID AND ca.Status IN ('Pending', 'Partial')) as OutstandingAmount
    FROM tblcustomers c 
    ORDER BY c.CustomerName";
$customersResult = mysqli_query($con, $customersQuery);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Customer Management - Ihita</title>
    
    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">
    
    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
</head>

<body id="page-top">
    <!-- Page Wrapper -->
    <div id="wrapper">
        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column" style="margin-left: 0 !important;">
            <!-- Main Content -->
            <div id="content">
                <!-- Topbar -->
                <?php include_once('includes/customer-topbar.php'); ?>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                <div class="container-fluid">
                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4">
                        <h1 class="h3 mb-0 text-gray-800">Customer Management</h1>
                        <div>
                            <a href="index.php" class="d-none d-sm-inline-block btn btn-sm btn-info shadow-sm mr-2">
                                <i class="fas fa-tachometer-alt fa-sm text-white-50"></i> Dashboard
                            </a>
                            <a href="accounts.php" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm mr-2">
                                <i class="fas fa-file-invoice fa-sm text-white-50"></i> Accounts
                            </a>
                            <button class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm" data-toggle="modal" data-target="#addCustomerModal">
                                <i class="fas fa-plus fa-sm text-white-50"></i> Add New Customer
                            </button>
                        </div>
                    </div>

                    <!-- Quick Navigation Menu -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="card shadow">
                                <div class="card-header py-2">
                                    <h6 class="m-0 font-weight-bold text-primary">Customer Views</h6>
                                </div>
                                <div class="card-body py-2">
                                    <div class="row">
                                        <div class="col-lg-2 col-md-3 col-sm-4 mb-1">
                                            <a href="customers.php" class="btn btn-outline-primary btn-sm btn-block <?php echo (!isset($_GET['filter']) && !isset($_GET['action'])) ? 'active' : ''; ?>">
                                                <i class="fas fa-users"></i> All Customers
                                            </a>
                                        </div>
                                        <div class="col-lg-2 col-md-3 col-sm-4 mb-1">
                                            <a href="customers.php?filter=active" class="btn btn-outline-success btn-sm btn-block <?php echo (isset($_GET['filter']) && $_GET['filter'] == 'active') ? 'active' : ''; ?>">
                                                <i class="fas fa-user-check"></i> Active
                                            </a>
                                        </div>
                                        <div class="col-lg-2 col-md-3 col-sm-4 mb-1">
                                            <a href="customers.php?filter=inactive" class="btn btn-outline-secondary btn-sm btn-block <?php echo (isset($_GET['filter']) && $_GET['filter'] == 'inactive') ? 'active' : ''; ?>">
                                                <i class="fas fa-user-times"></i> Inactive
                                            </a>
                                        </div>
                                        <div class="col-lg-2 col-md-3 col-sm-4 mb-1">
                                            <a href="customers.php?filter=high_balance" class="btn btn-outline-warning btn-sm btn-block <?php echo (isset($_GET['filter']) && $_GET['filter'] == 'high_balance') ? 'active' : ''; ?>">
                                                <i class="fas fa-exclamation-triangle"></i> High Balance
                                            </a>
                                        </div>
                                        <div class="col-lg-2 col-md-3 col-sm-4 mb-1">
                                            <a href="customers.php?action=add" class="btn btn-outline-info btn-sm btn-block <?php echo (isset($_GET['action']) && $_GET['action'] == 'add') ? 'active' : ''; ?>">
                                                <i class="fas fa-user-plus"></i> Add New
                                            </a>
                                        </div>
                                        <div class="col-lg-2 col-md-3 col-sm-4 mb-1">
                                            <a href="customers.php?view=export" class="btn btn-outline-dark btn-sm btn-block">
                                                <i class="fas fa-download"></i> Export
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php echo $message; ?>

                    <!-- Customers Table -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">All Customers</h6>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th>Code</th>
                                            <th>Customer Name</th>
                                            <th>Company</th>
                                            <th>Contact</th>
                                            <th>Credit Limit</th>
                                            <th>Outstanding</th>
                                            <th>Transactions</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php while ($row = mysqli_fetch_assoc($customersResult)): ?>
                                            <tr>
                                                <td><?php echo safe_htmlspecialchars($row['CustomerCode']); ?></td>
                                                <td><?php echo safe_htmlspecialchars($row['CustomerName']); ?></td>
                                                <td><?php echo safe_htmlspecialchars($row['CompanyName']); ?></td>
                                                <td>
                                                    <?php echo safe_htmlspecialchars($row['Phone']); ?><br>
                                                    <small><?php echo safe_htmlspecialchars($row['Email']); ?></small>
                                                </td>
                                                <td>₹<?php echo number_format($row['CreditLimit'], 2); ?></td>
                                                <td>₹<?php echo number_format($row['OutstandingAmount'] ?? 0, 2); ?></td>
                                                <td><?php echo $row['TransactionCount']; ?></td>
                                                <td>
                                                    <span class="badge badge-<?php echo $row['IsActive'] ? 'success' : 'danger'; ?>">
                                                        <?php echo $row['IsActive'] ? 'Active' : 'Inactive'; ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <button class="btn btn-sm btn-primary edit-customer" 
                                                            data-customer='<?php echo json_encode($row); ?>'>
                                                        <i class="fas fa-edit"></i>
                                                    </button>
                                                    <a href="accounts.php?customer_id=<?php echo $row['ID']; ?>" 
                                                       class="btn btn-sm btn-info">
                                                        <i class="fas fa-file-invoice"></i>
                                                    </a>
                                                    <a href="ledger.php?customer_id=<?php echo $row['ID']; ?>" 
                                                       class="btn btn-sm btn-secondary">
                                                        <i class="fas fa-book"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php endwhile; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.container-fluid -->
            </div>
            <!-- End of Main Content -->

            <!-- Footer -->
            <?php include_once('includes/customer-footer.php'); ?>
            <!-- End of Footer -->
        </div>
        <!-- End of Content Wrapper -->
    </div>
    <!-- End of Page Wrapper -->

    <!-- Add Customer Modal -->
    <div class="modal fade" id="addCustomerModal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <form method="POST">
                    <input type="hidden" name="action" value="add_customer">
                    <div class="modal-header">
                        <h5 class="modal-title">Add New Customer</h5>
                        <button type="button" class="close" data-dismiss="modal">
                            <span>&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Customer Code *</label>
                                    <input type="text" name="customer_code" class="form-control" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Customer Name *</label>
                                    <input type="text" name="customer_name" class="form-control" required>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Company Name</label>
                                    <input type="text" name="company_name" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Email</label>
                                    <input type="email" name="email" class="form-control">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Phone</label>
                                    <input type="text" name="phone" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Tax Number</label>
                                    <input type="text" name="tax_number" class="form-control">
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label>Address</label>
                            <textarea name="address" class="form-control" rows="2"></textarea>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>City</label>
                                    <input type="text" name="city" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>State</label>
                                    <input type="text" name="state" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Country</label>
                                    <input type="text" name="country" class="form-control" value="India">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Postal Code</label>
                                    <input type="text" name="postal_code" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Credit Limit</label>
                                    <input type="number" name="credit_limit" class="form-control" step="0.01" value="0">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Add Customer</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Edit Customer Modal -->
    <div class="modal fade" id="editCustomerModal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <form method="POST">
                    <input type="hidden" name="action" value="update_customer">
                    <input type="hidden" name="customer_id" id="edit_customer_id">
                    <div class="modal-header">
                        <h5 class="modal-title">Edit Customer</h5>
                        <button type="button" class="close" data-dismiss="modal">
                            <span>&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Customer Code *</label>
                                    <input type="text" name="customer_code" id="edit_customer_code" class="form-control" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Customer Name *</label>
                                    <input type="text" name="customer_name" id="edit_customer_name" class="form-control" required>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Company Name</label>
                                    <input type="text" name="company_name" id="edit_company_name" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Email</label>
                                    <input type="email" name="email" id="edit_email" class="form-control">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Phone</label>
                                    <input type="text" name="phone" id="edit_phone" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Tax Number</label>
                                    <input type="text" name="tax_number" id="edit_tax_number" class="form-control">
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label>Address</label>
                            <textarea name="address" id="edit_address" class="form-control" rows="2"></textarea>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>City</label>
                                    <input type="text" name="city" id="edit_city" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>State</label>
                                    <input type="text" name="state" id="edit_state" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Country</label>
                                    <input type="text" name="country" id="edit_country" class="form-control">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Postal Code</label>
                                    <input type="text" name="postal_code" id="edit_postal_code" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Credit Limit</label>
                                    <input type="number" name="credit_limit" id="edit_credit_limit" class="form-control" step="0.01">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Status</label>
                                    <select name="is_active" id="edit_is_active" class="form-control">
                                        <option value="1">Active</option>
                                        <option value="0">Inactive</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Update Customer</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Page level plugins -->
    <script src="../vendor/datatables/jquery.dataTables.min.js"></script>
    <script src="../vendor/datatables/dataTables.bootstrap4.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>

    <!-- Page level custom scripts -->
    <script>
        $(document).ready(function() {
            $('#dataTable').DataTable();
            
            $('.edit-customer').click(function() {
                var customer = $(this).data('customer');
                
                $('#edit_customer_id').val(customer.ID);
                $('#edit_customer_code').val(customer.CustomerCode);
                $('#edit_customer_name').val(customer.CustomerName);
                $('#edit_company_name').val(customer.CompanyName);
                $('#edit_email').val(customer.Email);
                $('#edit_phone').val(customer.Phone);
                $('#edit_address').val(customer.Address);
                $('#edit_city').val(customer.City);
                $('#edit_state').val(customer.State);
                $('#edit_country').val(customer.Country);
                $('#edit_postal_code').val(customer.PostalCode);
                $('#edit_tax_number').val(customer.TaxNumber);
                $('#edit_credit_limit').val(customer.CreditLimit);
                $('#edit_is_active').val(customer.IsActive);
                
                $('#editCustomerModal').modal('show');
            });
        });
    </script>
</body>
</html>
