<?php
session_start();
include_once('../includes/config.php');

// Helper function to safely escape HTML content
function safe_htmlspecialchars($string) {
    return htmlspecialchars($string ?? '', ENT_QUOTES, 'UTF-8');
}

// Check if user is logged in
if (!isset($_SESSION['uid'])) {
    header('location:../login.php');
    exit();
}

$userId = $_SESSION['uid'];
$userType = $_SESSION['usertype'];

// Get the action type from URL parameter
$action = $_GET['action'] ?? 'ledger';
$page_title = '';
$redirect_page = '';

switch($action) {
    case 'ledger':
        $page_title = 'Select Customer for Ledger View';
        $redirect_page = 'ledger.php';
        break;
    case 'accounts':
        $page_title = 'Select Customer for Account View';
        $redirect_page = 'accounts.php';
        break;
    case 'statement':
        $page_title = 'Select Customer for Account Statement';
        $redirect_page = 'reports.php';
        break;
    default:
        $page_title = 'Select Customer';
        $redirect_page = 'accounts.php';
}

// Get all active customers
$customersQuery = "SELECT * FROM tblcustomers WHERE IsActive = 1 ORDER BY CustomerName";
$customersResult = mysqli_query($con, $customersQuery);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title><?php echo $page_title; ?> - Ihita</title>
    
    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">
    
    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="css/customer.css" rel="stylesheet">
</head>

<body id="page-top">
    <!-- Page Wrapper -->
    <div id="wrapper">
        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column" style="margin-left: 0 !important;">
            <!-- Main Content -->
            <div id="content">
                <!-- Topbar -->
                <?php include_once('includes/customer-topbar.php'); ?>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                <div class="container-fluid">
                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4">
                        <h1 class="h3 mb-0 text-gray-800"><?php echo $page_title; ?></h1>
                        <div>
                            <a href="index.php" class="d-none d-sm-inline-block btn btn-sm btn-info shadow-sm mr-2">
                                <i class="fas fa-tachometer-alt fa-sm text-white-50"></i> Dashboard
                            </a>
                            <a href="customers.php" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm">
                                <i class="fas fa-users fa-sm text-white-50"></i> All Customers
                            </a>
                        </div>
                    </div>

                    <!-- Customer Selection -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card shadow mb-4">
                                <div class="card-header py-3">
                                    <h6 class="m-0 font-weight-bold text-primary">
                                        <i class="fas fa-search"></i> Choose a Customer
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <!-- Search Box -->
                                    <div class="row mb-4">
                                        <div class="col-md-6">
                                            <div class="input-group">
                                                <input type="text" class="form-control" id="customerSearch" placeholder="Search customers by name, code, or company...">
                                                <div class="input-group-append">
                                                    <span class="input-group-text"><i class="fas fa-search"></i></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Customer Grid -->
                                    <div class="row" id="customerGrid">
                                        <?php if (mysqli_num_rows($customersResult) > 0): ?>
                                            <?php while ($customer = mysqli_fetch_assoc($customersResult)): ?>
                                                <div class="col-lg-3 col-md-4 col-sm-6 mb-3 customer-item" 
                                                     data-name="<?php echo strtolower($customer['CustomerName']); ?>"
                                                     data-code="<?php echo strtolower($customer['CustomerCode']); ?>"
                                                     data-company="<?php echo strtolower($customer['CompanyName'] ?? ''); ?>">
                                                    <div class="card customer-card h-100">
                                                        <div class="card-body text-center">
                                                            <div class="mb-3">
                                                                <i class="fas fa-user-circle fa-3x text-primary"></i>
                                                            </div>
                                                            <h6 class="card-title font-weight-bold"><?php echo safe_htmlspecialchars($customer['CustomerName']); ?></h6>
                                                            <p class="card-text text-muted small">
                                                                Code: <?php echo safe_htmlspecialchars($customer['CustomerCode']); ?><br>
                                                                <?php if (!empty($customer['CompanyName'])): ?>
                                                                    Company: <?php echo safe_htmlspecialchars($customer['CompanyName']); ?><br>
                                                                <?php endif; ?>
                                                                Balance: ₹<?php echo number_format($customer['CurrentBalance'], 2); ?>
                                                            </p>
                                                            <a href="<?php echo $redirect_page; ?>?customer_id=<?php echo $customer['ID']; ?><?php echo ($action == 'statement') ? '&type=statement' : ''; ?>" 
                                                               class="btn btn-primary btn-sm">
                                                                <i class="fas fa-arrow-right"></i> Select
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endwhile; ?>
                                        <?php else: ?>
                                            <div class="col-12">
                                                <div class="alert alert-info text-center">
                                                    <i class="fas fa-info-circle"></i> No active customers found. 
                                                    <a href="customers.php" class="alert-link">Add a customer first</a>.
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </div>

                                    <!-- No Results Message -->
                                    <div class="row" id="noResults" style="display: none;">
                                        <div class="col-12">
                                            <div class="alert alert-warning text-center">
                                                <i class="fas fa-search"></i> No customers found matching your search criteria.
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.container-fluid -->
            </div>
            <!-- End of Main Content -->

            <!-- Footer -->
            <?php include_once('includes/customer-footer.php'); ?>
            <!-- End of Footer -->
        </div>
        <!-- End of Content Wrapper -->
    </div>
    <!-- End of Page Wrapper -->

    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>

    <script>
    $(document).ready(function() {
        // Customer search functionality
        $('#customerSearch').on('keyup', function() {
            var searchTerm = $(this).val().toLowerCase();
            var hasResults = false;
            
            $('.customer-item').each(function() {
                var customerName = $(this).data('name');
                var customerCode = $(this).data('code');
                var customerCompany = $(this).data('company');
                
                if (customerName.includes(searchTerm) || 
                    customerCode.includes(searchTerm) || 
                    customerCompany.includes(searchTerm)) {
                    $(this).show();
                    hasResults = true;
                } else {
                    $(this).hide();
                }
            });
            
            if (hasResults) {
                $('#noResults').hide();
                $('#customerGrid').show();
            } else if (searchTerm.length > 0) {
                $('#customerGrid').hide();
                $('#noResults').show();
            } else {
                $('#customerGrid').show();
                $('#noResults').hide();
            }
        });
    });
    </script>
</body>
</html>
