<?php
header('Content-Type: application/json');
include_once('../../includes/config.php');

// Check if user is logged in
session_start();
if (!isset($_SESSION['uid'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit();
}

$customerId = $_GET['customer_id'] ?? '';

if (empty($customerId) || !is_numeric($customerId)) {
    echo json_encode(['success' => false, 'error' => 'Invalid customer ID']);
    exit();
}

$customerId = intval($customerId);

// Get customer details and current balance
$customerQuery = "SELECT 
    c.CustomerName,
    c.CreditLimit,
    c.CurrentBalance,
    COALESCE(SUM(CASE WHEN ca.Status IN ('Pending', 'Partial') THEN ca.BalanceAmount ELSE 0 END), 0) as OutstandingAmount
    FROM tblcustomers c
    LEFT JOIN tblcustomer_accounts ca ON c.ID = ca.CustomerID
    WHERE c.ID = $customerId
    GROUP BY c.ID";

$result = mysqli_query($con, $customerQuery);

if (mysqli_num_rows($result) > 0) {
    $customer = mysqli_fetch_assoc($result);
    
    echo json_encode([
        'success' => true,
        'customer_name' => $customer['CustomerName'],
        'credit_limit' => floatval($customer['CreditLimit']),
        'current_balance' => floatval($customer['CurrentBalance']),
        'outstanding_amount' => floatval($customer['OutstandingAmount']),
        'available_credit' => floatval($customer['CreditLimit']) - floatval($customer['OutstandingAmount'])
    ]);
} else {
    echo json_encode(['success' => false, 'error' => 'Customer not found']);
}
?>
