-- Table structure for table `tblbeneficiaries`

CREATE TABLE `tblbeneficiaries` (
  `ID` int(11) NOT NULL,
  `BeneficiaryName` varchar(255) NOT NULL,
  `BeneficiaryType` enum('Individual','Company','Organization','Government','Bank','Other') NOT NULL DEFAULT 'Individual',
  `ContactPerson` varchar(255) DEFAULT NULL,
  `PhoneNumber` varchar(20) DEFAULT NULL,
  `Email` varchar(255) DEFAULT NULL,
  `Address` text DEFAULT NULL,
  `BankName` varchar(255) DEFAULT NULL,
  `BankAccountNumber` varchar(50) DEFAULT NULL,
  `BankIFSC` varchar(20) DEFAULT NULL,
  `PAN` varchar(20) DEFAULT NULL,
  `GST` varchar(20) DEFAULT NULL,
  `TaxID` varchar(50) DEFAULT NULL,
  `Description` text DEFAULT NULL,
  `IsActive` tinyint(1) NOT NULL DEFAULT 1,
  `AddedBy` int(11) NOT NULL,
  `CreatedDate` timestamp NOT NULL DEFAULT current_timestamp(),
  `UpdatedDate` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Indexes for table `tblbeneficiaries`
--
ALTER TABLE `tblbeneficiaries`
  ADD PRIMARY KEY (`ID`),
  ADD KEY `idx_beneficiary_name` (`BeneficiaryName`),
  ADD KEY `idx_beneficiary_type` (`BeneficiaryType`),
  ADD KEY `idx_is_active` (`IsActive`),
  ADD KEY `fk_beneficiary_added_by` (`AddedBy`);

--
-- AUTO_INCREMENT for table `tblbeneficiaries`
--
ALTER TABLE `tblbeneficiaries`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT;

--
-- Constraints for table `tblbeneficiaries`
--
ALTER TABLE `tblbeneficiaries`
  ADD CONSTRAINT `fk_beneficiary_added_by` FOREIGN KEY (`AddedBy`) REFERENCES `tblusers` (`ID`) ON DELETE CASCADE;

-- Insert some sample data
INSERT INTO `tblbeneficiaries` (`BeneficiaryName`, `BeneficiaryType`, `ContactPerson`, `PhoneNumber`, `Email`, `Address`, `AddedBy`) VALUES
('ABC Construction Ltd', 'Company', 'John Doe', '9876543210', 'john@abc.com', '123 Business Street, Mumbai', 1),
('XYZ Suppliers', 'Company', 'Jane Smith', '9876543211', 'jane@xyz.com', '456 Market Road, Delhi', 1),
('Government Tax Office', 'Government', 'Tax Officer', '1234567890', 'tax@gov.in', 'Government Complex, Bangalore', 1),
('State Bank of India', 'Bank', 'Branch Manager', '9999999999', 'manager@sbi.co.in', 'Main Branch, Chennai', 1),
('Rajesh Kumar', 'Individual', 'Rajesh Kumar', '8888888888', 'rajesh@email.com', 'House No. 123, Pune', 1);
