<?php
session_start();
include_once('includes/config.php');
if (!isset($_SESSION['uid'])) {
    header('location:logout.php');
    exit();
}
$userId = $_SESSION['uid'];
$userType = $_SESSION['usertype'];
$msg = "";

// Only admin can manage beneficiaries
if ($userType != 'admin') {
    header('location:dashboard.php');
    exit();
}

// DELETE BENEFICIARY
if (isset($_GET['del_beneficiary'])) {
    $beneficiaryId = intval($_GET['del_beneficiary']);
    $res = mysqli_query($con, "UPDATE tblbeneficiaries SET IsActive=0 WHERE ID='$beneficiaryId'");
    if ($res) {
        $msg = "Beneficiary deactivated successfully!";
    } else {
        $msg = "Error deactivating beneficiary!";
    }
}

// ACTIVATE BENEFICIARY
if (isset($_GET['activate_beneficiary'])) {
    $beneficiaryId = intval($_GET['activate_beneficiary']);
    $res = mysqli_query($con, "UPDATE tblbeneficiaries SET IsActive=1 WHERE ID='$beneficiaryId'");
    if ($res) {
        $msg = "Beneficiary activated successfully!";
    } else {
        $msg = "Error activating beneficiary!";
    }
}

// EDIT/UPDATE BENEFICIARY
$editBeneficiary = null;
if (isset($_GET['edit_beneficiary'])) {
    $beneficiaryId = intval($_GET['edit_beneficiary']);
    $editRes = mysqli_query($con, "SELECT * FROM tblbeneficiaries WHERE ID='$beneficiaryId'");
    $editBeneficiary = mysqli_fetch_assoc($editRes);
}

if (isset($_POST['update_beneficiary'])) {
    $beneficiaryId = intval($_POST['beneficiaryid']);
    $beneficiaryName = mysqli_real_escape_string($con, $_POST['beneficiary_name']);
    $beneficiaryType = mysqli_real_escape_string($con, $_POST['beneficiary_type']);
    $contactPerson = mysqli_real_escape_string($con, $_POST['contact_person']);
    $phoneNumber = mysqli_real_escape_string($con, $_POST['phone_number']);
    $email = mysqli_real_escape_string($con, $_POST['email']);
    $address = mysqli_real_escape_string($con, $_POST['address']);
    $bankName = mysqli_real_escape_string($con, $_POST['bank_name']);
    $bankAccountNumber = mysqli_real_escape_string($con, $_POST['bank_account_number']);
    $bankIFSC = mysqli_real_escape_string($con, $_POST['bank_ifsc']);
    $pan = mysqli_real_escape_string($con, $_POST['pan']);
    $gst = mysqli_real_escape_string($con, $_POST['gst']);
    $taxID = mysqli_real_escape_string($con, $_POST['tax_id']);
    $description = mysqli_real_escape_string($con, $_POST['description']);
    
    $res = mysqli_query($con, "UPDATE tblbeneficiaries SET 
        BeneficiaryName='$beneficiaryName', 
        BeneficiaryType='$beneficiaryType', 
        ContactPerson='$contactPerson', 
        PhoneNumber='$phoneNumber', 
        Email='$email', 
        Address='$address', 
        BankName='$bankName', 
        BankAccountNumber='$bankAccountNumber', 
        BankIFSC='$bankIFSC', 
        PAN='$pan', 
        GST='$gst', 
        TaxID='$taxID', 
        Description='$description' 
        WHERE ID='$beneficiaryId'");
    
    if ($res) {
        $msg = "Beneficiary updated successfully!";
    } else {
        $msg = "Error updating beneficiary!";
    }
    $editBeneficiary = null;
}

// CREATE BENEFICIARY
if (isset($_POST['add_beneficiary'])) {
    $beneficiaryName = mysqli_real_escape_string($con, $_POST['beneficiary_name']);
    $beneficiaryType = mysqli_real_escape_string($con, $_POST['beneficiary_type']);
    $contactPerson = mysqli_real_escape_string($con, $_POST['contact_person']);
    $phoneNumber = mysqli_real_escape_string($con, $_POST['phone_number']);
    $email = mysqli_real_escape_string($con, $_POST['email']);
    $address = mysqli_real_escape_string($con, $_POST['address']);
    $bankName = mysqli_real_escape_string($con, $_POST['bank_name']);
    $bankAccountNumber = mysqli_real_escape_string($con, $_POST['bank_account_number']);
    $bankIFSC = mysqli_real_escape_string($con, $_POST['bank_ifsc']);
    $pan = mysqli_real_escape_string($con, $_POST['pan']);
    $gst = mysqli_real_escape_string($con, $_POST['gst']);
    $taxID = mysqli_real_escape_string($con, $_POST['tax_id']);
    $description = mysqli_real_escape_string($con, $_POST['description']);
    
    $res = mysqli_query($con, "INSERT INTO tblbeneficiaries 
        (BeneficiaryName, BeneficiaryType, ContactPerson, PhoneNumber, Email, Address, BankName, BankAccountNumber, BankIFSC, PAN, GST, TaxID, Description, AddedBy) 
        VALUES ('$beneficiaryName', '$beneficiaryType', '$contactPerson', '$phoneNumber', '$email', '$address', '$bankName', '$bankAccountNumber', '$bankIFSC', '$pan', '$gst', '$taxID', '$description', '$userId')");
    
    if ($res) {
        $msg = "Beneficiary added successfully!";
    } else {
        $msg = "Error adding beneficiary!";
    }
}

// Fetch beneficiaries
$beneficiaries = mysqli_query($con, "SELECT b.*, u.FullName as AddedByName 
    FROM tblbeneficiaries b 
    LEFT JOIN tblusers u ON b.AddedBy=u.ID 
    ORDER BY b.IsActive DESC, b.BeneficiaryName ASC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Ihita Industries | Beneficiary Management</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="css/sb-admin-2.min.css" rel="stylesheet">
    <style>
        .card { border-radius: 1rem; }
        .card-header { border-radius: 1rem 1rem 0 0; }
        .form-control, .btn { font-size: 1.1rem; border-radius: 2rem; }
        .btn-block { padding: 0.75rem 0; }
        .table th, .table td { vertical-align: middle !important; }
        .status-active { color: #28a745; font-weight: bold; }
        .status-inactive { color: #dc3545; font-weight: bold; }
        .beneficiary-card {
            border-left: 4px solid #007bff;
            margin-bottom: 1rem;
        }
        .beneficiary-card.inactive {
            border-left-color: #dc3545;
            opacity: 0.7;
        }
        @media (max-width: 767.98px) {
            .container, .container-fluid { padding-left: 0.5rem; padding-right: 0.5rem; }
            .card { margin-bottom: 1.2rem; }
            .table-responsive { font-size: 0.95rem; }
            .btn, .btn-block { font-size: 1rem; padding: 0.6rem 0.75rem; }
            .card-header h4, .card-header h5 { font-size: 1.1rem; }
        }
    </style>
</head>
<body id="page-top">
    <div id="wrapper">
        <?php include_once('includes/sidebar.php');?>
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include_once('includes/topbar.php');?>
                <div class="container-fluid mt-3 mb-3">
                    <h1 class="h3 mb-4 text-gray-800">Beneficiary Management</h1>
                    <?php if($msg) { ?>
                        <div class="alert alert-info text-center"><?php echo $msg; ?></div>
                    <?php } ?>

                    <?php if(!$editBeneficiary) { ?>
                    <!-- Add Beneficiary Form -->
                    <div class="card shadow mb-4">
                        <div class="card-header bg-primary text-white text-center">
                            <h4 class="mb-0">Add New Beneficiary</h4>
                        </div>
                        <div class="card-body">
                            <form method="post" autocomplete="off">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Beneficiary Name *</label>
                                            <input type="text" name="beneficiary_name" class="form-control" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Beneficiary Type *</label>
                                            <select name="beneficiary_type" class="form-control" required>
                                                <option value="">Select Type</option>
                                                <option value="Individual">Individual</option>
                                                <option value="Company">Company</option>
                                                <option value="Organization">Organization</option>
                                                <option value="Government">Government</option>
                                                <option value="Bank">Bank</option>
                                                <option value="Other">Self</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Contact Person</label>
                                            <input type="text" name="contact_person" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Phone Number</label>
                                            <input type="text" name="phone_number" class="form-control">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Email</label>
                                            <input type="email" name="email" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Address</label>
                                            <textarea name="address" class="form-control" rows="2"></textarea>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Banking Details -->
                                <h6 class="text-primary mt-3 mb-2">Banking Details (Optional)</h6>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Bank Name</label>
                                            <input type="text" name="bank_name" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Account Number</label>
                                            <input type="text" name="bank_account_number" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>IFSC Code</label>
                                            <input type="text" name="bank_ifsc" class="form-control">
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Tax Details -->
                                <h6 class="text-primary mt-3 mb-2">Tax Details (Optional)</h6>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>PAN</label>
                                            <input type="text" name="pan" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>GST Number</label>
                                            <input type="text" name="gst" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Tax ID</label>
                                            <input type="text" name="tax_id" class="form-control">
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label>Description</label>
                                    <textarea name="description" class="form-control" rows="2"></textarea>
                                </div>
                                <button type="submit" name="add_beneficiary" class="btn btn-primary btn-block">Add Beneficiary</button>
                            </form>
                        </div>
                    </div>
                    <?php } ?>

                    <?php if($editBeneficiary) { ?>
                    <!-- Edit Beneficiary Form -->
                    <div class="card shadow mb-4">
                        <div class="card-header bg-warning text-white text-center">
                            <h4 class="mb-0">Edit Beneficiary</h4>
                        </div>
                        <div class="card-body">
                            <form method="post" autocomplete="off">
                                <input type="hidden" name="beneficiaryid" value="<?php echo $editBeneficiary['ID']; ?>">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Beneficiary Name *</label>
                                            <input type="text" name="beneficiary_name" class="form-control" required value="<?php echo htmlspecialchars($editBeneficiary['BeneficiaryName']); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Beneficiary Type *</label>
                                            <select name="beneficiary_type" class="form-control" required>
                                                <option value="">Select Type</option>
                                                <option value="Individual" <?php if($editBeneficiary['BeneficiaryType']=='Individual') echo 'selected'; ?>>Individual</option>
                                                <option value="Company" <?php if($editBeneficiary['BeneficiaryType']=='Company') echo 'selected'; ?>>Company</option>
                                                <option value="Organization" <?php if($editBeneficiary['BeneficiaryType']=='Organization') echo 'selected'; ?>>Organization</option>
                                                <option value="Government" <?php if($editBeneficiary['BeneficiaryType']=='Government') echo 'selected'; ?>>Government</option>
                                                <option value="Bank" <?php if($editBeneficiary['BeneficiaryType']=='Bank') echo 'selected'; ?>>Bank</option>
                                                <option value="Other" <?php if($editBeneficiary['BeneficiaryType']=='Other') echo 'selected'; ?>>Other</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Contact Person</label>
                                            <input type="text" name="contact_person" class="form-control" value="<?php echo htmlspecialchars($editBeneficiary['ContactPerson']); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Phone Number</label>
                                            <input type="text" name="phone_number" class="form-control" value="<?php echo htmlspecialchars($editBeneficiary['PhoneNumber']); ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Email</label>
                                            <input type="email" name="email" class="form-control" value="<?php echo htmlspecialchars($editBeneficiary['Email']); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Address</label>
                                            <textarea name="address" class="form-control" rows="2"><?php echo htmlspecialchars($editBeneficiary['Address']); ?></textarea>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Banking Details -->
                                <h6 class="text-primary mt-3 mb-2">Banking Details (Optional)</h6>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Bank Name</label>
                                            <input type="text" name="bank_name" class="form-control" value="<?php echo htmlspecialchars($editBeneficiary['BankName']); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Account Number</label>
                                            <input type="text" name="bank_account_number" class="form-control" value="<?php echo htmlspecialchars($editBeneficiary['BankAccountNumber']); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>IFSC Code</label>
                                            <input type="text" name="bank_ifsc" class="form-control" value="<?php echo htmlspecialchars($editBeneficiary['BankIFSC']); ?>">
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Tax Details -->
                                <h6 class="text-primary mt-3 mb-2">Tax Details (Optional)</h6>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>PAN</label>
                                            <input type="text" name="pan" class="form-control" value="<?php echo htmlspecialchars($editBeneficiary['PAN']); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>GST Number</label>
                                            <input type="text" name="gst" class="form-control" value="<?php echo htmlspecialchars($editBeneficiary['GST']); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Tax ID</label>
                                            <input type="text" name="tax_id" class="form-control" value="<?php echo htmlspecialchars($editBeneficiary['TaxID']); ?>">
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label>Description</label>
                                    <textarea name="description" class="form-control" rows="2"><?php echo htmlspecialchars($editBeneficiary['Description']); ?></textarea>
                                </div>
                                <button type="submit" name="update_beneficiary" class="btn btn-warning btn-block">Update Beneficiary</button>
                                <a href="beneficiary-management.php" class="btn btn-secondary btn-block mt-2">Cancel Edit</a>
                            </form>
                        </div>
                    </div>
                    <?php } ?>

                    <!-- Beneficiaries List -->
                    <div class="card shadow mb-4">
                        <div class="card-header bg-info text-white text-center">
                            <h5 class="mb-0">All Beneficiaries</h5>
                        </div>
                        <div class="card-body p-2">
                            <div class="table-responsive">
                            <table class="table table-bordered table-sm mb-0">
                                <thead class="thead-light">
                                    <tr>
                                        <th>#</th>
                                        <th>Name</th>
                                        <th>Type</th>
                                        <th>Contact Person</th>
                                        <th>Phone</th>
                                        <th>Email</th>
                                        <th>Bank Details</th>
                                        <th>Tax Details</th>
                                        <th>Status</th>
                                        <th>Added By</th>
                                        <th>Created</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php $i=1; while($row = mysqli_fetch_assoc($beneficiaries)) { ?>
                                    <tr class="<?php echo ($row['IsActive'] == 0) ? 'table-secondary' : ''; ?>">
                                        <td><?php echo $i++; ?></td>
                                        <td>
                                            <strong><?php echo htmlspecialchars($row['BeneficiaryName']); ?></strong>
                                            <?php if($row['Address']) { ?><br><small class="text-muted"><?php echo htmlspecialchars($row['Address']); ?></small><?php } ?>
                                        </td>
                                        <td><span class="badge badge-primary"><?php echo htmlspecialchars($row['BeneficiaryType']); ?></span></td>
                                        <td><?php echo htmlspecialchars($row['ContactPerson'] ?: '-'); ?></td>
                                        <td><?php echo htmlspecialchars($row['PhoneNumber'] ?: '-'); ?></td>
                                        <td><?php echo htmlspecialchars($row['Email'] ?: '-'); ?></td>
                                        <td>
                                            <?php if($row['BankName'] || $row['BankAccountNumber']) { ?>
                                                <small>
                                                    <?php if($row['BankName']) { ?><strong><?php echo htmlspecialchars($row['BankName']); ?></strong><br><?php } ?>
                                                    <?php if($row['BankAccountNumber']) { ?>A/C: <?php echo htmlspecialchars($row['BankAccountNumber']); ?><br><?php } ?>
                                                    <?php if($row['BankIFSC']) { ?>IFSC: <?php echo htmlspecialchars($row['BankIFSC']); ?><?php } ?>
                                                </small>
                                            <?php } else { echo '-'; } ?>
                                        </td>
                                        <td>
                                            <?php if($row['PAN'] || $row['GST'] || $row['TaxID']) { ?>
                                                <small>
                                                    <?php if($row['PAN']) { ?>PAN: <?php echo htmlspecialchars($row['PAN']); ?><br><?php } ?>
                                                    <?php if($row['GST']) { ?>GST: <?php echo htmlspecialchars($row['GST']); ?><br><?php } ?>
                                                    <?php if($row['TaxID']) { ?>Tax ID: <?php echo htmlspecialchars($row['TaxID']); ?><?php } ?>
                                                </small>
                                            <?php } else { echo '-'; } ?>
                                        </td>
                                        <td>
                                            <?php if($row['IsActive']) { ?>
                                                <span class="badge badge-success">Active</span>
                                            <?php } else { ?>
                                                <span class="badge badge-danger">Inactive</span>
                                            <?php } ?>
                                        </td>
                                        <td><?php echo htmlspecialchars($row['AddedByName']); ?></td>
                                        <td><?php echo date('d-m-Y H:i', strtotime($row['CreatedDate'])); ?></td>
                                        <td>
                                            <div class="d-flex flex-wrap gap-1">
                                                <a href="beneficiary-management.php?edit_beneficiary=<?php echo $row['ID']; ?>" class="btn btn-sm btn-warning mb-1">Edit</a>
                                                <?php if($row['IsActive']) { ?>
                                                    <a href="beneficiary-management.php?del_beneficiary=<?php echo $row['ID']; ?>" class="btn btn-sm btn-danger mb-1" onclick="return confirm('Deactivate this beneficiary?');">Deactivate</a>
                                                <?php } else { ?>
                                                    <a href="beneficiary-management.php?activate_beneficiary=<?php echo $row['ID']; ?>" class="btn btn-sm btn-success mb-1" onclick="return confirm('Activate this beneficiary?');">Activate</a>
                                                <?php } ?>
                                            </div>
                                        </td>
                                    </tr>
                                <?php } ?>
                                </tbody>
                            </table>
                            </div>
                        </div>
                    </div>

                    <a href="dashboard.php" class="btn btn-link btn-block mt-3">Back to Dashboard</a>
                </div>
            </div>
            <?php include_once('includes/footer.php');?>
        </div>
    </div>
    <?php include_once('includes/footer2.php');?>
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="js/sb-admin-2.min.js"></script>
</body>
</html>
