<?php
include_once("includes/db_helpers.php");
session_start();
include_once('includes/config.php');
if (!isset($_SESSION['uid'])) {
    header('location:logout.php');
    exit();
}

$userId = $_SESSION['uid'];
$userType = $_SESSION['usertype'];

// Only admin can access banking dashboard
if ($userType != 'admin') {
    header('location:dashboard.php');
    exit();
}

// Fetch banking summary data
$totalBankAccounts = mysqli_num_rows(mysqli_query($con, "SELECT ID FROM tblbankdetails WHERE IsActive=1"));
$totalBalance = safe_fetch_value($con, "SELECT IFNULL(SUM(CurrentBalance),0) as total FROM tblbankdetails WHERE IsActive=1");
$totalCredits = safe_fetch_value($con, "SELECT IFNULL(SUM(TransactionAmount),0) as total FROM tblaccounttransactions WHERE TransactionType='Credit'");
$totalDebits = safe_fetch_value($con, "SELECT IFNULL(SUM(TransactionAmount),0) as total FROM tblaccounttransactions WHERE TransactionType='Debit'");

// Recent transactions (last 5)
$recentTransactions = mysqli_query($con, "SELECT t.*, b.BankName, b.AccountNumber, u.FullName 
    FROM tblaccounttransactions t 
    LEFT JOIN tblbankdetails b ON t.BankAccountID=b.ID 
    LEFT JOIN tblusers u ON t.AddedBy=u.ID 
    ORDER BY t.CreatedDate DESC LIMIT 5");

// Bank account balances
$bankBalances = mysqli_query($con, "SELECT * FROM tblbankdetails WHERE IsActive=1 ORDER BY CurrentBalance DESC");

// Monthly transaction data for charts (last 6 months)
$creditsMonthly = [];
$debitsMonthly = [];
$months = [];
for ($i = 5; $i >= 0; $i--) {
    $month = date('Y-m', strtotime("-$i months"));
    $creditQuery = "SELECT IFNULL(SUM(TransactionAmount),0) as total FROM tblaccounttransactions WHERE DATE_FORMAT(TransactionDate, '%Y-%m')='$month' AND TransactionType='Credit'";
    $debitQuery = "SELECT IFNULL(SUM(TransactionAmount),0) as total FROM tblaccounttransactions WHERE DATE_FORMAT(TransactionDate, '%Y-%m')='$month' AND TransactionType='Debit'";
    
    $credit = safe_fetch_value($con, $creditQuery);
    $debit = safe_fetch_value($con, $debitQuery);
    $creditsMonthly[] = (float)$credit;
    $debitsMonthly[] = (float)$debit;
    $months[] = date('M Y', strtotime("-$i months"));
}

// Calculate today's transactions
$today = date('Y-m-d');
$todayCredits = safe_fetch_value($con, "SELECT IFNULL(SUM(TransactionAmount),0) as total FROM tblaccounttransactions WHERE DATE(TransactionDate)='$today' AND TransactionType='Credit'");
$todayDebits = safe_fetch_value($con, "SELECT IFNULL(SUM(TransactionAmount),0) as total FROM tblaccounttransactions WHERE DATE(TransactionDate)='$today' AND TransactionType='Debit'");
$todayNet = $todayCredits - $todayDebits;

// Calculate this month's transactions
$thisMonth = date('Y-m');
$monthCredits = safe_fetch_value($con, "SELECT IFNULL(SUM(TransactionAmount),0) as total FROM tblaccounttransactions WHERE DATE_FORMAT(TransactionDate, '%Y-%m')='$thisMonth' AND TransactionType='Credit'");
$monthDebits = safe_fetch_value($con, "SELECT IFNULL(SUM(TransactionAmount),0) as total FROM tblaccounttransactions WHERE DATE_FORMAT(TransactionDate, '%Y-%m')='$thisMonth' AND TransactionType='Debit'");
$monthNet = $monthCredits - $monthDebits;

// Helper function for Indian number formatting
function formatINR($number) {
    $number = (float)$number;
    $negative = $number < 0;
    $number = abs($number);
    $decimal = '';
    if (strpos($number, '.') !== false) {
        $parts = explode('.', $number);
        $number = $parts[0];
        $decimal = isset($parts[1]) && $parts[1] ? '.' . substr($parts[1] . '00', 0, 2) : '';
    }
    $len = strlen($number);
    if ($len > 3) {
        $last3 = substr($number, -3);
        $restUnits = substr($number, 0, $len - 3);
        $restUnits = preg_replace("/\B(?=(\d{2})+(?!\d))/", ",", $restUnits);
        $formatted = $restUnits . "," . $last3;
    } else {
        $formatted = $number;
    }
    return ($negative ? '-' : '') . $formatted . $decimal;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Ihita Industries | Banking Dashboard</title>
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">
    <link href="css/sb-admin-2.min.css" rel="stylesheet">
    <style>
        /* Banking Dashboard Specific Styles */
        .banking-container {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            min-height: 100vh;
            padding: 20px 0;
        }
        
        .card { 
            border-radius: 20px; 
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            border: none;
            transition: all 0.3s ease;
            overflow: hidden;
        }
        
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 40px rgba(0,0,0,0.15);
        }
        
        .banking-card {
            background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
            position: relative;
            overflow: hidden;
            color: #2c3e50;
        }
        
        .banking-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
        }
        
        .banking-card .card-body { 
            padding: 25px 20px; 
            position: relative;
            z-index: 2;
        }
        
        .banking-icon { 
            font-size: 3rem; 
            opacity: 0.1; 
            position: absolute; 
            right: 20px; 
            top: 20px; 
            z-index: 1;
        }
        
        .banking-value {
            font-size: 2.2rem;
            font-weight: 800;
            margin: 10px 0;
            color: #2c3e50;
        }
        
        .banking-label {
            font-size: 0.85rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            color: #6c757d;
            margin-bottom: 5px;
        }
        
        .dashboard-title {
            color: #2c3e50;
            font-weight: 800;
            font-size: 2.5rem;
            margin-bottom: 30px;
        }
        
        /* Color schemes for different banking card types */
        .total-balance-card::before {
            background: linear-gradient(90deg, #4e73df 0%, #224abe 100%);
        }
        
        .total-credits-card::before {
            background: linear-gradient(90deg, #28a745 0%, #20c997 100%);
        }
        
        .total-debits-card::before {
            background: linear-gradient(90deg, #dc3545 0%, #fd7e14 100%);
        }
        
        .bank-accounts-card::before {
            background: linear-gradient(90deg, #6f42c1 0%, #e83e8c 100%);
        }
        
        .today-net-card::before {
            background: linear-gradient(90deg, #17a2b8 0%, #138496 100%);
        }
        
        .month-net-card::before {
            background: linear-gradient(90deg, #fd7e14 0%, #e55a4e 100%);
        }
        
        .bank-balance-card {
            background: white;
            border-radius: 15px;
            padding: 20px;
            margin-bottom: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.08);
            transition: all 0.3s ease;
            border-left: 4px solid #007bff;
        }
        
        .bank-balance-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 25px rgba(0,0,0,0.12);
        }
        
        .bank-name {
            font-size: 1.1rem;
            font-weight: 700;
            color: #2c3e50;
            margin-bottom: 5px;
        }
        
        .account-number {
            font-size: 0.9rem;
            color: #6c757d;
            margin-bottom: 10px;
        }
        
        .bank-balance {
            font-size: 1.8rem;
            font-weight: 800;
            margin-bottom: 5px;
        }
        
        .balance-positive { color: #28a745; }
        .balance-negative { color: #dc3545; }
        .balance-zero { color: #6c757d; }
        
        .table-card .card-header {
            color: white;
            font-weight: 600;
            text-align: center;
            border-radius: 20px 20px 0 0;
        }
        
        .table-card .card-body {
            padding: 0;
        }
        
        .table {
            margin: 0;
            border-radius: 0 0 20px 20px;
            overflow: hidden;
        }
        
        .table th {
            background: #f8f9fa;
            border: none;
            font-weight: 600;
            color: #495057;
            padding: 15px 10px;
            font-size: 0.9rem;
        }
        
        .table td {
            border: none;
            padding: 12px 10px;
            vertical-align: middle;
            border-bottom: 1px solid #f1f3f4;
        }
        
        .table tbody tr:hover {
            background: #f8f9fa;
            transform: scale(1.01);
            transition: all 0.2s ease;
        }
        
        .transaction-credit { color: #28a745; font-weight: bold; }
        .transaction-debit { color: #dc3545; font-weight: bold; }
        
        .badge-amount {
            color: white;
            padding: 5px 10px;
            border-radius: 15px;
            font-weight: 600;
        }
        
        .badge-mode {
            background: linear-gradient(135deg, #17a2b8 0%, #138496 100%);
            color: white;
            padding: 3px 8px;
            border-radius: 10px;
            font-size: 0.8rem;
        }
        
        .no-data {
            text-align: center;
            padding: 40px 20px;
            color: #6c757d;
            font-style: italic;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .content-grid {
            display: grid;
            grid-template-columns: 2fr 1fr;
            gap: 25px;
            margin-bottom: 30px;
        }
        
        /* Table card headers with specific colors */
        .transactions-table-header {
            background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        }
        
        /* Mobile Responsive Design */
        @media (max-width: 768px) {
            .banking-container {
                padding: 10px 0;
            }
            
            .dashboard-title {
                font-size: 1.8rem;
                text-align: center;
                margin-bottom: 20px;
            }
            
            .stats-grid {
                grid-template-columns: 1fr;
                gap: 15px;
                margin-bottom: 20px;
            }
            
            .content-grid {
                grid-template-columns: 1fr;
                gap: 20px;
            }
            
            .banking-value {
                font-size: 1.8rem;
            }
            
            .banking-icon {
                font-size: 2.5rem;
                right: 15px;
                top: 15px;
            }
            
            .banking-card .card-body {
                padding: 20px 15px;
            }
        }
        
        /* Animation Effects */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .card {
            animation: fadeInUp 0.6s ease forwards;
        }
        
        .card:nth-child(1) { animation-delay: 0.1s; }
        .card:nth-child(2) { animation-delay: 0.2s; }
        .card:nth-child(3) { animation-delay: 0.3s; }
        .card:nth-child(4) { animation-delay: 0.4s; }
    </style>
</head>

<body id="page-top">
    <div id="wrapper">
        <?php include_once('includes/sidebar.php');?>
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include_once('includes/topbar.php');?>
                <div class="container-fluid banking-container">
                    <!-- Page Heading -->
                    <div class="text-center mb-4">
                        <h1 class="dashboard-title">
                            <i class="fas fa-university text-primary"></i> Banking Dashboard
                        </h1>
                        <p class="text-muted">Complete overview of your banking operations and account management.</p>
                    </div>
                    
                    <!-- Banking Summary Cards -->
                    <div class="stats-grid">
                        <div class="card banking-card total-balance-card">
                            <div class="card-body">
                                <div class="banking-label">Total Bank Balance</div>
                                <div class="banking-value <?php echo $totalBalance >= 0 ? 'text-primary' : 'text-danger'; ?>">
                                    Rs.<?php echo formatINR($totalBalance); ?>
                                </div>
                                <small class="<?php echo $totalBalance >= 0 ? 'text-primary' : 'text-danger'; ?>">
                                    <i class="fas fa-<?php echo $totalBalance >= 0 ? 'arrow-up' : 'arrow-down'; ?>"></i> 
                                    Current total balance
                                </small>
                                <i class="fas fa-university banking-icon"></i>
                            </div>
                        </div>
                        
                        <div class="card banking-card bank-accounts-card">
                            <div class="card-body">
                                <div class="banking-label">Active Bank Accounts</div>
                                <div class="banking-value"><?php echo $totalBankAccounts; ?></div>
                                <small class="text-muted">
                                    <i class="fas fa-check-circle"></i> 
                                    Operational accounts
                                </small>
                                <i class="fas fa-building banking-icon"></i>
                            </div>
                        </div>
                        
                        <div class="card banking-card total-credits-card">
                            <div class="card-body">
                                <div class="banking-label">Total Credits (All Time)</div>
                                <div class="banking-value text-success">Rs.<?php echo formatINR($totalCredits); ?></div>
                                <small class="text-success">
                                    <i class="fas fa-plus-circle"></i> 
                                    Money received
                                </small>
                                <i class="fas fa-arrow-down banking-icon"></i>
                            </div>
                        </div>
                        
                        <div class="card banking-card total-debits-card">
                            <div class="card-body">
                                <div class="banking-label">Total Debits (All Time)</div>
                                <div class="banking-value text-danger">Rs.<?php echo formatINR($totalDebits); ?></div>
                                <small class="text-danger">
                                    <i class="fas fa-minus-circle"></i> 
                                    Money spent
                                </small>
                                <i class="fas fa-arrow-up banking-icon"></i>
                            </div>
                        </div>
                        
                        <div class="card banking-card today-net-card">
                            <div class="card-body">
                                <div class="banking-label">Today's Net Movement</div>
                                <div class="banking-value <?php echo $todayNet >= 0 ? 'text-info' : 'text-warning'; ?>">
                                    Rs.<?php echo formatINR($todayNet); ?>
                                </div>
                                <small class="<?php echo $todayNet >= 0 ? 'text-info' : 'text-warning'; ?>">
                                    <i class="fas fa-calendar-day"></i> 
                                    Credits: Rs.<?php echo formatINR($todayCredits); ?> | Debits: Rs.<?php echo formatINR($todayDebits); ?>
                                </small>
                                <i class="fas fa-exchange-alt banking-icon"></i>
                            </div>
                        </div>
                        
                        <div class="card banking-card month-net-card">
                            <div class="card-body">
                                <div class="banking-label">This Month's Net Movement</div>
                                <div class="banking-value <?php echo $monthNet >= 0 ? 'text-warning' : 'text-danger'; ?>">
                                    Rs.<?php echo formatINR($monthNet); ?>
                                </div>
                                <small class="<?php echo $monthNet >= 0 ? 'text-warning' : 'text-danger'; ?>">
                                    <i class="fas fa-calendar-alt"></i> 
                                    Credits: Rs.<?php echo formatINR($monthCredits); ?> | Debits: Rs.<?php echo formatINR($monthDebits); ?>
                                </small>
                                <i class="fas fa-chart-line banking-icon"></i>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Main Content Grid -->
                    <div class="content-grid">
                        <!-- Recent Transactions -->
                        <div class="card table-card">
                            <div class="card-header transactions-table-header">
                                <h6 class="mb-0">
                                    <i class="fas fa-exchange-alt mr-2"></i>
                                    Recent Bank Transactions
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>Date</th>
                                                <th>Bank</th>
                                                <th>Type</th>
                                                <th>Title</th>
                                                <th>Amount</th>
                                                <th>Reference</th>
                                                <th>Added By</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php 
                                            $hasData = false;
                                            while($t = mysqli_fetch_assoc($recentTransactions)) { 
                                                $hasData = true;
                                            ?>
                                            <tr>
                                                <td>
                                                    <small><?php echo date('d-M-Y', strtotime($t['TransactionDate'])); ?></small>
                                                </td>
                                                <td>
                                                    <strong><?php echo htmlspecialchars($t['BankName']); ?></strong><br>
                                                    <small class="text-muted"><?php echo htmlspecialchars($t['AccountNumber']); ?></small>
                                                </td>
                                                <td>
                                                    <?php if($t['TransactionType'] == 'Credit') { ?>
                                                        <span class="badge badge-success">Credit</span>
                                                    <?php } else { ?>
                                                        <span class="badge badge-danger">Debit</span>
                                                    <?php } ?>
                                                </td>
                                                <td>
                                                    <strong><?php echo htmlspecialchars($t['TransactionTitle']); ?></strong>
                                                </td>
                                                <td>
                                                    <span class="badge-amount <?php echo $t['TransactionType'] == 'Credit' ? 'text-success' : 'text-danger'; ?>">
                                                        <?php echo ($t['TransactionType'] == 'Credit') ? '+' : '-'; ?>Rs.<?php echo formatINR($t['TransactionAmount']); ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <small><?php echo htmlspecialchars($t['ReferenceNumber'] ?: '-'); ?></small>
                                                </td>
                                                <td>
                                                    <small class="text-muted"><?php echo htmlspecialchars($t['FullName']); ?></small>
                                                </td>
                                            </tr>
                                            <?php } ?>
                                            <?php if(!$hasData) { ?>
                                            <tr>
                                                <td colspan="7" class="no-data">
                                                    <i class="fas fa-inbox fa-2x mb-2 d-block"></i>
                                                    No recent transactions found
                                                </td>
                                            </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Bank Account Balances -->
                        <div>
                            <h5 class="mb-3 text-center">
                                <i class="fas fa-piggy-bank text-primary"></i> Bank Account Balances
                            </h5>
                            <?php 
                            $hasAccounts = false;
                            while($b = mysqli_fetch_assoc($bankBalances)) { 
                                $hasAccounts = true;
                                $balanceClass = $b['CurrentBalance'] > 0 ? 'balance-positive' : ($b['CurrentBalance'] < 0 ? 'balance-negative' : 'balance-zero');
                            ?>
                            <div class="bank-balance-card">
                                <div class="bank-name"><?php echo htmlspecialchars($b['BankName']); ?></div>
                                <div class="account-number"><?php echo htmlspecialchars($b['AccountNumber']); ?></div>
                                <div class="bank-balance <?php echo $balanceClass; ?>">
                                    Rs.<?php echo formatINR($b['CurrentBalance']); ?>
                                </div>
                                <small class="text-muted">
                                    <i class="fas fa-clock"></i> 
                                    Updated: <?php echo date('d-M-Y H:i', strtotime($b['UpdatedDate'])); ?>
                                </small>
                            </div>
                            <?php } ?>
                            <?php if(!$hasAccounts) { ?>
                            <div class="bank-balance-card text-center">
                                <i class="fas fa-plus-circle fa-3x text-muted mb-3"></i>
                                <p class="text-muted">No bank accounts found</p>
                                <a href="bank-management.php" class="btn btn-primary">Add Bank Account</a>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                    
                    <!-- Quick Actions -->
                    <div class="row mt-4">
                        <div class="col-md-3 mb-2">
                            <a href="account-transactions.php" class="btn btn-primary btn-block">
                                <i class="fas fa-plus-circle"></i> Add Transaction
                            </a>
                        </div>
                        <div class="col-md-3 mb-2">
                            <a href="bank-management.php" class="btn btn-success btn-block">
                                <i class="fas fa-building"></i> Manage Banks
                            </a>
                        </div>
                        <div class="col-md-3 mb-2">
                            <a href="account-transaction-report.php" class="btn btn-info btn-block">
                                <i class="fas fa-chart-bar"></i> View Reports
                            </a>
                        </div>
                        <div class="col-md-3 mb-2">
                            <a href="dashboard.php" class="btn btn-secondary btn-block">
                                <i class="fas fa-arrow-left"></i> Main Dashboard
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <?php include_once('includes/footer.php');?>
        </div>
    </div>
    <?php include_once('includes/footer2.php');?>
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="js/sb-admin-2.min.js"></script>
</body>
</html>
