<?php
session_start();
include_once('includes/config.php');
if (!isset($_SESSION['uid'])) {
    header('location:logout.php');
    exit();
}

// Function to format numbers in Indian format
function formatIndianCurrency($number) {
    $number = (float)$number;
    if ($number >= 10000000) { // 1 crore and above
        return 'Rs. ' . number_format($number / 10000000, 2) . ' Cr';
    } elseif ($number >= 100000) { // 1 lakh and above
        return 'Rs. ' . number_format($number / 100000, 2) . ' L';
    } else {
        return 'Rs. ' . number_format($number, 2);
    }
}

$userId = $_SESSION['uid'];
$userType = $_SESSION['usertype'];
$msg = "";

// DELETE BANK DETAILS (admin only)
if ($userType == 'admin' && isset($_GET['del_bank'])) {
    $bankid = intval($_GET['del_bank']);
    mysqli_query($con, "DELETE FROM tblbankdetails WHERE ID='$bankid'");
    $msg = "Bank details deleted successfully!";
}

// EDIT/UPDATE BANK DETAILS (admin only)
$editBank = null;
if ($userType == 'admin' && isset($_GET['edit_bank'])) {
    $bankid = intval($_GET['edit_bank']);
    $editRes = mysqli_query($con, "SELECT * FROM tblbankdetails WHERE ID='$bankid'");
    $editBank = mysqli_fetch_assoc($editRes);
}

if ($userType == 'admin' && isset($_POST['update_bank'])) {
    $bankid = intval($_POST['bankid']);
    $bankName = mysqli_real_escape_string($con, $_POST['bank_name']);
    $accountNumber = mysqli_real_escape_string($con, $_POST['account_number']);
    $ifscCode = mysqli_real_escape_string($con, $_POST['ifsc_code']);
    $accountType = mysqli_real_escape_string($con, $_POST['account_type']);
    $branchName = mysqli_real_escape_string($con, $_POST['branch_name']);
    $accountHolderName = mysqli_real_escape_string($con, $_POST['account_holder_name']);
    $openingBalance = floatval($_POST['opening_balance']);
    $currentBalance = floatval($_POST['current_balance']);
    $isActive = isset($_POST['is_active']) ? 1 : 0;
    
    $res = mysqli_query($con, "UPDATE tblbankdetails SET 
        BankName='$bankName', 
        AccountNumber='$accountNumber', 
        IFSCCode='$ifscCode', 
        AccountType='$accountType', 
        BranchName='$branchName', 
        AccountHolderName='$accountHolderName', 
        OpeningBalance='$openingBalance', 
        CurrentBalance='$currentBalance', 
        IsActive='$isActive' 
        WHERE ID='$bankid'");
    
    $msg = $res ? "Bank details updated successfully!" : "Error updating bank details!";
    $editBank = null;
}

// CREATE BANK DETAILS (admin only)
if ($userType == 'admin' && isset($_POST['add_bank'])) {
    $bankName = mysqli_real_escape_string($con, $_POST['bank_name']);
    $accountNumber = mysqli_real_escape_string($con, $_POST['account_number']);
    $ifscCode = mysqli_real_escape_string($con, $_POST['ifsc_code']);
    $accountType = mysqli_real_escape_string($con, $_POST['account_type']);
    $branchName = mysqli_real_escape_string($con, $_POST['branch_name']);
    $accountHolderName = mysqli_real_escape_string($con, $_POST['account_holder_name']);
    $openingBalance = floatval($_POST['opening_balance']);
    $currentBalance = floatval($_POST['current_balance']);
    $isActive = isset($_POST['is_active']) ? 1 : 0;
    
    $res = mysqli_query($con, "INSERT INTO tblbankdetails 
        (BankName, AccountNumber, IFSCCode, AccountType, BranchName, AccountHolderName, OpeningBalance, CurrentBalance, IsActive, AddedBy) 
        VALUES ('$bankName', '$accountNumber', '$ifscCode', '$accountType', '$branchName', '$accountHolderName', '$openingBalance', '$currentBalance', '$isActive', '$userId')");
    
    $msg = $res ? "Bank details added successfully!" : "Error adding bank details!";
}

// READ (fetch all bank details)
$banks = mysqli_query($con, "SELECT b.*, u.FullName FROM tblbankdetails b LEFT JOIN tblusers u ON b.AddedBy=u.ID ORDER BY b.CreatedDate DESC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Ihita Industries | Bank Details Management</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="css/sb-admin-2.min.css" rel="stylesheet">
    <style>
        .card { border-radius: 1rem; }
        .card-header { border-radius: 1rem 1rem 0 0; }
        .form-control, .btn { font-size: 1.1rem; border-radius: 2rem; }
        .btn-block { padding: 0.75rem 0; }
        .table th, .table td { vertical-align: middle !important; }
        .status-active { color: #28a745; font-weight: bold; }
        .status-inactive { color: #dc3545; font-weight: bold; }
        @media (max-width: 767.98px) {
            .container, .container-fluid { padding-left: 0.5rem; padding-right: 0.5rem; }
            .card { margin-bottom: 1.2rem; }
            .table-responsive { font-size: 0.95rem; }
            .btn, .btn-block { font-size: 1rem; padding: 0.6rem 0.75rem; }
            .card-header h4, .card-header h5 { font-size: 1.1rem; }
        }
    </style>
</head>
<body id="page-top">
    <div id="wrapper">
        <?php include_once('includes/sidebar.php');?>
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include_once('includes/topbar.php');?>
                <div class="container-fluid mt-3 mb-3">
                    <h1 class="h3 mb-4 text-gray-800">Bank Details Management</h1>
                    <?php if($msg) { ?>
                        <div class="alert alert-info text-center"><?php echo $msg; ?></div>
                    <?php } ?>

                    <?php if($userType == 'admin' && !$editBank) { ?>
                    <!-- Add Bank Details Form -->
                    <div class="card shadow mb-4">
                        <div class="card-header bg-success text-white text-center">
                            <h4 class="mb-0">Add Bank Details</h4>
                        </div>
                        <div class="card-body">
                            <form method="post" autocomplete="off">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Bank Name</label>
                                            <input type="text" name="bank_name" class="form-control" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Account Number</label>
                                            <input type="text" name="account_number" class="form-control" required>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>IFSC Code</label>
                                            <input type="text" name="ifsc_code" class="form-control" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Account Type</label>
                                            <select name="account_type" class="form-control" required>
                                                <option value="">Select</option>
                                                <option value="Savings">Savings</option>
                                                <option value="Current">Current</option>
                                                <option value="Fixed Deposit">Fixed Deposit</option>
                                                <option value="Overdraft">Overdraft</option>
                                                <option value="Cash Credit">Cash Credit</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Branch Name</label>
                                            <input type="text" name="branch_name" class="form-control" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Account Holder Name</label>
                                            <input type="text" name="account_holder_name" class="form-control" required>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Opening Balance</label>
                                            <input type="number" step="0.01" name="opening_balance" class="form-control" value="0.00">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Current Balance</label>
                                            <input type="number" step="0.01" name="current_balance" class="form-control" value="0.00">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" id="is_active" name="is_active" checked>
                                        <label class="custom-control-label" for="is_active">Active Account</label>
                                    </div>
                                </div>
                                <button type="submit" name="add_bank" class="btn btn-success btn-block">Add Bank Details</button>
                            </form>
                        </div>
                    </div>
                    <?php } ?>

                    <?php if($userType == 'admin' && $editBank) { ?>
                    <!-- Edit Bank Details Form -->
                    <div class="card shadow mb-4">
                        <div class="card-header bg-warning text-white text-center">
                            <h4 class="mb-0">Edit Bank Details</h4>
                        </div>
                        <div class="card-body">
                            <form method="post" autocomplete="off">
                                <input type="hidden" name="bankid" value="<?php echo $editBank['ID']; ?>">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Bank Name</label>
                                            <input type="text" name="bank_name" class="form-control" required value="<?php echo htmlspecialchars($editBank['BankName']); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Account Number</label>
                                            <input type="text" name="account_number" class="form-control" required value="<?php echo htmlspecialchars($editBank['AccountNumber']); ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>IFSC Code</label>
                                            <input type="text" name="ifsc_code" class="form-control" required value="<?php echo htmlspecialchars($editBank['IFSCCode']); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Account Type</label>
                                            <select name="account_type" class="form-control" required>
                                                <option value="">Select</option>
                                                <option value="Savings" <?php if($editBank['AccountType']=='Savings') echo 'selected'; ?>>Savings</option>
                                                <option value="Current" <?php if($editBank['AccountType']=='Current') echo 'selected'; ?>>Current</option>
                                                <option value="Fixed Deposit" <?php if($editBank['AccountType']=='Fixed Deposit') echo 'selected'; ?>>Fixed Deposit</option>
                                                <option value="Overdraft" <?php if($editBank['AccountType']=='Overdraft') echo 'selected'; ?>>Overdraft</option>
                                                <option value="Cash Credit" <?php if($editBank['AccountType']=='Cash Credit') echo 'selected'; ?>>Cash Credit</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Branch Name</label>
                                            <input type="text" name="branch_name" class="form-control" required value="<?php echo htmlspecialchars($editBank['BranchName']); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Account Holder Name</label>
                                            <input type="text" name="account_holder_name" class="form-control" required value="<?php echo htmlspecialchars($editBank['AccountHolderName']); ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Opening Balance</label>
                                            <input type="number" step="0.01" name="opening_balance" class="form-control" value="<?php echo htmlspecialchars($editBank['OpeningBalance']); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Current Balance</label>
                                            <input type="number" step="0.01" name="current_balance" class="form-control" value="<?php echo htmlspecialchars($editBank['CurrentBalance']); ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" id="is_active_edit" name="is_active" <?php if($editBank['IsActive']) echo 'checked'; ?>>
                                        <label class="custom-control-label" for="is_active_edit">Active Account</label>
                                    </div>
                                </div>
                                <button type="submit" name="update_bank" class="btn btn-warning btn-block">Update Bank Details</button>
                                <a href="bank-management.php" class="btn btn-secondary btn-block mt-2">Cancel Edit</a>
                            </form>
                        </div>
                    </div>
                    <?php } ?>

                    <!-- Bank Details Table -->
                    <div class="card shadow mb-4">
                        <div class="card-header bg-info text-white text-center">
                            <h5 class="mb-0">Company Bank Details</h5>
                        </div>
                        <div class="card-body p-2">
                            <div class="table-responsive">
                            <table class="table table-bordered table-sm mb-0">
                                <thead class="thead-light">
                                    <tr>
                                        <th>#</th>
                                        <th>Bank Name</th>
                                        <th>Account Number</th>
                                        <th>IFSC Code</th>
                                        <th>Account Type</th>
                                        <th>Branch</th>
                                        <th>Account Holder</th>
                                        <th>Opening Balance</th>
                                        <th>Current Balance</th>
                                        <th>Status</th>
                                        <th>Added By</th>
                                        <th>Created Date</th>
                                        <?php if($userType == 'admin') { ?><th>Actions</th><?php } ?>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php $i=1; while($row = mysqli_fetch_assoc($banks)) { ?>
                                    <tr>
                                        <td><?php echo $i++; ?></td>
                                        <td><?php echo htmlspecialchars($row['BankName']); ?></td>
                                        <td><?php echo htmlspecialchars($row['AccountNumber']); ?></td>
                                        <td><?php echo htmlspecialchars($row['IFSCCode']); ?></td>
                                        <td><?php echo htmlspecialchars($row['AccountType']); ?></td>
                                        <td><?php echo htmlspecialchars($row['BranchName']); ?></td>
                                        <td><?php echo htmlspecialchars($row['AccountHolderName']); ?></td>
                                        <td class="text-right"><?php echo formatIndianCurrency($row['OpeningBalance']); ?></td>
                                        <td class="text-right"><?php echo formatIndianCurrency($row['CurrentBalance']); ?></td>
                                        <td>
                                            <?php if($row['IsActive']) { ?>
                                                <span class="status-active"><i class="fas fa-check-circle"></i> Active</span>
                                            <?php } else { ?>
                                                <span class="status-inactive"><i class="fas fa-times-circle"></i> Inactive</span>
                                            <?php } ?>
                                        </td>
                                        <td><?php echo htmlspecialchars($row['FullName']); ?></td>
                                        <td><?php echo date('d-m-Y', strtotime($row['CreatedDate'])); ?></td>
                                        <?php if($userType == 'admin') { ?>
                                        <td>
                                            <div class="d-flex flex-wrap gap-1">
                                                <a href="bank-management.php?edit_bank=<?php echo $row['ID']; ?>" class="btn btn-sm btn-warning mb-1">Edit</a>
                                                <a href="bank-management.php?del_bank=<?php echo $row['ID']; ?>" class="btn btn-sm btn-danger mb-1" onclick="return confirm('Delete this bank details?');">Delete</a>
                                            </div>
                                        </td>
                                        <?php } ?>
                                    </tr>
                                <?php } ?>
                                </tbody>
                            </table>
                            </div>
                        </div>
                    </div>

                    <a href="dashboard.php" class="btn btn-link btn-block mt-3">Back to Dashboard</a>
                </div>
            </div>
            <?php include_once('includes/footer.php');?>
        </div>
    </div>
    <?php include_once('includes/footer2.php');?>
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="js/sb-admin-2.min.js"></script>
</body>
</html>
