<?php
session_start();
include_once('../includes/config.php');

// Only authenticated users can access this API
if (!isset($_SESSION['uid'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit();
}

// Set content type to JSON
header('Content-Type: application/json');

// Get search term from query parameter
$searchTerm = isset($_GET['q']) ? mysqli_real_escape_string($con, $_GET['q']) : '';

if (empty($searchTerm)) {
    echo json_encode([]);
    exit();
}

// First check if table exists
$tableCheck = mysqli_query($con, "SHOW TABLES LIKE 'tblbeneficiaries'");
if (mysqli_num_rows($tableCheck) == 0) {
    echo json_encode(['error' => 'Beneficiaries table not found. Please run the SQL setup first.']);
    exit();
}

// Search beneficiaries by name (case-insensitive)
$query = "SELECT BeneficiaryName, BeneficiaryType, ContactPerson 
          FROM tblbeneficiaries 
          WHERE IsActive = 1 
          AND BeneficiaryName LIKE '%$searchTerm%' 
          ORDER BY BeneficiaryName ASC 
          LIMIT 10";

$result = mysqli_query($con, $query);

if (!$result) {
    echo json_encode(['error' => 'Database error: ' . mysqli_error($con)]);
    exit();
}

$beneficiaries = [];
while ($row = mysqli_fetch_assoc($result)) {
    $beneficiaries[] = [
        'name' => $row['BeneficiaryName'],
        'type' => $row['BeneficiaryType'],
        'contact' => $row['ContactPerson']
    ];
}

echo json_encode($beneficiaries);
?>
