<?php
session_start();
include_once('includes/config.php');
if (!isset($_SESSION['uid'])) {
    header('location:logout.php');
    exit();
}

// Function to format numbers in Indian format
function formatIndianCurrency($number) {
    $number = (float)$number;
    if ($number >= 10000000) { // 1 crore and above
        return 'Rs. ' . number_format($number / 10000000, 2) . ' Cr';
    } elseif ($number >= 100000) { // 1 lakh and above
        return 'Rs. ' . number_format($number / 100000, 2) . ' L';
    } else {
        return 'Rs. ' . number_format($number, 2);
    }
}

$userId = $_SESSION['uid'];
$userType = $_SESSION['usertype'];
$msg = "";

// Ensure uploads/vouchers directory exists
$voucherDir = 'uploads/vouchers/';
if (!is_dir($voucherDir)) {
    mkdir($voucherDir, 0777, true);
}

// DELETE EXPENSE (admin or owner)
if (isset($_GET['del_expense'])) {
    $expid = intval($_GET['del_expense']);
    $canDelete = false;
    if ($userType == 'admin') {
        $canDelete = true;
    } else {
        $chk = mysqli_query($con, "SELECT ID FROM tblexpenses WHERE ID='$expid' AND UserID='$userId'");
        if (mysqli_num_rows($chk) > 0) $canDelete = true;
    }
    if ($canDelete) {
        $res = mysqli_query($con, "SELECT VoucherImage FROM tblexpenses WHERE ID='$expid'");
        $row = mysqli_fetch_assoc($res);
        if ($row && $row['VoucherImage'] && file_exists($row['VoucherImage'])) {
            unlink($row['VoucherImage']);
        }
        mysqli_query($con, "DELETE FROM tblexpenses WHERE ID='$expid'");
        $msg = "Expense deleted successfully!";
    }
}

// EDIT/UPDATE EXPENSE (admin or owner)
$editExpense = null;
if (isset($_GET['edit_expense'])) {
    $expid = intval($_GET['edit_expense']);
    $canEdit = false;
    if ($userType == 'admin') {
        $canEdit = true;
    } else {
        $chk = mysqli_query($con, "SELECT ID FROM tblexpenses WHERE ID='$expid' AND UserID='$userId'");
        if (mysqli_num_rows($chk) > 0) $canEdit = true;
    }
    if ($canEdit) {
        $editRes = mysqli_query($con, "SELECT * FROM tblexpenses WHERE ID='$expid'");
        $editExpense = mysqli_fetch_assoc($editRes);
    }
}
if (isset($_POST['update_expense'])) {
    $expid = intval($_POST['expid']);
    $title = mysqli_real_escape_string($con, $_POST['expense_title']);
    $amount = floatval($_POST['expense_amount']);
    $paymentMode = mysqli_real_escape_string($con, $_POST['payment_mode']);
    $details = mysqli_real_escape_string($con, $_POST['expense_details']);
    $entryDate = mysqli_real_escape_string($con, $_POST['entry_date']);
    $voucher = "";
    if (isset($_FILES['voucher_image']) && $_FILES['voucher_image']['error'] == 0) {
        $ext = strtolower(pathinfo($_FILES['voucher_image']['name'], PATHINFO_EXTENSION));
        $allowed = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
        if (in_array($ext, $allowed)) {
            $voucher = $voucherDir . 'voucher_' . $expid . '.' . $ext;
            // Remove old image
            $_result = mysqli_query($con, "SELECT VoucherImage FROM tblexpenses WHERE ID='$expid'"); $old = $_result ? mysqli_fetch_assoc($_result) : null;
            if ($old && $old['VoucherImage'] && file_exists($old['VoucherImage'])) unlink($old['VoucherImage']);
            move_uploaded_file($_FILES['voucher_image']['tmp_name'], $voucher);
        }
    }
    $setVoucher = $voucher ? ", VoucherImage='$voucher'" : "";
    mysqli_query($con, "UPDATE tblexpenses SET ExpenseTitle='$title', ExpenseAmount='$amount', PaymentMode='$paymentMode', ExpenseDetails='$details', EntryDate='$entryDate' $setVoucher WHERE ID='$expid'");
    $msg = "Expense updated successfully!";
    $editExpense = null;
}

// CREATE EXPENSE
if (isset($_POST['add_expense'])) {
    $title = mysqli_real_escape_string($con, $_POST['expense_title']);
    $amount = floatval($_POST['expense_amount']);
    $paymentMode = mysqli_real_escape_string($con, $_POST['payment_mode']);
    $details = mysqli_real_escape_string($con, $_POST['expense_details']);
    $entryDate = mysqli_real_escape_string($con, $_POST['entry_date']);
    $voucher = "";
    // Insert first to get the ID
    $res = mysqli_query($con, "INSERT INTO tblexpenses (UserID, ExpenseTitle, ExpenseAmount, PaymentMode, ExpenseDetails, EntryDate) VALUES ('$userId', '$title', '$amount', '$paymentMode', '$details', '$entryDate')");
    if ($res) {
        $expid = mysqli_insert_id($con);
        if (isset($_FILES['voucher_image']) && $_FILES['voucher_image']['error'] == 0) {
            $ext = strtolower(pathinfo($_FILES['voucher_image']['name'], PATHINFO_EXTENSION));
            $allowed = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
            if (in_array($ext, $allowed)) {
                $voucher = $voucherDir . 'voucher_' . $expid . '.' . $ext;
                move_uploaded_file($_FILES['voucher_image']['tmp_name'], $voucher);
                mysqli_query($con, "UPDATE tblexpenses SET VoucherImage='$voucher' WHERE ID='$expid'");
            }
        }
        $msg = "Expense submitted successfully!";
    } else {
        $msg = "Error submitting expense!";
    }
}

// READ (fetch own expenses for staff, all for admin)
$expenses = ($userType == 'admin')
    ? mysqli_query($con, "SELECT e.*, u.FullName FROM tblexpenses e LEFT JOIN tblusers u ON e.UserID=u.ID ORDER BY e.EntryDate DESC, e.ExpenseDate DESC")
    : mysqli_query($con, "SELECT * FROM tblexpenses WHERE UserID='$userId' ORDER BY EntryDate DESC, ExpenseDate DESC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Ihita Industries | Expense Entry</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="css/sb-admin-2.min.css" rel="stylesheet">
    <style>
        .card { 
            border-radius: 1.5rem; 
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
            border: none;
            margin-bottom: 2rem;
        }
        .card-header { 
            border-radius: 1.5rem 1.5rem 0 0; 
            padding: 1.5rem;
        }
        .card-header.bg-success {
            background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
        }
        .card-header.bg-warning {
            background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%);
            color: #000 !important;
        }
        .form-control { 
            font-size: 1rem; 
            border-radius: 1rem; 
            padding: 0.875rem 1.25rem;
            border: 2px solid #e3e6f0;
            transition: all 0.3s ease;
        }
        .form-control:focus {
            border-color: #1cc88a;
            box-shadow: 0 0 0 0.2rem rgba(28, 200, 138, 0.25);
        }
        .btn { 
            font-size: 1rem; 
            border-radius: 1rem; 
            padding: 0.75rem 1.5rem;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        .btn-block { 
            padding: 1rem 0; 
            border-radius: 1rem;
        }
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 0.25rem 0.5rem rgba(0, 0, 0, 0.2);
        }
        .table th, .table td { 
            vertical-align: middle !important; 
            padding: 1rem 0.75rem;
        }
        .table th {
            background: linear-gradient(135deg, #f8f9fc 0%, #e9ecef 100%);
            font-weight: 600;
            border-top: none;
        }
        .voucher-thumb { 
            max-width: 60px; 
            max-height: 60px; 
            border-radius: 0.5rem;
            border: 2px solid #e3e6f0;
            transition: transform 0.3s ease;
        }
        .voucher-thumb:hover {
            transform: scale(1.1);
        }
        .table-responsive {
            border-radius: 1rem;
            overflow: hidden;
        }
        .alert {
            border-radius: 1rem;
            border: none;
            font-weight: 500;
        }
        .form-group {
            margin-bottom: 1.5rem;
        }
        .form-group label {
            font-weight: 600;
            color: #5a5c69;
            margin-bottom: 0.5rem;
        }
        .d-flex.gap-1 {
            gap: 0.25rem;
        }
        
        /* Mobile Styles */
        @media (max-width: 991.98px) {
            .container-fluid { 
                padding-left: 1rem; 
                padding-right: 1rem; 
            }
            .card { 
                margin-bottom: 1.5rem; 
                border-radius: 1rem;
            }
            .card-header {
                padding: 1rem;
                border-radius: 1rem 1rem 0 0;
            }
            .card-body {
                padding: 1.5rem;
            }
        }
        
        @media (max-width: 767.98px) {
            .container-fluid { 
                padding-left: 0.75rem; 
                padding-right: 0.75rem; 
            }
            .card { 
                margin-bottom: 1.25rem;
                border-radius: 0.75rem;
            }
            .card-header {
                padding: 0.75rem;
                border-radius: 0.75rem 0.75rem 0 0;
            }
            .card-body {
                padding: 1rem;
            }
            .table-responsive { 
                font-size: 0.875rem;
                border-radius: 0.75rem;
            }
            .table th, .table td {
                padding: 0.5rem 0.25rem;
                font-size: 0.8rem;
            }
            .btn, .btn-block { 
                font-size: 0.9rem; 
                padding: 0.6rem 1rem; 
                border-radius: 0.75rem;
            }
            .btn-sm {
                font-size: 0.75rem;
                padding: 0.25rem 0.5rem;
                margin: 0.1rem 0;
            }
            .card-header h4, .card-header h5 { 
                font-size: 1rem; 
                margin-bottom: 0;
            }
            .form-control {
                font-size: 0.9rem;
                padding: 0.75rem 1rem;
                border-radius: 0.75rem;
            }
            .form-group {
                margin-bottom: 1rem;
            }
            .alert {
                font-size: 0.9rem;
                padding: 0.75rem;
            }
            .voucher-thumb {
                max-width: 40px;
                max-height: 40px;
            }
            .d-flex.flex-wrap {
                flex-direction: column;
            }
            .d-flex.flex-wrap .btn {
                margin-bottom: 0.25rem;
                width: 100%;
            }
        }
        
        @media (max-width: 575.98px) {
            .table-responsive {
                border-radius: 0.5rem;
            }
            .table th, .table td {
                padding: 0.4rem 0.2rem;
                font-size: 0.75rem;
            }
            .btn-sm {
                font-size: 0.7rem;
                padding: 0.2rem 0.4rem;
                margin: 0.1rem;
            }
            .card {
                border-radius: 0.5rem;
            }
            .card-header {
                border-radius: 0.5rem 0.5rem 0 0;
                padding: 0.5rem;
            }
            .card-body {
                padding: 0.75rem;
            }
            .voucher-thumb {
                max-width: 30px;
                max-height: 30px;
            }
            /* Stack table for very small screens */
            .table-responsive table,
            .table-responsive thead,
            .table-responsive tbody,
            .table-responsive th,
            .table-responsive td,
            .table-responsive tr {
                display: block;
            }
            .table-responsive thead tr {
                position: absolute;
                top: -9999px;
                left: -9999px;
            }
            .table-responsive tr {
                border: 1px solid #ccc;
                margin-bottom: 0.5rem;
                border-radius: 0.5rem;
                padding: 0.5rem;
                background: #fff;
            }
            .table-responsive td {
                border: none;
                position: relative;
                padding: 0.25rem 0.25rem 0.25rem 30%;
                text-align: left;
            }
            .table-responsive td:before {
                content: attr(data-label) ": ";
                position: absolute;
                left: 0.25rem;
                width: 25%;
                padding-right: 0.5rem;
                white-space: nowrap;
                font-weight: bold;
                color: #5a5c69;
            }
            .d-flex.flex-wrap .btn {
                font-size: 0.7rem;
                padding: 0.3rem 0.5rem;
                margin: 0.1rem 0;
            }
        }
        
        @media print {
            body * { visibility: hidden; }
            #printVoucher, #printVoucher * { visibility: visible; }
            #printVoucher { position: absolute; left: 0; top: 0; width: 100%; }
        }
    </style>
</head>
<body id="page-top">
    <div id="wrapper">
        <?php include_once('includes/sidebar.php');?>
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include_once('includes/topbar.php');?>
                <div class="container-fluid mt-3 mb-3">
                    <h1 class="h3 mb-4 text-gray-800">Expense Entry</h1>
                    <?php if($msg) { ?>
                        <div class="alert alert-info text-center"><?php echo $msg; ?></div>
                    <?php } ?>

                    <?php if(!$editExpense) { ?>
                    <!-- Add Expense Form -->
                    <div class="card shadow mb-4">
                        <div class="card-header bg-success text-white text-center">
                            <h4 class="mb-0">Add Expense</h4>
                        </div>
                        <div class="card-body">
                            <form method="post" enctype="multipart/form-data" autocomplete="off">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Entry Date</label>
                                            <input type="date" name="entry_date" class="form-control" required value="<?php echo date('Y-m-d'); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Expense Title</label>
                                            <input type="text" name="expense_title" class="form-control" required>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Amount</label>
                                            <input type="number" step="0.01" name="expense_amount" class="form-control" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Payment Mode</label>
                                            <div class="d-flex flex-wrap pt-2">
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" type="radio" name="payment_mode" id="payment_cash_add" value="Cash" required>
                                                    <label class="form-check-label" for="payment_cash_add">Cash</label>
                                                </div>
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" type="radio" name="payment_mode" id="payment_bank_add" value="Bank Transfer">
                                                    <label class="form-check-label" for="payment_bank_add">Bank Transfer</label>
                                                </div>
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" type="radio" name="payment_mode" id="payment_cheque_add" value="Cheque">
                                                    <label class="form-check-label" for="payment_cheque_add">Cheque</label>
                                                </div>
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" type="radio" name="payment_mode" id="payment_upi_add" value="UPI">
                                                    <label class="form-check-label" for="payment_upi_add">UPI</label>
                                                </div>
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" type="radio" name="payment_mode" id="payment_other_add" value="Other">
                                                    <label class="form-check-label" for="payment_other_add">Other</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>Details</label>
                                    <textarea name="expense_details" class="form-control" rows="2"></textarea>
                                </div>
                                <div class="form-group">
                                    <label>Voucher Image (Optional)</label>
                                    <input type="file" name="voucher_image" class="form-control" accept="image/*">
                                </div>
                                <button type="submit" name="add_expense" class="btn btn-success btn-block">Submit Expense</button>
                            </form>
                        </div>
                    </div>
                    <?php } ?>

                    <?php if($editExpense) { ?>
                    <!-- Edit Expense Form -->
                    <div class="card shadow mb-4">
                        <div class="card-header bg-warning text-center">
                            <h4 class="mb-0">Edit Expense</h4>
                        </div>
                        <div class="card-body">
                            <form method="post" enctype="multipart/form-data" autocomplete="off">
                                <input type="hidden" name="expid" value="<?php echo $editExpense['ID']; ?>">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Entry Date</label>
                                            <input type="date" name="entry_date" class="form-control" required value="<?php echo htmlspecialchars($editExpense['EntryDate']); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Expense Title</label>
                                            <input type="text" name="expense_title" class="form-control" required value="<?php echo htmlspecialchars($editExpense['ExpenseTitle']); ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Amount</label>
                                            <input type="number" step="0.01" name="expense_amount" class="form-control" required value="<?php echo htmlspecialchars($editExpense['ExpenseAmount']); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Payment Mode</label>
                                            <div class="d-flex flex-wrap pt-2">
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" type="radio" name="payment_mode" id="payment_cash_edit" value="Cash" required <?php if($editExpense['PaymentMode']=='Cash') echo 'checked'; ?>>
                                                    <label class="form-check-label" for="payment_cash_edit">Cash</label>
                                                </div>
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" type="radio" name="payment_mode" id="payment_bank_edit" value="Bank Transfer" <?php if($editExpense['PaymentMode']=='Bank Transfer') echo 'checked'; ?>>
                                                    <label class="form-check-label" for="payment_bank_edit">Bank Transfer</label>
                                                </div>
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" type="radio" name="payment_mode" id="payment_cheque_edit" value="Cheque" <?php if($editExpense['PaymentMode']=='Cheque') echo 'checked'; ?>>
                                                    <label class="form-check-label" for="payment_cheque_edit">Cheque</label>
                                                </div>
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" type="radio" name="payment_mode" id="payment_upi_edit" value="UPI" <?php if($editExpense['PaymentMode']=='UPI') echo 'checked'; ?>>
                                                    <label class="form-check-label" for="payment_upi_edit">UPI</label>
                                                </div>
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" type="radio" name="payment_mode" id="payment_other_edit" value="Other" <?php if($editExpense['PaymentMode']=='Other') echo 'checked'; ?>>
                                                    <label class="form-check-label" for="payment_other_edit">Other</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>Details</label>
                                    <textarea name="expense_details" class="form-control" rows="2"><?php echo htmlspecialchars($editExpense['ExpenseDetails']); ?></textarea>
                                </div>
                                <div class="form-group">
                                    <label>Voucher Image (leave blank to keep current)</label>
                                    <input type="file" name="voucher_image" class="form-control" accept="image/*">
                                    <?php if($editExpense['VoucherImage']) { ?>
                                        <div class="mt-2">
                                            <img src="<?php echo htmlspecialchars($editExpense['VoucherImage']); ?>" class="voucher-thumb" alt="Voucher">
                                        </div>
                                    <?php } ?>
                                </div>
                                <button type="submit" name="update_expense" class="btn btn-warning btn-block">Update Expense</button>
                                <a href="add-expense.php" class="btn btn-secondary btn-block mt-2">Cancel Edit</a>
                            </form>
                        </div>
                    </div>
                    <?php } ?>

                    <!-- Expenses Table -->
                    <div class="card shadow mb-4">
                        <div class="card-header bg-warning text-center">
                            <h5 class="mb-0"><?php echo $userType == 'admin' ? 'All Expenses' : 'My Expenses'; ?></h5>
                        </div>
                        <div class="card-body p-2">
                            <div class="table-responsive">
                            <table class="table table-bordered table-sm mb-0">
                                <thead class="thead-light">
                                    <tr>
                                        <th>#</th>
                                        <th>Entry Date</th>
                                        <th>Title</th>
                                        <th>Amount</th>
                                        <th>Payment Mode</th>
                                        <th>Details</th>
                                        <?php if($userType == 'admin') { ?><th>Staff</th><?php } ?>
                                        <th>Date</th>
                                        <th>Voucher</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php $i=1; while($row = mysqli_fetch_assoc($expenses)) { ?>
                                    <tr>
                                        <td data-label="#"><?php echo $i++; ?></td>
                                        <td data-label="Entry Date"><?php echo htmlspecialchars($row['EntryDate']); ?></td>
                                        <td data-label="Title"><?php echo htmlspecialchars($row['ExpenseTitle']); ?></td>
                                        <td data-label="Amount"><?php echo formatIndianCurrency($row['ExpenseAmount']); ?></td>
                                        <td data-label="Payment Mode"><?php echo htmlspecialchars($row['PaymentMode']); ?></td>
                                        <td data-label="Details"><?php echo htmlspecialchars($row['ExpenseDetails']); ?></td>
                                        <?php if($userType == 'admin') { ?><td data-label="Staff"><?php echo htmlspecialchars($row['FullName']); ?></td><?php } ?>
                                        <td data-label="Date"><?php echo htmlspecialchars($row['ExpenseDate']); ?></td>
                                        <td data-label="Voucher">
                                            <?php if($row['VoucherImage']) { ?>
                                                <a href="<?php echo htmlspecialchars($row['VoucherImage']); ?>" target="_blank">
                                                    <img src="<?php echo htmlspecialchars($row['VoucherImage']); ?>" class="voucher-thumb" alt="Voucher">
                                                </a>
                                            <?php } else { echo "-"; } ?>
                                        </td>
                                        <td data-label="Actions">
                                            <div class="d-flex flex-wrap gap-1">
                                                <a href="print-voucher.php?id=<?php echo $row['ID']; ?>" target="_blank" class="btn btn-sm btn-info mb-1"><i class="fas fa-print"></i> Print</a>
                                                <?php
                                                $canEdit = ($userType == 'admin' || (isset($row['UserID']) && $row['UserID'] == $userId));
                                                if($canEdit) { ?>
                                                    <a href="add-expense.php?edit_expense=<?php echo $row['ID']; ?>" class="btn btn-sm btn-warning mb-1"><i class="fas fa-edit"></i> Edit</a>
                                                <?php }
                                                $canDelete = ($userType == 'admin' || (isset($row['UserID']) && $row['UserID'] == $userId));
                                                if($canDelete) { ?>
                                                    <a href="add-expense.php?del_expense=<?php echo $row['ID']; ?>" class="btn btn-sm btn-danger mb-1" onclick="return confirm('Delete this expense?');"><i class="fas fa-trash"></i> Delete</a>
                                                <?php } ?>
                                            </div>
                                        </td>
                                    </tr>
                                <?php } ?>
                                </tbody>
                            </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include_once('includes/footer.php');?>
        </div>
    </div>

    <?php include_once('includes/footer2.php');?>
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="js/sb-admin-2.min.js"></script>
</body>
</html>
          

    <?php include_once('includes/footer2.php');?>
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="js/sb-admin-2.min.js"></script>

    <script>
    function printVoucher(id, title, amount, paymentMode, details, entryDate, staffName) {
        const content = `
            <table style="width: 100%; border: 1px solid #333; border-collapse: collapse;">
                <tr>
                    <td style="border: 1px solid #333; padding: 10px; font-weight: bold; width: 25%;">Voucher No:</td>
                    <td style="border: 1px solid #333; padding: 10px;">${id}</td>
                    <td style="border: 1px solid #333; padding: 10px; font-weight: bold;">Date:</td>
                    <td style="border: 1px solid #333; padding: 10px;">${entryDate}</td>
                </tr>
                <tr>
                    <td style="border: 1px solid #333; padding: 10px; font-weight: bold;">Expense Title:</td>
                    <td style="border: 1px solid #333; padding: 10px;" colspan="3">${title}</td>
                </tr>
                <tr>
                    <td style="border: 1px solid #333; padding: 10px; font-weight: bold;">Amount:</td>
                    <td style="border: 1px solid #333; padding: 10px;">Rs. ${amount}</td>
                    <td style="border: 1px solid #333; padding: 10px; font-weight: bold;">Payment Mode:</td>
                    <td style="border: 1px solid #333; padding: 10px;">${paymentMode}</td>
                </tr>
                ${staffName ? `<tr><td style="border: 1px solid #333; padding: 10px; font-weight: bold;">Staff Name:</td><td style="border: 1px solid #333; padding: 10px;" colspan="3">${staffName}</td></tr>` : ''}
                <tr>
                    <td style="border: 1px solid #333; padding: 10px; font-weight: bold; vertical-align: top;">Details:</td>
                    <td style="border: 1px solid #333; padding: 10px;" colspan="3">${details || 'N/A'}</td>
                </tr>
            </table>
        `;
        
        document.getElementById('voucherContent').innerHTML = content;
        window.print();
    }
    </script>
</body>
</html>
