<?php
session_start();
include_once('includes/config.php');
if (!isset($_SESSION['uid'])) {
    header('location:logout.php');
    exit();
}
$userId = $_SESSION['uid'];
$userType = $_SESSION['usertype'];
$msg = "";

// DELETE TRANSACTION (admin only)
if ($userType == 'admin' && isset($_GET['del_transaction'])) {
    $transactionId = intval($_GET['del_transaction']);
    
    // Get transaction details for balance update
    $transRes = mysqli_query($con, "SELECT * FROM tblaccounttransactions WHERE ID='$transactionId'");
    $transaction = mysqli_fetch_assoc($transRes);
    
    if ($transaction) {
        // Update bank balance
        $bankId = $transaction['BankAccountID'];
        $amount = $transaction['TransactionAmount'];
        $type = $transaction['TransactionType'];
        
        if ($type == 'Credit') {
            // If deleting credit, subtract from current balance
            mysqli_query($con, "UPDATE tblbankdetails SET CurrentBalance = CurrentBalance - $amount WHERE ID='$bankId'");
        } else {
            // If deleting debit, add to current balance
            mysqli_query($con, "UPDATE tblbankdetails SET CurrentBalance = CurrentBalance + $amount WHERE ID='$bankId'");
        }
        
        // Delete transaction
        mysqli_query($con, "DELETE FROM tblaccounttransactions WHERE ID='$transactionId'");
        $msg = "Transaction deleted successfully!";
    }
}

// EDIT/UPDATE TRANSACTION (admin only)
$editTransaction = null;
if ($userType == 'admin' && isset($_GET['edit_transaction'])) {
    $transactionId = intval($_GET['edit_transaction']);
    $editRes = mysqli_query($con, "SELECT * FROM tblaccounttransactions WHERE ID='$transactionId'");
    $editTransaction = mysqli_fetch_assoc($editRes);
}

if ($userType == 'admin' && isset($_POST['update_transaction'])) {
    $transactionId = intval($_POST['transactionid']);
    $bankAccountId = intval($_POST['bank_account_id']);
    $transactionType = mysqli_real_escape_string($con, $_POST['transaction_type']);
    $transactionTitle = mysqli_real_escape_string($con, $_POST['transaction_title']);
    $transactionAmount = floatval($_POST['transaction_amount']);
    $referenceNumber = mysqli_real_escape_string($con, $_POST['reference_number']);
    $transactionDate = mysqli_real_escape_string($con, $_POST['transaction_date']);
    $transactionDetails = mysqli_real_escape_string($con, $_POST['transaction_details']);
    
    // Get old transaction details
    $oldRes = mysqli_query($con, "SELECT * FROM tblaccounttransactions WHERE ID='$transactionId'");
    $oldTransaction = mysqli_fetch_assoc($oldRes);
    
    if ($oldTransaction) {
        // Reverse old transaction from bank balance
        $oldAmount = $oldTransaction['TransactionAmount'];
        $oldType = $oldTransaction['TransactionType'];
        $oldBankId = $oldTransaction['BankAccountID'];
        
        if ($oldType == 'Credit') {
            mysqli_query($con, "UPDATE tblbankdetails SET CurrentBalance = CurrentBalance - $oldAmount WHERE ID='$oldBankId'");
        } else {
            mysqli_query($con, "UPDATE tblbankdetails SET CurrentBalance = CurrentBalance + $oldAmount WHERE ID='$oldBankId'");
        }
        
        // Update transaction
        $res = mysqli_query($con, "UPDATE tblaccounttransactions SET 
            BankAccountID='$bankAccountId', 
            TransactionType='$transactionType', 
            TransactionTitle='$transactionTitle', 
            TransactionAmount='$transactionAmount', 
            ReferenceNumber='$referenceNumber', 
            TransactionDate='$transactionDate', 
            TransactionDetails='$transactionDetails' 
            WHERE ID='$transactionId'");
        
        if ($res) {
            // Apply new transaction to bank balance
            if ($transactionType == 'Credit') {
                mysqli_query($con, "UPDATE tblbankdetails SET CurrentBalance = CurrentBalance + $transactionAmount WHERE ID='$bankAccountId'");
            } else {
                mysqli_query($con, "UPDATE tblbankdetails SET CurrentBalance = CurrentBalance - $transactionAmount WHERE ID='$bankAccountId'");
            }
            $msg = "Transaction updated successfully!";
        } else {
            $msg = "Error updating transaction!";
        }
    }
    $editTransaction = null;
}

// CREATE TRANSACTION (admin only)
if ($userType == 'admin' && isset($_POST['add_transaction'])) {
    $bankAccountId = intval($_POST['bank_account_id']);
    $transactionType = mysqli_real_escape_string($con, $_POST['transaction_type']);
    $transactionTitle = mysqli_real_escape_string($con, $_POST['transaction_title']);
    $transactionAmount = floatval($_POST['transaction_amount']);
    $referenceNumber = mysqli_real_escape_string($con, $_POST['reference_number']);
    $transactionDate = mysqli_real_escape_string($con, $_POST['transaction_date']);
    $transactionDetails = mysqli_real_escape_string($con, $_POST['transaction_details']);
    
    $res = mysqli_query($con, "INSERT INTO tblaccounttransactions 
        (BankAccountID, TransactionType, TransactionTitle, TransactionAmount, ReferenceNumber, TransactionDate, TransactionDetails, AddedBy) 
        VALUES ('$bankAccountId', '$transactionType', '$transactionTitle', '$transactionAmount', '$referenceNumber', '$transactionDate', '$transactionDetails', '$userId')");
    
    if ($res) {
        // Update bank balance
        if ($transactionType == 'Credit') {
            mysqli_query($con, "UPDATE tblbankdetails SET CurrentBalance = CurrentBalance + $transactionAmount WHERE ID='$bankAccountId'");
        } else {
            mysqli_query($con, "UPDATE tblbankdetails SET CurrentBalance = CurrentBalance - $transactionAmount WHERE ID='$bankAccountId'");
        }
        $msg = "Transaction added successfully!";
    } else {
        $msg = "Error adding transaction!";
    }
}

// Fetch active bank accounts for dropdown
$bankAccounts = mysqli_query($con, "SELECT * FROM tblbankdetails WHERE IsActive=1 ORDER BY BankName");

// Fetch transactions with bank details
$transactions = mysqli_query($con, "SELECT t.*, b.BankName, b.AccountNumber, u.FullName 
    FROM tblaccounttransactions t 
    LEFT JOIN tblbankdetails b ON t.BankAccountID=b.ID 
    LEFT JOIN tblusers u ON t.AddedBy=u.ID 
    ORDER BY t.TransactionDate DESC, t.CreatedDate DESC");

// Helper function for Indian number formatting
function formatINR($number) {
    $number = (float)$number;
    $negative = $number < 0;
    $number = abs($number);
    $decimal = '';
    if (strpos($number, '.') !== false) {
        $parts = explode('.', $number);
        $number = $parts[0];
        $decimal = isset($parts[1]) && $parts[1] ? '.' . substr($parts[1] . '00', 0, 2) : '';
    }
    $len = strlen($number);
    if ($len > 3) {
        $last3 = substr($number, -3);
        $restUnits = substr($number, 0, $len - 3);
        $restUnits = preg_replace("/\B(?=(\d{2})+(?!\d))/", ",", $restUnits);
        $formatted = $restUnits . "," . $last3;
    } else {
        $formatted = $number;
    }
    return ($negative ? '-' : '') . $formatted . $decimal;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Ihita Industries | Account Transactions</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="css/sb-admin-2.min.css" rel="stylesheet">
    <!-- jQuery UI for autocomplete -->
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/ui-lightness/jquery-ui.css">
    <style>
        .card { border-radius: 1rem; }
        .card-header { border-radius: 1rem 1rem 0 0; }
        .form-control, .btn { font-size: 1.1rem; border-radius: 2rem; }
        .btn-block { padding: 0.75rem 0; }
        .table th, .table td { vertical-align: middle !important; }
        .transaction-credit { color: #28a745; font-weight: bold; }
        .transaction-debit { color: #dc3545; font-weight: bold; }
        .balance-positive { color: #28a745; font-weight: bold; }
        .balance-negative { color: #dc3545; font-weight: bold; }
        @media (max-width: 767.98px) {
            .container, .container-fluid { padding-left: 0.5rem; padding-right: 0.5rem; }
            .card { margin-bottom: 1.2rem; }
            .table-responsive { font-size: 0.95rem; }
            .btn, .btn-block { font-size: 1rem; padding: 0.6rem 0.75rem; }
            .card-header h4, .card-header h5 { font-size: 1.1rem; }
        }
    </style>
</head>
<body id="page-top">
    <div id="wrapper">
        <?php include_once('includes/sidebar.php');?>
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include_once('includes/topbar.php');?>
                <div class="container-fluid mt-3 mb-3">
                    <h1 class="h3 mb-4 text-gray-800">Account Transactions</h1>
                    <?php if($msg) { ?>
                        <div class="alert alert-info text-center"><?php echo $msg; ?></div>
                    <?php } ?>

                    <!-- Bank Account Balances Summary -->
                    <div class="row mb-4">
                        <?php 
                        $bankSummary = mysqli_query($con, "SELECT * FROM tblbankdetails WHERE IsActive=1 ORDER BY BankName");
                        while($bank = mysqli_fetch_assoc($bankSummary)) {
                        ?>
                        <div class="col-md-3 mb-2">
                            <div class="card shadow-sm">
                                <div class="card-body text-center">
                                    <h6 class="card-title"><?php echo htmlspecialchars($bank['BankName']); ?></h6>
                                    <p class="card-text small"><?php echo htmlspecialchars($bank['AccountNumber']); ?></p>
                                    <h5 class="<?php echo ($bank['CurrentBalance'] >= 0) ? 'balance-positive' : 'balance-negative'; ?>">
                                        Rs. <?php echo formatINR($bank['CurrentBalance']); ?>
                                    </h5>
                                </div>
                            </div>
                        </div>
                        <?php } ?>
                    </div>

                    <?php if($userType == 'admin' && !$editTransaction) { ?>
                    <!-- Add Transaction Form -->
                    <div class="card shadow mb-4">
                        <div class="card-header bg-primary text-white text-center">
                            <h4 class="mb-0">Add Transaction</h4>
                        </div>
                        <div class="card-body">
                            <form method="post" autocomplete="off">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Bank Account</label>
                                            <select name="bank_account_id" class="form-control" required>
                                                <option value="">Select Bank Account</option>
                                                <?php 
                                                mysqli_data_seek($bankAccounts, 0);
                                                while($bank = mysqli_fetch_assoc($bankAccounts)) { ?>
                                                    <option value="<?php echo $bank['ID']; ?>">
                                                        <?php echo htmlspecialchars($bank['BankName'] . ' - ' . $bank['AccountNumber']); ?>
                                                    </option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Transaction Type</label>
                                            <select name="transaction_type" class="form-control" required>
                                                <option value="">Select</option>
                                                <option value="Credit">Credit (Money In)</option>
                                                <option value="Debit">Debit (Money Out)</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Transaction Title</label>
                                            <input type="text" name="transaction_title" id="transaction_title_add" class="form-control beneficiary-autocomplete" required placeholder="Start typing beneficiary name...">
                                            <small class="form-text text-muted">Type beneficiary name for suggestions</small>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Amount</label>
                                            <input type="number" step="0.01" name="transaction_amount" class="form-control" required>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Reference Number</label>
                                            <input type="text" name="reference_number" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Transaction Date</label>
                                            <input type="date" name="transaction_date" class="form-control" required value="<?php echo date('Y-m-d'); ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>Transaction Details</label>
                                    <textarea name="transaction_details" class="form-control" rows="2"></textarea>
                                </div>
                                <button type="submit" name="add_transaction" class="btn btn-primary btn-block">Add Transaction</button>
                            </form>
                        </div>
                    </div>
                    <?php } ?>

                    <?php if($userType == 'admin' && $editTransaction) { ?>
                    <!-- Edit Transaction Form -->
                    <div class="card shadow mb-4">
                        <div class="card-header bg-warning text-white text-center">
                            <h4 class="mb-0">Edit Transaction</h4>
                        </div>
                        <div class="card-body">
                            <form method="post" autocomplete="off">
                                <input type="hidden" name="transactionid" value="<?php echo $editTransaction['ID']; ?>">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Bank Account</label>
                                            <select name="bank_account_id" class="form-control" required>
                                                <option value="">Select Bank Account</option>
                                                <?php 
                                                mysqli_data_seek($bankAccounts, 0);
                                                while($bank = mysqli_fetch_assoc($bankAccounts)) { ?>
                                                    <option value="<?php echo $bank['ID']; ?>" <?php if($editTransaction['BankAccountID']==$bank['ID']) echo 'selected'; ?>>
                                                        <?php echo htmlspecialchars($bank['BankName'] . ' - ' . $bank['AccountNumber']); ?>
                                                    </option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Transaction Type</label>
                                            <select name="transaction_type" class="form-control" required>
                                                <option value="">Select</option>
                                                <option value="Credit" <?php if($editTransaction['TransactionType']=='Credit') echo 'selected'; ?>>Credit (Money In)</option>
                                                <option value="Debit" <?php if($editTransaction['TransactionType']=='Debit') echo 'selected'; ?>>Debit (Money Out)</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Transaction Title</label>
                                            <input type="text" name="transaction_title" id="transaction_title_edit" class="form-control beneficiary-autocomplete" required value="<?php echo htmlspecialchars($editTransaction['TransactionTitle']); ?>" placeholder="Start typing beneficiary name...">
                                            <small class="form-text text-muted">Type beneficiary name for suggestions</small>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Amount</label>
                                            <input type="number" step="0.01" name="transaction_amount" class="form-control" required value="<?php echo htmlspecialchars($editTransaction['TransactionAmount']); ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Reference Number</label>
                                            <input type="text" name="reference_number" class="form-control" value="<?php echo htmlspecialchars($editTransaction['ReferenceNumber']); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Transaction Date</label>
                                            <input type="date" name="transaction_date" class="form-control" required value="<?php echo htmlspecialchars($editTransaction['TransactionDate']); ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>Transaction Details</label>
                                    <textarea name="transaction_details" class="form-control" rows="2"><?php echo htmlspecialchars($editTransaction['TransactionDetails']); ?></textarea>
                                </div>
                                <button type="submit" name="update_transaction" class="btn btn-warning btn-block">Update Transaction</button>
                                <a href="account-transactions.php" class="btn btn-secondary btn-block mt-2">Cancel Edit</a>
                            </form>
                        </div>
                    </div>
                    <?php } ?>

                    <!-- Transactions Table -->
                    <div class="card shadow mb-4">
                        <div class="card-header bg-info text-white text-center">
                            <h5 class="mb-0">All Transactions</h5>
                        </div>
                        <div class="card-body p-2">
                            <div class="table-responsive">
                            <table class="table table-bordered table-sm mb-0">
                                <thead class="thead-light">
                                    <tr>
                                        <th>#</th>
                                        <th>Date</th>
                                        <th>Bank Account</th>
                                        <th>Type</th>
                                        <th>Title</th>
                                        <th>Amount</th>
                                        <th>Reference</th>
                                        <th>Details</th>
                                        <th>Added By</th>
                                        <th>Created</th>
                                        <?php if($userType == 'admin') { ?><th>Actions</th><?php } ?>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php $i=1; while($row = mysqli_fetch_assoc($transactions)) { ?>
                                    <tr>
                                        <td><?php echo $i++; ?></td>
                                        <td><?php echo date('d-m-Y', strtotime($row['TransactionDate'])); ?></td>
                                        <td>
                                            <small>
                                                <strong><?php echo htmlspecialchars($row['BankName']); ?></strong><br>
                                                <?php echo htmlspecialchars($row['AccountNumber']); ?>
                                            </small>
                                        </td>
                                        <td>
                                            <?php if($row['TransactionType'] == 'Credit') { ?>
                                                <span class="badge badge-success">Credit</span>
                                            <?php } else { ?>
                                                <span class="badge badge-danger">Debit</span>
                                            <?php } ?>
                                        </td>
                                        <td><?php echo htmlspecialchars($row['TransactionTitle']); ?></td>
                                        <td class="text-right <?php echo ($row['TransactionType'] == 'Credit') ? 'transaction-credit' : 'transaction-debit'; ?>">
                                            <?php echo ($row['TransactionType'] == 'Credit') ? '+' : '-'; ?>Rs. <?php echo formatINR($row['TransactionAmount']); ?>
                                        </td>
                                        <td><?php echo htmlspecialchars($row['ReferenceNumber'] ?: '-'); ?></td>
                                        <td><?php echo htmlspecialchars($row['TransactionDetails'] ?: '-'); ?></td>
                                        <td><?php echo htmlspecialchars($row['FullName']); ?></td>
                                        <td><?php echo date('d-m-Y H:i', strtotime($row['CreatedDate'])); ?></td>
                                        <?php if($userType == 'admin') { ?>
                                        <td>
                                            <div class="d-flex flex-wrap gap-1">
                                                <a href="account-transactions.php?edit_transaction=<?php echo $row['ID']; ?>" class="btn btn-sm btn-warning mb-1">Edit</a>
                                                <a href="account-transactions.php?del_transaction=<?php echo $row['ID']; ?>" class="btn btn-sm btn-danger mb-1" onclick="return confirm('Delete this transaction? This will also update bank balance.');">Delete</a>
                                            </div>
                                        </td>
                                        <?php } ?>
                                    </tr>
                                <?php } ?>
                                </tbody>
                            </table>
                            </div>
                        </div>
                    </div>

                    <a href="dashboard.php" class="btn btn-link btn-block mt-3">Back to Dashboard</a>
                </div>
            </div>
            <?php include_once('includes/footer.php');?>
        </div>
    </div>
    <?php include_once('includes/footer2.php');?>
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="js/sb-admin-2.min.js"></script>
    <!-- jQuery UI for autocomplete -->
    <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
    
    <script>
    $(document).ready(function() {
        // Initialize autocomplete for beneficiary names
        $('.beneficiary-autocomplete').autocomplete({
            source: function(request, response) {
                console.log('Searching for:', request.term);
                $.ajax({
                    url: 'api/beneficiary-search.php',
                    dataType: 'json',
                    data: {
                        q: request.term
                    },
                    success: function(data) {
                        console.log('API Response:', data);
                        if (data.error) {
                            console.error('API Error:', data.error);
                            response([{
                                label: 'Error: ' + data.error,
                                value: ''
                            }]);
                            return;
                        }
                        response($.map(data, function(item) {
                            return {
                                label: item.name + ' (' + item.type + ')',
                                value: item.name,
                                type: item.type,
                                contact: item.contact
                            };
                        }));
                    },
                    error: function(xhr, status, error) {
                        console.error('AJAX Error:', error);
                        console.error('Response:', xhr.responseText);
                        response([{
                            label: 'Connection error. Please try again.',
                            value: ''
                        }]);
                    }
                });
            },
            minLength: 2,
            select: function(event, ui) {
                // Optional: You can add additional logic here when a beneficiary is selected
                console.log('Selected beneficiary:', ui.item);
                if (ui.item.value === '') {
                    event.preventDefault();
                    return false;
                }
            },
            open: function() {
                $(this).removeClass("ui-corner-all").addClass("ui-corner-top");
            },
            close: function() {
                $(this).removeClass("ui-corner-top").addClass("ui-corner-all");
            }
        });
        
        // Style the autocomplete dropdown
        $('head').append(`
            <style>
                .ui-autocomplete {
                    max-height: 200px;
                    overflow-y: auto;
                    overflow-x: hidden;
                    z-index: 9999;
                    border: 1px solid #ddd;
                    border-radius: 0.375rem;
                    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
                    background: white;
                }
                .ui-menu-item {
                    padding: 0.5rem 1rem;
                    border-bottom: 1px solid #f8f9fa;
                    font-size: 0.9rem;
                    color: #333;
                    cursor: pointer;
                    transition: all 0.2s ease;
                }
                .ui-menu-item:hover {
                    background-color: #e3f2fd !important;
                    color: #1565c0 !important;
                    border-left: 3px solid #2196f3;
                }
                .ui-state-active, .ui-state-focus {
                    background-color: #e3f2fd !important;
                    color: #1565c0 !important;
                    border: none !important;
                    border-left: 3px solid #2196f3 !important;
                }
                .ui-menu-item div {
                    padding: 0;
                    color: inherit;
                }
                .ui-menu-item.ui-state-hover {
                    background-color: #e3f2fd !important;
                    color: #1565c0 !important;
                }
            </style>
        `);
        
        // Add a test button for debugging (remove in production)
        if (console) {
            console.log('Autocomplete initialized. Type at least 2 characters in Transaction Title field.');
        }
    });
    </script>
</body>
</html>
