# 🔧 Troubleshooting Guide for Beneficiary Autocomplete

## Quick Fix Steps

### Step 1: Create the Database Table
1. **Option A: Use phpMyAdmin**
   - Open phpMyAdmin
   - Select `ihita` database
   - Go to SQL tab
   - Copy and paste the contents of `beneficiary_table.sql`
   - Click "Go"

2. **Option B: Use the setup script**
   - Open your browser
   - Go to: `http://localhost/uzrs/Ihita/setup-database.php`
   - This will automatically create the table and insert sample data

### Step 2: Test the Setup
- Go to: `http://localhost/uzrs/Ihita/test-beneficiary.php`
- This will show if the table exists and has data
- Test the API endpoint

### Step 3: Test Autocomplete
1. Login as admin
2. Go to Banking > Credit / Debit Details
3. Try adding a new transaction
4. In the "Transaction Title" field, type at least 2 characters
5. You should see beneficiary suggestions

## Common Issues & Solutions

### Issue 1: "Table doesn't exist"
**Solution:** Run the SQL setup
```sql
-- Execute this in phpMyAdmin or use setup-database.php
-- Contents from beneficiary_table.sql
```

### Issue 2: "No suggestions appearing"
**Possible causes:**
1. **No beneficiaries in database**
   - Add some beneficiaries via Beneficiary Management
   - Or run the SQL setup which includes sample data

2. **JavaScript errors**
   - Open browser console (F12)
   - Look for error messages
   - Check if jQuery UI is loading

3. **API path issues**
   - Test API directly: `api/beneficiary-search.php?q=test`
   - Should return JSON response

### Issue 3: "AJAX errors"
**Debug steps:**
1. Open browser console (F12)
2. Try typing in the Transaction Title field
3. Look for error messages
4. Check Network tab for failed requests

### Issue 4: "jQuery UI not working"
**Check:**
- Internet connection (jQuery UI loads from CDN)
- Browser console for loading errors
- Try using local jQuery UI files

## Test URLs

After login, test these URLs:

1. **Setup Database:** `/setup-database.php`
2. **Test Setup:** `/test-beneficiary.php`
3. **Beneficiary Management:** `/beneficiary-management.php`
4. **Transactions with Autocomplete:** `/account-transactions.php`
5. **Test API:** `/api/beneficiary-search.php?q=a`

## Sample Data

The setup includes these sample beneficiaries:
- ABC Construction Ltd (Company)
- XYZ Suppliers (Company)
- Government Tax Office (Government)
- State Bank of India (Bank)
- Rajesh Kumar (Individual)

Try typing "ABC", "XYZ", or "Rajesh" in the Transaction Title field.

## Debug Console Commands

In browser console, you can test:

```javascript
// Test AJAX call
$.ajax({
    url: 'api/beneficiary-search.php',
    data: {q: 'a'},
    success: function(data) { console.log('Success:', data); },
    error: function(xhr) { console.log('Error:', xhr.responseText); }
});
```

## File Checklist

Ensure these files exist:
- ✅ `beneficiary_table.sql`
- ✅ `beneficiary-management.php`
- ✅ `api/beneficiary-search.php`
- ✅ `setup-database.php`
- ✅ `test-beneficiary.php`

## Browser Requirements

- JavaScript enabled
- jQuery and jQuery UI support
- Modern browser (Chrome, Firefox, Safari, Edge)

## Still Not Working?

1. **Check Apache/PHP logs** for errors
2. **Verify database connection** in `includes/config.php`
3. **Test with different browsers**
4. **Check WAMP/XAMPP status**
5. **Verify file permissions**

Contact admin if issues persist.
